/**
 * Copyright © 2017 Sven Ruppert (sven.ruppert@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.extension.unitest;

import static org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.ExtensionContextFunctions.containerInfo;
import static org.rapidpm.vaadin.addons.webdriver.junit5.WebdriverExtensionFunctions.webdriver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.ContainerInfo;
import org.rapidpm.vaadin.addons.testbench.junit5.pageobject.AbstractPageObject;
import org.rapidpm.vaadin.addons.testbench.junit5.pageobject.PageObject;
import xxx.com.github.webdriverextensions.WebDriverExtensionFieldDecorator;

/**
 *
 */
public class PageObjectExtension implements ParameterResolver, HasLogger {

  @Override
  public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext)
      throws ParameterResolutionException {
    final Class<?> type = parameterContext.getParameter().getType();
    return PageObject.class.isAssignableFrom(type) ;
  }

  @Override
  public AbstractPageObject resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext)
      throws ParameterResolutionException {
    logger().info("PageObjectExtension - resolveParameter");
    final WebDriver webDriver  = webdriver().apply(extensionContext);
    Class<?>        pageObjectClass = parameterContext.getParameter().getType();
    try {
      Constructor<?> constructor =
          pageObjectClass.getConstructor(WebDriver.class, ContainerInfo.class);
         AbstractPageObject page = AbstractPageObject.class
               .cast(constructor.newInstance(webDriver, containerInfo().apply(extensionContext)));
         PageFactory.initElements(
               new WebDriverExtensionFieldDecorator(webDriver), page);
         return page;
    } catch (NoSuchMethodException
        | IllegalAccessException
        | InstantiationException
        | InvocationTargetException e) {
      e.printStackTrace();
      throw new ParameterResolutionException("was not able to create PageObjectInstance ", e);
    }
  }


}
