/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.pageobject;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class WebElementUtil {
    private WebElementUtil() {
        throw new IllegalAccessError("Utitlity class");
    }

    public static String classIn(WebElement webElement) {
        return WebElementUtil.attributeIn("class", webElement);
    }

    public static List<String> classesIn(WebElement webElement) {
        return Arrays.asList(StringUtils.split((String)WebElementUtil.classIn(webElement)));
    }

    public static boolean hasClass(WebElement webElement) {
        return WebElementUtil.hasAttribute("class", webElement);
    }

    public static boolean hasNotClass(WebElement webElement) {
        return WebElementUtil.hasNotAttribute("class", webElement);
    }

    public static boolean hasClass(String className, WebElement webElement) {
        List<String> classes = WebElementUtil.classesIn(webElement);
        for (String clazz : classes) {
            if (!StringUtils.equals((CharSequence)className, (CharSequence)clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotClass(String className, WebElement webElement) {
        return !WebElementUtil.hasClass(className, webElement);
    }

    public static boolean hasClassContaining(String searchText, WebElement webElement) {
        List<String> classes = WebElementUtil.classesIn(webElement);
        for (String clazz : classes) {
            if (!StringUtils.contains((CharSequence)searchText, (CharSequence)clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotClassContaining(String searchText, WebElement webElement) {
        return !WebElementUtil.hasClassContaining(searchText, webElement);
    }

    public static boolean hasClassStartingWith(String prefix, WebElement webElement) {
        List<String> classes = WebElementUtil.classesIn(webElement);
        for (String clazz : classes) {
            if (!StringUtils.startsWith((CharSequence)prefix, (CharSequence)clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotClassStartingWith(String prefix, WebElement webElement) {
        return !WebElementUtil.hasClassStartingWith(prefix, webElement);
    }

    public static boolean hasClassEndingWith(String suffix, WebElement webElement) {
        List<String> classes = WebElementUtil.classesIn(webElement);
        for (String clazz : classes) {
            if (!StringUtils.endsWith((CharSequence)suffix, (CharSequence)clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotClassEndingWith(String suffix, WebElement webElement) {
        return !WebElementUtil.hasClassEndingWith(suffix, webElement);
    }

    public static boolean hasClassMatching(String regExp, WebElement webElement) {
        List<String> classes = WebElementUtil.classesIn(webElement);
        for (String clazz : classes) {
            if (!WebElementUtil.matches(regExp, clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotClassMatching(String regExp, WebElement webElement) {
        return !WebElementUtil.hasClassMatching(regExp, webElement);
    }

    public static String attributeIn(String name, WebElement webElement) {
        return webElement.getAttribute(name);
    }

    public static boolean hasAttribute(String name, WebElement webElement) {
        return webElement.getAttribute(name) != null;
    }

    public static boolean hasNotAttribute(String name, WebElement webElement) {
        return !WebElementUtil.hasAttribute(name, webElement);
    }

    private static boolean matches(String regularExpression, String text) {
        if (text == null || regularExpression == null) {
            return false;
        }
        return text.matches(regularExpression);
    }
}

