/*
 * Decompiled with CFR 0.152.
 */
package xxx.com.github.webdriverextensions.internal;

import java.lang.reflect.Field;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.Annotations;
import xxx.com.github.webdriverextensions.WebComponent;
import xxx.com.github.webdriverextensions.annotations.Delegate;
import xxx.com.github.webdriverextensions.annotations.ResetSearchContext;
import xxx.com.github.webdriverextensions.internal.ReflectionUtils;

public class WebDriverExtensionAnnotations
extends Annotations {
    private Field field;

    public WebDriverExtensionAnnotations(Field field) {
        super(field);
        this.field = field;
    }

    boolean isSearchContextReset() {
        return this.field.getAnnotation(ResetSearchContext.class) != null;
    }

    public static WebElement getDelagate(WebComponent webComponent) {
        WebElement delegate;
        Field[] fields = ReflectionUtils.getAnnotatedDeclaredFields(webComponent.getClass(), Delegate.class);
        if (fields.length == 0) {
            return null;
        }
        if (fields.length > 1) {
            throw new RuntimeException("More than one @Delagate annotation used. There should only exist one.");
        }
        try {
            fields[0].setAccessible(true);
            delegate = (WebElement)fields[0].get(webComponent);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return delegate;
    }
}

