/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.extension.compattest;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.frp.functions.CheckedFunction;
import org.rapidpm.frp.memoizer.Memoizer;
import org.rapidpm.frp.model.Result;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.ContainerInfo;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.ExtensionContextFunctions;
import org.rapidpm.vaadin.addons.testbench.junit5.pageobject.PageObject;
import org.rapidpm.vaadin.addons.webdriver.BrowserDriverFunctions;
import org.rapidpm.vaadin.addons.webdriver.WebDriverFunctions;
import org.rapidpm.vaadin.addons.webdriver.junit5.WebdriverExtensionFunctions;
import xxx.com.github.webdriverextensions.WebDriverExtensionFieldDecorator;

public class PageObjectInvocationContextProvider
implements TestTemplateInvocationContextProvider,
HasLogger {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        this.logger().info("provideTestTemplateInvocationContexts");
        return BrowserDriverFunctions.webDriverInstances().stream().map(this::invocationContext).peek(po -> {
            this.logger().info("peek - page object -> setting as webDriver into Store ");
            WebdriverExtensionFunctions.storeWebDriver().accept(context, po.webdriver());
        }).map(e -> e);
    }

    private WebDriverTemplateInvocationContext invocationContext(Supplier<WebDriver> webdriverSupplier) {
        return new WebDriverTemplateInvocationContextImpl(webdriverSupplier);
    }

    private final class WebDriverTemplateInvocationContextImpl
    implements WebDriverTemplateInvocationContext {
        private final Supplier<WebDriver> webdriverSupplier;

        private WebDriverTemplateInvocationContextImpl(Supplier<WebDriver> webdriverSupplier) {
            this.webdriverSupplier = Memoizer.memoize(webdriverSupplier);
        }

        @Override
        public WebDriver webdriver() {
            return this.webdriverSupplier.get();
        }

        public String getDisplayName(int invocationIndex) {
            return (String)WebDriverFunctions.webdriverName().apply(this.webdriver());
        }

        public List<Extension> getAdditionalExtensions() {
            return Collections.singletonList(new ParameterResolver(){

                public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                    Class<?> type = parameterContext.getParameter().getType();
                    return PageObject.class.isAssignableFrom(type);
                }

                public PageObject resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                    Class<?> pageObjectClass = parameterContext.getParameter().getType();
                    Result po = ((CheckedFunction)aClass -> {
                        Constructor constructor = pageObjectClass.getConstructor(WebDriver.class, ContainerInfo.class);
                        WebDriver webDriver = WebDriverTemplateInvocationContextImpl.this.webdriver();
                        PageObject page = (PageObject)PageObject.class.cast(constructor.newInstance(webDriver, ExtensionContextFunctions.containerInfo().apply(extensionContext)));
                        PageFactory.initElements((FieldDecorator)new WebDriverExtensionFieldDecorator(webDriver), (Object)page);
                        return page;
                    }).apply(pageObjectClass);
                    po.ifPresentOrElse(success -> PageObjectInvocationContextProvider.this.logger().fine("pageobject of type " + pageObjectClass.getSimpleName() + " was created with " + (String)WebDriverFunctions.webdriverName().apply(WebDriverTemplateInvocationContextImpl.this.webdriver())), failed -> PageObjectInvocationContextProvider.this.logger().warning("was not able to create PageObjectInstance " + failed));
                    po.ifAbsent(() -> {
                        throw new ParameterResolutionException("was not able to create PageObjectInstance of type " + pageObjectClass);
                    });
                    return (PageObject)po.get();
                }
            });
        }
    }

    public static interface WebDriverTemplateInvocationContext
    extends TestTemplateInvocationContext {
        public WebDriver webdriver();
    }
}

