/*
 * Decompiled with CFR 0.152.
 */
package xxx.com.github.webdriverextensions;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import xxx.com.github.webdriverextensions.WebComponent;
import xxx.com.github.webdriverextensions.WebPage;
import xxx.com.github.webdriverextensions.WebRepository;
import xxx.com.github.webdriverextensions.WebSite;
import xxx.com.github.webdriverextensions.internal.DefaultWebComponentFactory;
import xxx.com.github.webdriverextensions.internal.DefaultWebComponentListFactory;
import xxx.com.github.webdriverextensions.internal.ObjectPool;
import xxx.com.github.webdriverextensions.internal.ReflectionUtils;
import xxx.com.github.webdriverextensions.internal.WebComponentFactory;
import xxx.com.github.webdriverextensions.internal.WebComponentListFactory;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionAnnotations;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionElementLocatorFactory;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionException;

public class WebDriverExtensionFieldDecorator
extends DefaultFieldDecorator {
    private final WebDriver driver;
    private final ObjectPool pool;
    private final WebComponentFactory webComponentFactory;
    private final WebComponentListFactory webComponentListFactory;
    private ParameterizedType genericTypeArguments;

    public void setGenericTypeArguments(ParameterizedType genericTypeArguments) {
        this.genericTypeArguments = genericTypeArguments;
    }

    public WebDriverExtensionFieldDecorator(WebDriver driver) {
        super((ElementLocatorFactory)new WebDriverExtensionElementLocatorFactory((SearchContext)driver, driver));
        this.driver = driver;
        this.pool = new ObjectPool(driver);
        this.webComponentFactory = new DefaultWebComponentFactory();
        this.webComponentListFactory = new DefaultWebComponentListFactory(this.webComponentFactory);
        this.genericTypeArguments = null;
    }

    public WebDriverExtensionFieldDecorator(SearchContext searchContext, WebDriver driver) {
        super((ElementLocatorFactory)new WebDriverExtensionElementLocatorFactory(searchContext, driver));
        this.driver = driver;
        this.pool = new ObjectPool(driver);
        this.webComponentFactory = new DefaultWebComponentFactory();
        this.webComponentListFactory = new DefaultWebComponentListFactory(this.webComponentFactory);
        this.genericTypeArguments = null;
    }

    public WebDriverExtensionFieldDecorator(SearchContext searchContext, WebDriver driver, ParameterizedType genericTypeArguments) {
        super((ElementLocatorFactory)new WebDriverExtensionElementLocatorFactory(searchContext, driver));
        this.driver = driver;
        this.pool = new ObjectPool(driver);
        this.webComponentFactory = new DefaultWebComponentFactory();
        this.webComponentListFactory = new DefaultWebComponentListFactory(this.webComponentFactory);
        this.genericTypeArguments = genericTypeArguments;
    }

    public Object decorate(ClassLoader loader, Field field) {
        try {
            if (this.isDecoratableWebComponent(field)) {
                if (field.getGenericType() instanceof TypeVariable) {
                    return this.decorateWebComponent(loader, field, this.genericTypeArguments);
                }
                if (field.getGenericType() instanceof ParameterizedType) {
                    return this.decorateWebComponent(loader, field, (ParameterizedType)field.getGenericType());
                }
                return this.decorateWebComponent(loader, field, null);
            }
            if (this.isDecoratableWebComponentList(field)) {
                Type listType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (listType instanceof TypeVariable) {
                    return this.decorateWebComponentList(loader, field, this.genericTypeArguments);
                }
                if (listType instanceof ParameterizedType) {
                    return this.decorateWebComponentList(loader, field, (ParameterizedType)listType);
                }
                return this.decorateWebComponentList(loader, field, null);
            }
            if (this.isDecoratableSiteObject(field)) {
                return this.pool.getSiteObject(field, this);
            }
            if (this.isDecoratablePageObject(field)) {
                return this.pool.getPageObject(field, this);
            }
            if (this.isDecoratableRepositoryObject(field)) {
                return this.pool.getRepositoryObject(field, this);
            }
            if ("wrappedWebElement".equals(field.getName())) {
                return null;
            }
            if ("delegateWebElement".equals(field.getName())) {
                return null;
            }
            return super.decorate(loader, field);
        }
        catch (Exception ex) {
            if (ex instanceof WebDriverExtensionException) {
                throw (WebDriverExtensionException)ex;
            }
            throw new WebDriverExtensionException("Failed to decorate field " + field.getName() + " in class " + field.getDeclaringClass(), ex);
        }
    }

    private boolean isDecoratableWebComponent(Field field) {
        return WebComponent.class.isAssignableFrom(field.getType());
    }

    private boolean isDecoratableWebComponentList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        if (listType instanceof TypeVariable ? !WebComponent.class.isAssignableFrom(ReflectionUtils.getListType(field, this.genericTypeArguments)) : (listType instanceof ParameterizedType ? !WebComponent.class.isAssignableFrom((Class)((ParameterizedType)listType).getRawType()) : !WebComponent.class.isAssignableFrom((Class)listType))) {
            return false;
        }
        return field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null || field.getAnnotation(FindAll.class) != null;
    }

    private boolean isDecoratablePageObject(Field field) {
        return WebPage.class.isAssignableFrom(field.getType());
    }

    private boolean isDecoratableSiteObject(Field field) {
        return WebSite.class.isAssignableFrom(field.getType());
    }

    private boolean isDecoratableRepositoryObject(Field field) {
        return WebRepository.class.isAssignableFrom(field.getType());
    }

    private Object decorateWebComponent(ClassLoader loader, Field field, ParameterizedType genericTypeArguments) {
        ElementLocator locator = this.factory.createLocator(field);
        Class type = ReflectionUtils.getType(field, genericTypeArguments);
        WebElement webElement = this.proxyForLocator(loader, locator);
        Object webComponent = this.webComponentFactory.create(type, webElement, this.driver);
        PageFactory.initElements((FieldDecorator)new WebDriverExtensionFieldDecorator((SearchContext)webElement, this.driver, genericTypeArguments), webComponent);
        ((WebComponent)webComponent).delegateWebElement = WebDriverExtensionAnnotations.getDelagate(webComponent);
        return webComponent;
    }

    private Object decorateWebComponentList(ClassLoader loader, Field field, ParameterizedType genericTypeArguments) {
        ElementLocator locator = this.factory.createLocator(field);
        Class listType = ReflectionUtils.getListType(field, genericTypeArguments);
        List webElements = this.proxyForListLocator(loader, locator);
        return this.webComponentListFactory.create(listType, webElements, this.driver, genericTypeArguments);
    }
}

