/*
 * Decompiled with CFR 0.152.
 */
package xxx.com.github.webdriverextensions.internal;

import java.lang.reflect.Field;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import xxx.com.github.webdriverextensions.annotations.ResetSearchContext;
import xxx.com.github.webdriverextensions.internal.WebDriverExtensionAnnotations;

public class WebDriverExtensionElementLocator
implements ElementLocator {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    public WebDriverExtensionElementLocator(SearchContext searchContext, Field field, WebDriver driver) {
        WebDriverExtensionAnnotations annotations = new WebDriverExtensionAnnotations(field);
        this.searchContext = annotations.isSearchContextReset() ? driver : searchContext;
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        WebElement element = this.searchContext.findElement(this.by);
        if (this.shouldCache) {
            this.cachedElement = element;
        }
        return element;
    }

    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List elements = this.searchContext.findElements(this.by);
        if (this.shouldCache) {
            this.cachedElementList = elements;
        }
        return elements;
    }

    private boolean hasAnnotatedResetSearchContext(Field field) {
        ResetSearchContext annotation = field.getAnnotation(ResetSearchContext.class);
        return annotation != null;
    }
}

