/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.nano;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import javax.servlet.ServletException;
import org.rapidpm.dependencies.core.logger.HasLogger;
import org.rapidpm.frp.model.Result;
import org.rapidpm.vaadin.nano.Config;
import org.rapidpm.vaadin.nano.CoreServlet;

public class CoreUIService
implements HasLogger {
    public static final String CORE_UI_SERVER_HOST_DEFAULT = "0.0.0.0";
    public static final String CORE_UI_SERVER_PORT_DEFAULT = "8899";
    public static final String CORE_UI_SERVER_HOST = "core-ui-server-host";
    public static final String CORE_UI_SERVER_PORT = "core-ui-server-port";
    public Result<Undertow> undertow = Result.failure((String)"not initialised so far");
    private Result<Config> configResult = Result.failure((String)"not init so far");

    public void startup(Config config) {
        this.configResult = Result.ofNullable((Object)((Object)config));
        this.startup();
    }

    public void startup() {
        DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(CoreUIService.class.getClassLoader()).setContextPath("/").setDeploymentName("ROOT.war").setDefaultEncoding("UTF-8").addServlets(new ServletInfo[]{Servlets.servlet((String)CoreServlet.class.getSimpleName(), CoreServlet.class).addMapping("/*").setAsyncSupported(true)});
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(servletBuilder);
        manager.deploy();
        try {
            PathHandler path = Handlers.path((HttpHandler)Handlers.redirect((String)"/")).addPrefixPath("/", manager.start());
            Integer port = this.configResult.isPresent() != false ? ((Config)((Object)this.configResult.get())).port() : Integer.valueOf(System.getProperty(CORE_UI_SERVER_PORT, CORE_UI_SERVER_PORT_DEFAULT));
            String host = this.configResult.isPresent() != false ? ((Config)((Object)this.configResult.get())).host() : System.getProperty(CORE_UI_SERVER_HOST, CORE_UI_SERVER_HOST_DEFAULT);
            Undertow u = Undertow.builder().addHttpListener(port.intValue(), host).setHandler((HttpHandler)path).build();
            u.start();
            u.getListenerInfo().forEach(e -> this.logger().info(e.toString()));
            this.undertow = Result.success((Object)u);
        }
        catch (ServletException e2) {
            e2.printStackTrace();
            this.undertow = Result.failure((String)e2.getMessage());
        }
    }
}

