/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.component.pdfviewer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import java.net.URI;

@Tag(value="pdf-browser-viewer")
@JsModule(value="@lrnwebcomponents/pdf-browser-viewer/pdf-browser-viewer.js")
@NpmPackage(value="@lrnwebcomponents/pdf-browser-viewer", version="2.2.0")
public class PdfViewer
extends Component {
    public static final String NOT_SUPPORTED_MESSAGE = "not-supported-message";
    public static final String NOT_SUPPORTED_LINK_MESSAGE = "not-supported-link-message";
    public static final String CARD = "card";
    public static final String DOWNLOAD_LABEL = "downloadLabel";
    public static final String ELEVATION = "elevation";
    public static final String HEIGHT = "height";
    public static final String WIDTH = "width";
    public static final String FILE = "file";
    private StreamRegistration streamRegistration;

    public void setStreamResource(StreamResource streamResource) {
        this.unregister();
        this.streamRegistration = VaadinSession.getCurrent().getResourceRegistry().registerResource((AbstractStreamResource)streamResource);
        URI uri = StreamResourceRegistry.getURI((AbstractStreamResource)streamResource);
        String file = uri.toASCIIString();
        this.setFile(file);
    }

    public void setFile(String file) {
        this.getElement().setAttribute(FILE, file);
    }

    public void setNotSupportedMessage(String message) {
        this.getElement().setAttribute(NOT_SUPPORTED_MESSAGE, message);
    }

    public void setNotSupportedLinkMessage(String message) {
        this.getElement().setAttribute(NOT_SUPPORTED_LINK_MESSAGE, message);
    }

    public void setCard(boolean card) {
        this.getElement().setAttribute(CARD, card);
    }

    public void setDownloadLabel(String label) {
        this.getElement().setAttribute(DOWNLOAD_LABEL, label);
    }

    public void setElevation(String elevation) {
        this.getElement().setAttribute(ELEVATION, elevation);
    }

    public void setHeight(String height) {
        this.getElement().setAttribute(HEIGHT, height);
        this.getElement().getStyle().set(HEIGHT, height);
    }

    public void setWidth(String width) {
        this.getElement().setAttribute(WIDTH, width);
        this.getElement().getStyle().set(WIDTH, width);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.unregister();
    }

    private void unregister() {
        if (this.streamRegistration != null) {
            this.streamRegistration.unregister();
            this.streamRegistration = null;
        }
    }
}

