/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class Client {
    private static final String DEFAULT_SERVER = "localhost";
    private static final int DEFAULT_PORT = 7001;
    private static String server = "localhost";
    private static int port = 7001;

    private static void communicate() {
        System.out.println("server=" + server + ", port=" + port);
        try {
            Socket socket = new Socket(server, port);
            PrintStream ps = new PrintStream(socket.getOutputStream());
            ps.print("Hello " + server + " at port " + port + " !\n");
            ps.flush();
            BufferedReader ds = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            System.out.println("server delivered: '" + ds.readLine());
            ps.close();
            ds.close();
            socket.close();
            System.out.println("socket closed.");
        }
        catch (UnknownHostException e2) {
            System.out.println("host unknown: " + e2.getMessage());
        }
        catch (IOException e1) {
            System.out.println("io exception: " + e1.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println("Socket test started.");
        if (args.length != 0 && args.length != 2) {
            System.out.println("usage: java Client [server port]");
        } else if (args.length == 2) {
            server = args[0];
            try {
                port = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                System.err.println("Error: illegal port parameter: " + args[1]);
                return;
            }
        }
        Client.communicate();
        System.out.println("Socket test done.");
    }
}

