/*
 * Decompiled with CFR 0.152.
 */
import org.odmg.DBag;
import org.odmg.Database;
import org.odmg.DatabaseIsReadOnlyException;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import org.odmg.TransactionNotInProgressException;
import rasj.RasImplementation;

public class TestDbTa {
    static final String PREFIX_PROGRAM = "+++ +++ +++ ";
    static final String PREFIX_TESTSET = "+++ +++ ";
    static final String PREFIX_TESTCASE = "+++ ";
    static final String ERROR_TAG = "ERROR: ";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 7001;
    static final String DEFAULT_BASE = "RASBASE";
    static final String DEFAULT_USER = "rasguest";
    static final String DEFAULT_PASSWD = "rasguest";
    static RasImplementation myApp = null;

    public static void main(String[] argv) throws Exception {
        String serv = DEFAULT_HOST;
        int port = 7001;
        String base = DEFAULT_BASE;
        String user = "rasguest";
        String passwd = "rasguest";
        boolean wrongUsage = false;
        for (int i = argv.length - 1; i >= 0; --i) {
            if (argv[i].equals("--server")) {
                serv = argv[i + 1];
                continue;
            }
            if (argv[i].equals("--port")) {
                try {
                    port = Integer.parseInt(argv[i + 1]);
                }
                catch (Exception e) {
                    wrongUsage = true;
                }
                continue;
            }
            if (argv[i].equals("--database")) {
                base = argv[i + 1];
                continue;
            }
            if (argv[i].equals("--user")) {
                user = argv[i + 1];
                continue;
            }
            if (!argv[i].equals("--passwd")) continue;
            passwd = argv[i + 1];
        }
        if (wrongUsage) {
            System.out.println("Usage: TestDbTa [--server s] [--port p] [--database d] [--user u] [--passwd p]");
            System.out.println("defaults: server=localhost, port=7001, database=RASBASE, user=rasguest, passwd=rasguest");
            System.exit(-1);
        }
        System.out.println("rasdaman system test v5.1revC: testing class ODMG logic.");
        System.out.println("+++ +++ +++ system test started, using server " + serv + ", port " + port + ", database " + base + ", user=" + user + ", passwd=" + passwd);
        myApp = new RasImplementation("http://" + serv + ":" + port);
        myApp.setUserIdentification(user, passwd);
        TestDbTa.testDatabase(myApp, base);
        TestDbTa.testTransaction(myApp, base);
        TestDbTa.testAccessMode(myApp, base);
        System.out.println("+++ +++ +++ system test done.");
    }

    static void testDatabase(RasImplementation myApp, String database) {
        Transaction myTa;
        Database myDb = null;
        System.out.println("+++ +++ testing database open/close started.");
        System.out.print("+++ open db, null name...");
        try {
            myDb = myApp.newDatabase();
            myDb.open(null, 1);
            System.out.println("ERROR: does not catch this.");
        }
        catch (Exception e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ open db, empty name...");
        try {
            myDb = myApp.newDatabase();
            myDb.open("", 1);
            System.out.println("ERROR: does not catch this.");
        }
        catch (Exception e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ open db, nonexisting db...");
        try {
            myDb = myApp.newDatabase();
            myDb.open("NO_SUCH_DATABASE", 1);
            System.out.println("ERROR: does not catch this.");
        }
        catch (Exception e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ open db, good call...");
        try {
            myDb = myApp.newDatabase();
            myDb.open(database, 1);
            myTa = myApp.newTransaction();
            myTa.begin();
            myTa.abort();
            System.out.println("OK, tested through beginTA.");
        }
        catch (Exception e) {
            System.out.println("ERROR: good call does not open db: " + e.getMessage());
        }
        System.out.print("+++ close previously opened db...");
        try {
            myDb.close();
            System.out.println("OK.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ can we open a transaction after closing db...");
        try {
            myTa = myApp.newTransaction();
            myTa.begin();
            System.out.println("ERROR: unfortunately yes.");
        }
        catch (Exception e) {
            System.out.println("OK, we can't.");
        }
        System.out.print("+++ close db already closed...");
        try {
            myDb.close();
            System.out.println("ERROR: repeated close possible, alas.");
        }
        catch (Exception e) {
            System.out.println("OK.");
        }
        System.out.println("+++ +++ testing database open/close done.\n");
    }

    static void testTransaction(RasImplementation myApp, String database) throws ODMGException {
        DBag result;
        OQLQuery myQu;
        Database myDb = null;
        Transaction myTa = null;
        System.out.println("+++ +++ testing transaction start.");
        System.out.print("+++ isOpen on open DB, closed TA...");
        try {
            myDb = myApp.newDatabase();
            myDb.open(database, 1);
            myTa = myApp.newTransaction();
            if (myTa.isOpen()) {
                System.out.println("ERROR: TA open on closed DB.");
            } else {
                System.out.println("OK, is not open.");
            }
        }
        catch (Exception e) {
            System.out.println("OK: " + e.getMessage());
        }
        System.out.print("+++ isOpen on open DB/TA...");
        try {
            myTa.begin();
            if (myTa.isOpen()) {
                System.out.println("OK, is open.");
            } else {
                System.out.println("ERROR: TA not open after opening.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ sending query to check open TA...");
        try {
            myQu = myApp.newOQLQuery();
            myQu.create("select r from RAS_COLLECTIONNAMES as r");
            result = (DBag)myQu.execute();
            if (result == null) {
                System.out.println("ERROR: standard query failed.");
            } else {
                System.out.println("OK, query done.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ open TA on an already open TA...");
        try {
            myTa.begin();
            if (myTa.isOpen()) {
                System.out.println("OK, should remain open.");
            } else {
                System.out.println("ERROR: TA not open after 2nd opening.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ abort TA...");
        try {
            myTa.abort();
            if (myTa.isOpen()) {
                System.out.println("ERROR: TA open after abort.");
            } else {
                System.out.println("OK, is not open.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ query on aborted TA...");
        try {
            myQu = myApp.newOQLQuery();
            myQu.create("select r from RAS_COLLECTIONNAMES as r");
            result = (DBag)myQu.execute();
            if (result == null) {
                System.out.println("OK, standard query failed.");
            } else {
                System.out.println("ERROR: query got through.");
            }
        }
        catch (Exception e) {
            System.out.println("OK, failed: " + e.getMessage());
        }
        System.out.print("+++ abort TA on aborted TA...");
        try {
            myTa.abort();
            if (myTa.isOpen()) {
                System.out.println("ERROR: TA open after abort.");
            } else {
                System.out.println("OK, is not open.");
            }
        }
        catch (Exception e) {
            System.out.println("OK, noticed: " + e.getMessage());
        }
        System.out.print("+++ open new TA, send query...");
        try {
            myTa.begin();
            if (!myTa.isOpen()) {
                System.out.println("ERROR: TA not open.");
            } else {
                myQu = myApp.newOQLQuery();
                myQu.create("select r from RAS_COLLECTIONNAMES as r");
                result = (DBag)myQu.execute();
                if (result == null) {
                    System.out.println("ERROR: standard query failed.");
                } else {
                    System.out.println("OK.");
                }
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ commit TA...");
        try {
            myTa.commit();
            if (myTa.isOpen()) {
                System.out.println("OK, closed now. ");
            } else {
                System.out.println("ERROR: TA still open. ");
            }
            myQu = myApp.newOQLQuery();
            myQu.create("select r from RAS_COLLECTIONNAMES as r");
            result = (DBag)myQu.execute();
            if (result == null) {
                System.out.println("OK, query failed.");
            } else {
                System.out.println("ERROR: query got through.");
            }
        }
        catch (TransactionNotInProgressException e) {
            System.out.println("...OK, query failed: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.println("+++ +++ testing transaction done.\n");
    }

    static void testAccessMode(RasImplementation myApp, String database) {
        DBag result;
        OQLQuery myQu;
        Database myDb = null;
        Transaction myTa = null;
        System.out.println("+++ +++ testing accessMode start.");
        System.out.print("+++ open readonly, read query...");
        try {
            myDb = myApp.newDatabase();
            myDb.open(database, 1);
            myTa = myApp.newTransaction();
            myTa.begin();
            myQu = myApp.newOQLQuery();
            myQu.create("select r from RAS_COLLECTIONNAMES as r");
            result = (DBag)myQu.execute();
            if (result == null) {
                System.out.println("ERROR: query failed.");
            } else {
                System.out.println("OK, query got through.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ open readonly, update query (create collection)...");
        try {
            myDb = myApp.newDatabase();
            myDb.open(database, 1);
            myTa = myApp.newTransaction();
            myTa.begin();
            myQu = myApp.newOQLQuery();
            myQu.create("create collection TestDbTa_collection GreySet");
            result = (DBag)myQu.execute();
        }
        catch (DatabaseIsReadOnlyException e) {
            System.out.println("OK, update failed.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ commit TA, close DB...");
        try {
            myTa.commit();
            myDb.close();
            System.out.println("OK.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ open DB readwrite, open TA, read query...");
        try {
            myDb.open(database, 2);
            myTa = myApp.newTransaction();
            myTa.begin();
            myQu = myApp.newOQLQuery();
            myQu.create("select r from RAS_COLLECTIONNAMES as r");
            result = (DBag)myQu.execute();
            if (result == null) {
                System.out.println("ERROR: query failed.");
            } else {
                System.out.println("OK, query got through.");
            }
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ update query (create & drop collection)...");
        try {
            myQu = myApp.newOQLQuery();
            myQu.create("create collection TestDbTa_collection GreySet");
            result = (DBag)myQu.execute();
            System.out.print("re-opening TA...");
            myTa.commit();
            myTa.begin();
            myQu.create("drop collection TestDbTa_collection");
            result = (DBag)myQu.execute();
            System.out.println("OK, query got through.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.print("+++ commit TA, close DB...");
        try {
            myTa.commit();
            myDb.close();
            System.out.println("OK.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG + e.getMessage());
        }
        System.out.println("+++ +++ testing accessMode done.\n");
    }
}

