/*
 * Decompiled with CFR 0.152.
 */
import org.odmg.Database;
import rasj.RasClientInternalException;
import rasj.RasConnectionFailedException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIllegalULongValueException;
import rasj.RasIllegalUShortValueException;
import rasj.RasImplementation;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasInvalidNameException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasPrimitiveType;
import rasj.RasQueryExecutionFailedException;
import rasj.RasResultIsNoCellException;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStreamInputOverflowException;
import rasj.RasTypeInvalidException;
import rasj.RasTypeNotSupportedException;

public class TestException {
    static final String PREFIX_PROGRAM = "+++ +++ +++ ";
    static final String PREFIX_TESTSET = "+++ +++ ";
    static final String PREFIX_TESTCASE = "+++ ";
    static final String ERROR_TAG = "ERROR: ";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 7001;
    static final String DEFAULT_BASE = "RASBASE";
    static final String DEFAULT_USER = "rasguest";
    static final String DEFAULT_PASSWD = "rasguest";

    public static void main(String[] args) throws Exception {
        String server = DEFAULT_HOST;
        int port = 7001;
        String base = DEFAULT_BASE;
        String user = "rasguest";
        String passwd = "rasguest";
        boolean wrongUsage = false;
        if (args.length == 0) {
            wrongUsage = true;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("--server")) {
                server = args[i + 1];
                continue;
            }
            if (args[i].equals("--port")) {
                try {
                    port = Integer.parseInt(args[i + 1]);
                }
                catch (Exception e) {
                    wrongUsage = true;
                }
                continue;
            }
            if (args[i].equals("--database")) {
                base = args[i + 1];
                continue;
            }
            if (args[i].equals("--user")) {
                user = args[i + 1];
                continue;
            }
            if (!args[i].equals("--passwd")) continue;
            passwd = args[i + 1];
        }
        if (wrongUsage) {
            System.err.println("Usage: TestException [--server s] [--port p] [--database d]");
            System.out.println("defaults: server=localhost, port=7001, database=RASBASE, user=rasguest, passwd=rasguest");
            System.exit(-1);
        }
        System.out.println("rasdaman system test v5.1revC: testing exceptions.");
        System.out.println("+++ +++ +++ system test started, using server " + server + ", port " + port + ", database " + base + ", user=" + user + ", passwd=" + passwd);
        RasImplementation myApp = new RasImplementation("http://" + server + ":" + port);
        myApp.setUserIdentification(user, passwd);
        TestException.testExceptions(myApp, base);
        System.out.println("+++ +++ +++ system test done.");
    }

    static void testExceptions(RasImplementation imp, String database) throws Exception {
        boolean resultIsOk = false;
        Database myDb = null;
        Object myTa = null;
        Object myQu = null;
        System.out.println("+++ +++ testing exceptions started.");
        System.out.print("+++ provoking RasConnectionFailedException...");
        try {
            RasImplementation errorApp = new RasImplementation("wrongserver:8080");
            myDb = errorApp.newDatabase();
            myDb.open(database, 2);
            System.out.println("ERROR: does not catch this.");
            myDb.close();
        }
        catch (RasConnectionFailedException e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ provoking RasDimensionMismatchException...");
        try {
            RasMInterval test2 = new RasMInterval("[1:20,1:20]");
            RasMInterval test3 = new RasMInterval("[1:4,1:9,1:6]");
            RasMInterval test1 = test2.intersectionWith(test3);
            System.out.println("ERROR: does not catch this.");
        }
        catch (RasDimensionMismatchException e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ provoking RasIndexOutOfBoundsException...");
        try {
            RasGMArray myMDD = new RasGMArray(new RasMInterval("[1:5,1:5]"), 1L);
            byte[] retVal = myMDD.getCell(new RasPoint(4L, 7L));
            System.out.println("ERROR: does not catch this.");
        }
        catch (RasIndexOutOfBoundsException e) {
            System.out.println("OK, recognized: " + e.getMessage());
        }
        System.out.print("+++ provoking RasClientInternalException (via subclassed e.)...");
        try {
            throw new TestRasClientInternalException("This is a test error");
        }
        catch (RasClientInternalException e) {
            System.out.println("OK, recognized: " + e.getMessage());
            System.out.print("+++ provoking RasResultIsNoCellException (via subclassed e.)...");
            try {
                throw new TestRasResultIsNoCellException();
            }
            catch (RasResultIsNoCellException e2) {
                System.out.println("OK, recognized: " + e2.getMessage());
                System.out.print("+++ provoking RasResultIsNoIntervalException (via subclassed e.)...");
                try {
                    throw new TestRasResultIsNoIntervalException();
                }
                catch (RasResultIsNoIntervalException e3) {
                    System.out.println("OK, recognized: " + e3.getMessage());
                    System.out.print("+++ provoking RasStreamInputOverflowException...");
                    try {
                        RasMInterval int1 = new RasMInterval(2);
                        int1.stream(new RasSInterval("1:10"));
                        int1.stream(new RasSInterval("1:5"));
                        int1.stream(new RasSInterval("1:20"));
                        System.out.println("ERROR: does not catch this.");
                    }
                    catch (RasStreamInputOverflowException e4) {
                        System.out.println("OK, recognized: " + e4.getMessage());
                    }
                    System.out.print("+++ provoking RasTypeInvalidException...");
                    try {
                        RasPrimitiveType myType = new RasPrimitiveType("myPrivateType", 16);
                        myType.getFloat(new Object());
                        System.out.println("ERROR: does not catch this.");
                    }
                    catch (RasTypeInvalidException e5) {
                        System.out.println("OK, recognized: " + e5.getMessage());
                    }
                    System.out.print("+++ provoking RasTypeNotSupportedException...");
                    try {
                        throw new RasTypeNotSupportedException("test");
                    }
                    catch (RasTypeNotSupportedException e6) {
                        System.out.println("OK, recognized: " + e6.getMessage());
                        System.out.print("+++ provoking RasIllegalULongValueException (faked)...");
                        try {
                            throw new RasIllegalULongValueException(42L);
                        }
                        catch (RasIllegalULongValueException e7) {
                            System.out.println("OK, recognized: " + e7.getMessage());
                            System.out.print("+++ provoking RasIllegalUShortValueException (faked)...");
                            try {
                                throw new RasIllegalUShortValueException(42);
                            }
                            catch (RasIllegalUShortValueException e8) {
                                RasGMArray myMDD;
                                System.out.println("OK, recognized: " + e8.getMessage());
                                System.out.print("+++ provoking RasInvalidNameException (illegal chars in obj type name)...");
                                try {
                                    myMDD = new RasGMArray(new RasMInterval("[1:400,1:400]"), 1L);
                                    myMDD.setObjectTypeName("_!_$_%_&_ _");
                                    System.out.println("ERROR: does not catch this.");
                                }
                                catch (RasInvalidNameException e9) {
                                    System.out.println("OK, recognized: " + e9.getMessage());
                                }
                                System.out.print("+++ provoking RasInvalidNameException (name too long)...");
                                try {
                                    myMDD = new RasGMArray(new RasMInterval("[1:400,1:400]"), 1L);
                                    myMDD.setObjectTypeName("loooongname__1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_1234567890_");
                                    System.out.println("ERROR: does not catch this.");
                                }
                                catch (RasInvalidNameException e10) {
                                    System.out.println("OK, recognized: " + e10.getMessage());
                                }
                                System.out.print("+++ provoking RasQueryExecutionFailedException...");
                                try {
                                    System.out.print("this is meant for a severe internal problem which I cannot provoke; will fake...");
                                    throw new RasQueryExecutionFailedException(1, 2, 3, "(fake)");
                                }
                                catch (RasQueryExecutionFailedException e11) {
                                    System.out.println("OK, recognized: " + e11.getMessage());
                                    System.out.println("+++ +++ testing exceptions done.");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

