/*
 * Decompiled with CFR 0.152.
 */
import org.odmg.DBag;
import org.odmg.Database;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasException;
import rasj.RasGMArray;
import rasj.RasImplementation;
import rasj.RasMArrayByte;
import rasj.RasMArrayDouble;
import rasj.RasMArrayFloat;
import rasj.RasMArrayInteger;
import rasj.RasMArrayLong;
import rasj.RasMArrayShort;
import rasj.RasMInterval;
import rasj.RasRuntimeException;
import rasj.RasStorageLayout;

public class TestMArray {
    static final String PREFIX_PROGRAM = "+++ +++ +++ ";
    static final String PREFIX_TESTSET = "+++ +++ ";
    static final String PREFIX_TESTCASE = "+++ ";
    static final String DEFAULT_HOST = "localhost";
    static final String DEFAULT_BASE = "RASBASE";
    static final String DEFAULT_COLL = "test";
    static final String ERROR_TAG = "ERROR: ";

    public static void main(String[] args) {
        String serv = DEFAULT_HOST;
        String base = DEFAULT_BASE;
        String coll = DEFAULT_COLL;
        boolean wrongUsage = false;
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals("--server")) {
                serv = args[i + 1];
                continue;
            }
            if (args[i].equals("--database")) {
                base = args[i + 1];
                continue;
            }
            if (args[i].equals("--collname")) {
                coll = args[i + 1];
                continue;
            }
            wrongUsage = true;
        }
        if (wrongUsage) {
            System.out.println("Usage: TestMArray [--server s] [--database d] [--collname c]");
            System.out.println("defaults: s=localhost, d=RASBASE, c=test");
            return;
        }
        System.out.println("rasdaman system test v5.1revC: testing class MArray.");
        System.out.println("+++ +++ +++ system test started, using server" + serv + ", database " + base + ", collection" + coll);
        TestMArray marrayTest = new TestMArray(serv);
        System.out.println("+++ +++ +++ system test done.");
    }

    public TestMArray(String server) {
        DBag resultBag = null;
        Object result2 = null;
        Transaction myTa = null;
        Database myDb = null;
        OQLQuery myQu = null;
        boolean equal = false;
        try {
            int j;
            int j2;
            int j3;
            int j4;
            int j5;
            int j6;
            int j7;
            System.out.println("### Testing MArrays: ...");
            RasImplementation myApp = new RasImplementation("http://" + server + ":7001");
            myDb = myApp.newDatabase();
            System.out.println("Opening database ...");
            myDb.open(DEFAULT_BASE, 2);
            myTa = myApp.newTransaction();
            int width = 18;
            int height = 18;
            int len = (width + 1) * (height + 1);
            RasMInterval domain = new RasMInterval("[0:" + width + ",0:" + height + "]");
            RasMInterval domain2 = new RasMInterval("[1:3,1:3]");
            RasStorageLayout stl = new RasStorageLayout();
            stl.setTileSize(128);
            System.out.println("\n\n### Testing GMArray with OID: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            try {
                resultBag = (DBag)myQu.execute();
                myTa.commit();
            }
            catch (ODMGException e) {
                myTa.abort();
                System.err.println("Collection test does not exist: " + e.getMessage());
            }
            myQu.create("create collection test GreySet");
            RasGMArray mddConst = new RasGMArray(domain, 1L, stl);
            byte[] data = new byte[len];
            mddConst.setObjectTypeName("GreyImage");
            System.out.println("new OID from server: " + myApp.getObjectId(mddConst));
            for (int j8 = 0; j8 < data.length; ++j8) {
                data[j8] = (byte)j8;
            }
            mddConst.setArray(data);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddConst);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    equal = true;
                    for (j7 = 0; j7 < mddConst.getArray().length; ++j7) {
                        if (mddConst.getArray()[j7] == ((RasGMArray)result2).getArray()[j7]) continue;
                        equal = false;
                    }
                    if (!myApp.getObjectId(mddConst).toString().equals(myApp.getObjectId(result2).toString())) {
                        equal = false;
                    }
                    System.out.println("result mdd: " + mddConst.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                }
                System.out.println("inserted and selected GMArray and OIDs are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasGMArray mddConst2 = new RasGMArray(mddConst);
            mddConst2.setArray(data);
            data = null;
            equal = true;
            for (j7 = 0; j7 < mddConst.getArray().length; ++j7) {
                if (mddConst.getArray()[j7] == mddConst2.getArray()[j7]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayByte: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test GreySet");
            RasMArrayByte mddByte = new RasMArrayByte(domain, stl);
            byte[] dataByte = new byte[len];
            mddByte.setObjectTypeName("GreyImage");
            for (int j9 = 0; j9 < dataByte.length; ++j9) {
                dataByte[j9] = (byte)j9;
            }
            mddByte.setArray(dataByte);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddByte);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    System.out.println("result mdd: " + mddByte.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                    equal = true;
                    for (j6 = 0; j6 < mddByte.getArray().length; ++j6) {
                        if (mddByte.getArray()[j6] == ((RasGMArray)result2).getArray()[j6]) continue;
                        equal = false;
                    }
                }
                System.out.println("inserted and selected MArrayByte are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayByte mddByte2 = new RasMArrayByte(mddByte);
            mddByte2.setArray(dataByte);
            dataByte = null;
            equal = true;
            for (j6 = 0; j6 < mddByte.getArray().length; ++j6) {
                if (mddByte.getArray()[j6] == mddByte2.getArray()[j6]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayInteger: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test UShortSet");
            RasMArrayInteger mddInteger = new RasMArrayInteger(domain, stl);
            int[] dataInteger = new int[len];
            mddInteger.setObjectTypeName("UShortImage");
            for (int j10 = 0; j10 < dataInteger.length; ++j10) {
                dataInteger[j10] = j10;
            }
            mddInteger.setArray(dataInteger);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddInteger);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    System.out.println("result mdd: " + mddInteger.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                    equal = true;
                    for (j5 = 0; j5 < mddInteger.getArray().length; ++j5) {
                        if (mddInteger.getArray()[j5] == ((RasGMArray)result2).getArray()[j5]) continue;
                        equal = false;
                    }
                }
                System.out.println("inserted and selected MArrayInteger are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayInteger mddInteger2 = new RasMArrayInteger(mddInteger);
            mddInteger2.setArray(dataInteger);
            dataInteger = null;
            equal = true;
            for (j5 = 0; j5 < mddInteger2.getArray().length; ++j5) {
                if (mddInteger.getArray()[j5] == mddInteger2.getArray()[j5]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayDouble: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test DoubleSet");
            RasMArrayDouble mddDouble = new RasMArrayDouble(domain, stl);
            double[] dataDouble = new double[len];
            mddDouble.setObjectTypeName("DoubleImage");
            for (double j11 = 0.0; j11 < (double)dataDouble.length; j11 += 1.0) {
                dataDouble[(int)j11] = j11;
            }
            mddDouble.setArray(dataDouble);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddDouble);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    equal = true;
                    for (j4 = 0; j4 < mddDouble.getDoubleArray().length; ++j4) {
                        if (mddDouble.getArray()[j4] == ((RasGMArray)result2).getArray()[j4]) continue;
                        equal = false;
                    }
                    System.out.println("result mdd: " + mddDouble.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                }
                System.out.println("inserted and selected MArrayDouble are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayDouble mddDouble2 = new RasMArrayDouble(mddDouble);
            mddDouble2.setArray(dataDouble);
            dataDouble = null;
            equal = true;
            for (j4 = 0; j4 < mddDouble2.getArray().length; ++j4) {
                if (mddDouble.getArray()[j4] == mddDouble2.getArray()[j4]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayFloat: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test FloatSet");
            RasMArrayFloat mddFloat = new RasMArrayFloat(domain, stl);
            float[] dataFloat = new float[len];
            mddFloat.setObjectTypeName("FloatImage");
            for (float j12 = 0.0f; j12 < (float)dataFloat.length; j12 += 1.0f) {
                dataFloat[(int)j12] = j12;
            }
            mddFloat.setArray(dataFloat);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddFloat);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    equal = true;
                    for (j3 = 0; j3 < mddFloat.getArray().length; ++j3) {
                        if (mddFloat.getArray()[j3] == ((RasGMArray)result2).getArray()[j3]) continue;
                        equal = false;
                    }
                    System.out.println("result mdd: " + mddFloat.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                }
                System.out.println("inserted and selected MArrayFloat are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayFloat mddFloat2 = new RasMArrayFloat(mddFloat);
            mddFloat2.setArray(dataFloat);
            dataFloat = null;
            equal = true;
            for (j3 = 0; j3 < mddFloat2.getArray().length; ++j3) {
                if (mddFloat.getArray()[j3] == mddFloat2.getArray()[j3]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayShort: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test ShortSet");
            RasMArrayShort mddShort = new RasMArrayShort(domain, stl);
            short[] dataShort = new short[len];
            mddShort.setObjectTypeName("ShortImage");
            for (int j13 = 0; j13 < dataShort.length; ++j13) {
                dataShort[j13] = (short)j13;
            }
            mddShort.setArray(dataShort);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("insert into test values $1");
            myQu.bind(mddShort);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    equal = true;
                    for (j2 = 0; j2 < mddShort.getArray().length; ++j2) {
                        if (mddShort.getArray()[j2] == ((RasGMArray)result2).getArray()[j2]) continue;
                        equal = false;
                    }
                    System.out.println("result mdd: " + mddShort.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                }
                System.out.println("inserted and selected MArrayShort are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayShort mddShort2 = new RasMArrayShort(mddShort);
            mddShort2.setArray(dataShort);
            dataShort = null;
            equal = true;
            for (j2 = 0; j2 < mddShort2.getArray().length; ++j2) {
                if (mddShort.getArray()[j2] == mddShort2.getArray()[j2]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\n\n### Testing MArrayLong: ################################################");
            myQu = myApp.newOQLQuery();
            myQu.create("drop collection test");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("create collection test ULongSet");
            RasMArrayLong mddLong = new RasMArrayLong(domain, stl);
            long[] dataLong = new long[len];
            mddLong.setObjectTypeName("ULongImage");
            for (long j14 = 0L; j14 < (long)dataLong.length; ++j14) {
                dataLong[(int)j14] = j14;
            }
            mddLong.setArray(dataLong);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu.create("insert into test values $1 ");
            myQu.bind(mddLong);
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            myQu = myApp.newOQLQuery();
            myQu.create("select img from test as img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                    equal = true;
                    for (j = 0; j < ((RasGMArray)result2).getArray().length; ++j) {
                        if (mddLong.getArray()[j] == ((RasGMArray)result2).getArray()[j]) continue;
                        equal = false;
                    }
                    System.out.println("result mdd: " + mddLong.toTestString());
                    System.out.println("result mdd: " + ((RasGMArray)result2).toTestString());
                }
                System.out.println("inserted MArrayInteger and selected MArrayLong are equal: " + equal);
            }
            System.out.println("### Testing copy constructor:");
            RasMArrayLong mddLong2 = new RasMArrayLong(mddLong);
            mddLong2.setArray(dataLong);
            dataLong = null;
            equal = true;
            for (j = 0; j < mddLong2.getArray().length; ++j) {
                if (mddLong.getArray()[j] == mddLong2.getArray()[j]) continue;
                equal = false;
            }
            System.out.println("Copy constructor is OK: " + equal);
            System.out.println("\nspecial array: ");
            for (j = 0; j < ((RasMArrayLong)result2).getLongArray().length; ++j) {
                System.out.print(" " + ((RasMArrayLong)result2).getLongArray()[j]);
            }
            System.out.println("\n\n### Testing intersection:");
            mddConst2.intersectionWith(domain2);
            mddByte2.intersectionWith(domain2);
            mddDouble2.intersectionWith(domain2);
            mddFloat2.intersectionWith(domain2);
            mddInteger2.intersectionWith(domain2);
            mddLong2.intersectionWith(domain2);
            mddShort2.intersectionWith(domain2);
            System.out.println("OK\n");
            myQu = myApp.newOQLQuery();
            myQu.create("SELECT oid(img) FROM test AS img");
            myTa.begin();
            resultBag = (DBag)myQu.execute();
            myTa.commit();
            if (resultBag != null) {
                for (Object result2 : resultBag) {
                }
            }
            System.out.println("### Testing OIDs:");
            myTa.begin();
            myApp.getObjectId(new RasGMArray());
            myTa.commit();
            System.out.println("Closing database ...");
            myDb.close();
            RasGMArray gmar = new RasGMArray();
            equal = true;
            if (!myApp.getObjectId(gmar).equals(gmar.getOID().toString())) {
                equal = false;
            }
            System.out.println("same OID on client and server side: " + equal);
        }
        catch (RasException e) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!While testing!!!!!!!!!!!!!!!!!!");
            System.out.println("An RasException has occurred: " + e.getMessage());
            System.out.println("Try to abort the transaction ...");
            if (myTa != null) {
                myTa.abort();
            }
            try {
                System.out.println("Try to close the database ...");
                if (myDb != null) {
                    myDb.close();
                }
            }
            catch (ODMGException exp) {
                System.err.println("Could not close the database: " + exp.getMessage());
            }
        }
        catch (RasRuntimeException e) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!While testing!!!!!!!!!!!!!!!!!!");
            System.out.println("An RasRuntimeException has occurred: " + e.getMessage());
            System.out.println("Try to abort the transaction ...");
            if (myTa != null) {
                myTa.abort();
            }
            try {
                System.out.println("Try to close the database ...");
                if (myDb != null) {
                    myDb.close();
                }
            }
            catch (ODMGException exp) {
                System.err.println("Could not close the database: " + exp.getMessage());
            }
        }
        catch (ODMGException e) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!While testing!!!!!!!!!!!!!!!!!!");
            System.out.println("An ODMGException has occurred: " + e.getMessage());
            System.out.println("Try to abort the transaction ...");
            if (myTa != null) {
                myTa.abort();
            }
            try {
                System.out.println("Try to close the database ...");
                if (myDb != null) {
                    myDb.close();
                }
            }
            catch (ODMGException exp) {
                System.err.println("Could not close the database: " + exp.getMessage());
            }
        }
        System.out.println("Done.");
    }
}

