/*
 * Decompiled with CFR 0.152.
 */
import org.odmg.Database;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasGMArray;
import rasj.RasImplementation;
import rasj.RasMInterval;
import rasj.RasStorageLayout;
import rasj.global.RasGlobalDefs;
import rasj.odmg.RasObject;

public class TestOdmg
implements RasGlobalDefs {
    static final String PREFIX_PROGRAM = "+++ +++ +++ ";
    static final String PREFIX_TESTSET = "+++ +++ ";
    static final String PREFIX_TESTCASE = "+++ ";
    static final String ERROR_TAG = "ERROR: ";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 7001;
    static final String DEFAULT_BASE = "RASBASE";
    static final String DEFAULT_USER = "rasguest";
    static final String DEFAULT_PASSWD = "rasguest";

    public static void main(String[] args) throws Exception {
        String serv = DEFAULT_HOST;
        int port = 7001;
        String base = DEFAULT_BASE;
        String user = "rasguest";
        String passwd = "rasguest";
        boolean wrongUsage = false;
        RasImplementation myImp = null;
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals("--server")) {
                serv = args[i + 1];
                continue;
            }
            if (args[i].equals("--port")) {
                try {
                    port = Integer.parseInt(args[i + 1]);
                }
                catch (Exception e) {
                    wrongUsage = true;
                }
                continue;
            }
            if (args[i].equals("--database")) {
                base = args[i + 1];
                continue;
            }
            if (args[i].equals("--user")) {
                user = args[i + 1];
                continue;
            }
            if (!args[i].equals("--passwd")) continue;
            passwd = args[i + 1];
        }
        if (wrongUsage) {
            System.out.println("Usage: ODMGtest [--server s] [--port p] [--database d] [--user u] [--passwd p]");
            System.out.println("defaults: server=localhost, port=7001, database=RASBASE, user=rasguest, passwd=rasguest");
            System.exit(-1);
        }
        System.out.println("rasdaman system test v5.1revC: testing ODMG queries.");
        System.out.println("+++ +++ +++ system test started, using server " + serv + ", port " + port + ", database " + base + ", user=" + user + ", passwd=" + passwd);
        myImp = new RasImplementation("http://" + serv + ":" + port);
        TestOdmg.testQueries(myImp, base);
        System.out.println("+++ +++ +++ system test done.");
    }

    static void testQueries(RasImplementation imp, String database) throws Exception {
        System.out.println("+++ +++ testing queries started.");
        Database mydb = null;
        Transaction myta = null;
        RasGMArray myMDD = null;
        OQLQuery myQuery = null;
        try {
            System.out.println("Start creating test arrays ...");
            myMDD = new RasGMArray(new RasMInterval("[1:400,1:400]"), 1L);
            byte[] mydata = new byte[160000];
            for (int y = 0; y < 400; ++y) {
                for (int x = 0; x < 400; ++x) {
                    mydata[y * 399 + x] = x > 99 && x < 151 || x > 299 && x < 351 ? 100 : 0;
                }
            }
            myMDD.setArray(mydata);
            myMDD.setObjectTypeName("GreyImage");
            RasStorageLayout myLayout = new RasStorageLayout();
            myLayout.setTileDomain("[1:100,1:70]");
            myMDD.setStorageLayout(myLayout);
            System.out.println("Created Test Data:");
            System.out.println(myMDD);
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            System.exit(-1);
        }
        try {
            mydb = imp.newDatabase();
            System.out.println("Open Database ...");
            mydb.open(database, 2);
            System.out.println("     ok.");
            myta = imp.newTransaction();
            System.out.println("Begin transaction ...");
            myta.begin();
            System.out.println("     ok.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            if (myta.isOpen()) {
                System.out.println("Abort transaction ...");
                myta.abort();
            }
            System.out.println("Close database ...");
            try {
                mydb.close();
                System.out.println("     ok.");
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.out.println("Exiting...");
            System.exit(-1);
        }
        try {
            System.out.println("Create a new test collection ...");
            myQuery = imp.newOQLQuery();
            myQuery.create("create collection testCollection GreySet");
            myQuery.execute();
            myta.commit();
            myta.begin();
            System.out.println("     ok.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            System.out.println("Try to remove the test collection ...");
            try {
                myQuery.create("drop collection testCollection");
                myQuery.execute();
                myta.commit();
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (myta.isOpen()) {
                System.out.println("Abort transaction ...");
                myta.abort();
            }
            System.out.println("Close database ...");
            try {
                mydb.close();
                System.out.println("     ok.");
            }
            catch (Exception e3) {
                // empty catch block
            }
            System.out.println("Exiting...");
            System.exit(-1);
        }
        try {
            System.out.println("Define the update query and bind the parameters ...");
            myQuery.create("insert into testCollection VALUES $1");
            myQuery.bind(myMDD);
            System.out.println("     ok.");
            System.out.println("Send the query ...");
            myQuery.execute();
            System.out.println("     ok.");
            System.out.println("Commit transaction ...");
            myta.commit();
            System.out.println("     ok.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            if (myta.isOpen()) {
                System.out.println("Abort transaction ...");
                myta.abort();
            }
            System.out.println("Close database ...");
            try {
                mydb.close();
                System.out.println("     ok.");
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.out.println("Exiting...");
            System.exit(-1);
        }
        try {
            System.out.println("Start new transaction ...");
            myta.begin();
            myQuery = imp.newOQLQuery();
            myQuery.create("select testCollection from testCollection");
            myQuery.execute();
            myta.commit();
            System.out.println("     ok.");
            myta.begin();
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            if (myta.isOpen()) {
                System.out.println("Abort transaction ...");
                myta.abort();
            }
            System.out.println("Close database ...");
            try {
                mydb.close();
                System.out.println("     ok.");
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.out.println("Exiting...");
            System.exit(-1);
        }
        try {
            System.out.println("Drop test collection ...");
            myQuery = imp.newOQLQuery();
            myQuery.create("drop collection testCollection");
            myQuery.execute();
            myta.commit();
            mydb.close();
            System.out.println("     ok.");
        }
        catch (Exception e) {
            System.out.println(ERROR_TAG);
            System.out.println(e.getMessage());
            if (myta.isOpen()) {
                System.out.println("Abort transaction ...");
                myta.abort();
            }
            System.out.println("Close database ...");
            try {
                mydb.close();
                System.out.println("     ok.");
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.out.println("Exiting...");
            System.exit(-1);
        }
        System.out.println("+++ +++ testing queries done.\n");
    }

    public static void objectTest() {
        System.out.println("Set object name test - in");
        RasObject dummy = new RasObject();
        dummy.setObjectName("goodName");
        System.out.println("Set name=" + dummy.getObjectName());
        dummy.setObjectName("bad-Name");
        System.out.println("Set name=" + dummy.getObjectName());
        System.out.println("Set object name test - out");
    }
}

