/*
 * Decompiled with CFR 0.152.
 */
import org.odmg.DBag;
import org.odmg.Database;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasImplementation;

public class TestQuery {
    public static void main(String[] args) {
        String server = "localhost";
        String port = "7001";
        String base = "RASBASE";
        String user = "rasguest";
        String passwd = "rasguest";
        String query = "select r from RAS_COLLECTIONNAMES as r";
        int count = 1;
        if (args.length == 0) {
            System.out.println("usage: TestQuery [options]");
            System.out.println("options:");
            System.out.println("  --server s   - use server s (default: localhost)");
            System.out.println("  --port p     - use server port p (default: 7001)");
            System.out.println("  --database d - use database d (default: RASBASE)");
            System.out.println("  --user u     - log in as user u (default: rasguest)");
            System.out.println("  --passwd p   - log in with password p (default: rasguest)");
            System.out.println("  --query q    - send SELECT query string q to server (default: select r from RAS_COLLECTIONNAMES as r)");
            System.out.println("  --count c    - execute query c times (default: 1)");
            return;
        }
        for (int i = args.length - 1; i >= 0; --i) {
            if (args[i].equals("--server")) {
                server = args[i + 1];
            }
            if (args[i].equals("--port")) {
                port = args[i + 1];
            }
            if (args[i].equals("--database")) {
                base = args[i + 1];
            }
            if (args[i].equals("--user")) {
                user = args[i + 1];
            }
            if (args[i].equals("--passwd")) {
                passwd = args[i + 1];
            }
            if (args[i].equals("--query")) {
                query = args[i + 1];
            }
            if (!args[i].equals("--count")) continue;
            count = Integer.parseInt(args[i + 1]);
        }
        System.out.println("Query test started with server=" + server + ", port=" + port + ", database=" + base + ", user=" + user + ", count=" + count + ", query=" + query);
        try {
            RasImplementation myApp = new RasImplementation("http://" + server + ":" + port);
            myApp.setUserIdentification(user, passwd);
            System.out.println("opening database...");
            Database myDb = myApp.newDatabase();
            myDb.open(base, 2);
            System.out.println("starting transaction...");
            Transaction myTa = myApp.newTransaction();
            myTa.begin();
            for (int i = 1; i <= count; ++i) {
                System.out.print("sending query #" + i + "...");
                OQLQuery myQu = myApp.newOQLQuery();
                myQu.create(query);
                DBag result = (DBag)myQu.execute();
                System.out.println("result is: " + result);
            }
            System.out.println("closing transaction...");
            myTa.commit();
            System.out.println("closing database...");
            myDb.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        System.out.println("Query test done.");
    }
}

