/*
 * Decompiled with CFR 0.152.
 */
import rasj.RasDimensionMismatchException;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasPoint;
import rasj.RasStreamInputOverflowException;

public class TestRasPoint {
    static final String PREFIX_PROGRAM = "+++ +++ +++ ";
    static final String PREFIX_TESTSET = "+++ +++ ";
    static final String PREFIX_TESTCASE = "+++ ";
    static final int COORD_1 = 11;
    static final int COORD_2 = 22;
    static final int COORD_3 = 33;
    static final int COORD_4 = 44;
    static final int COORD_5 = 55;
    static final String ERROR_TAG = "ERROR: ";

    public static void main(String[] argv) throws Exception {
        System.out.println("rasdaman system test v5.1revC: testing class RasPoint.");
        System.out.println("+++ +++ +++ system test started.");
        TestRasPoint.testConstructor();
        TestRasPoint.testAdd();
        System.out.println("+++ +++ +++ system test done.");
    }

    static void testConstructor() throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        System.out.println("+++ +++ testing constructor started.");
        System.out.print("+++ default constructor...");
        RasPoint p_default = new RasPoint();
        if (p_default == null) {
            System.out.println("ERROR: result is null.");
        } else if (!p_default.equals(p_default)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_default + ", dimension is " + p_default.dimension());
        }
        System.out.print("+++ stream constructor, illegal dimension -1...");
        try {
            RasPoint p_stream_m1 = new RasPoint(-1);
            if (p_stream_m1 != null) {
                System.out.println("ERROR: result is not null.");
            } else {
                System.out.println("OK.");
            }
        }
        catch (NegativeArraySizeException e) {
            System.out.println("OK: " + e.getMessage());
        }
        System.out.print("+++ stream constructor, dimension 0...");
        RasPoint p_stream_0 = new RasPoint(0);
        if (p_stream_0.dimension() != 0) {
            System.out.println("ERROR: wrong dimension.");
        } else {
            System.out.println("OK.");
        }
        System.out.print("+++ 2D easy to use constructor...");
        RasPoint p_2d_easy = new RasPoint(11L, 22L);
        if (p_2d_easy == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_2d_easy.dimension() != 2) {
            System.out.println("ERROR: dimension is not 2 but " + p_2d_easy.dimension());
        } else if (p_2d_easy.item(0) != 11L) {
            System.out.println("ERROR: item(0) returns wrong component " + p_2d_easy.item(0));
        } else if (p_2d_easy.item(1) != 22L) {
            System.out.println("ERROR: item(1) returns wrong component " + p_2d_easy.item(0));
        } else if (!p_2d_easy.equals(p_2d_easy)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_2d_easy.notEquals(p_2d_easy)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_2d_easy);
        }
        System.out.print("+++ 3D easy to use constructor...");
        RasPoint p_3d_easy = new RasPoint(11L, 22L, 33L);
        if (p_3d_easy == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_3d_easy.dimension() != 3) {
            System.out.println("ERROR: dimension is not 3 but " + p_3d_easy.dimension());
        } else if (p_3d_easy.item(2) != 33L) {
            System.out.println("ERROR: item(2) returns wrong component " + p_3d_easy.item(0));
        } else if (!p_3d_easy.equals(p_3d_easy)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_3d_easy.notEquals(p_3d_easy)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_3d_easy);
        }
        System.out.print("+++ 4D easy to use constructor...");
        RasPoint p_4d_easy = new RasPoint(11L, 22L, 33L, 44L);
        if (p_4d_easy == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_4d_easy.dimension() != 4) {
            System.out.println("ERROR: dimension is not 4 but " + p_4d_easy.dimension());
        } else if (p_4d_easy.item(3) != 44L) {
            System.out.println("ERROR: item(3) returns wrong component " + p_4d_easy.item(0));
        } else if (!p_4d_easy.equals(p_4d_easy)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_4d_easy.notEquals(p_4d_easy)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_4d_easy);
        }
        System.out.print("+++ 5D easy to use constructor...");
        RasPoint p_5d_easy = new RasPoint(11L, 22L, 33L, 44L, 55L);
        if (p_5d_easy == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_5d_easy.dimension() != 5) {
            System.out.println("ERROR: dimension is not 5 but " + p_5d_easy.dimension());
        } else if (p_5d_easy.item(4) != 55L) {
            System.out.println("ERROR: item(4) returns wrong component " + p_5d_easy.item(0));
        } else if (!p_5d_easy.equals(p_5d_easy)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_5d_easy.notEquals(p_5d_easy)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_5d_easy);
        }
        System.out.println("ERROR: PB4: string constructor, illegal string formats.");
        System.out.print("+++ 2D string constructor...");
        RasPoint p_2d = new RasPoint("[11,22]");
        if (p_2d == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_2d.dimension() != 2) {
            System.out.println("ERROR: dimension is not 2 but " + p_2d.dimension());
        } else if (p_2d.item(0) != 11L) {
            System.out.println("ERROR: item(0) returns wrong component " + p_2d.item(0));
        } else if (p_2d.item(1) != 22L) {
            System.out.println("ERROR: item(1) returns wrong component " + p_2d.item(0));
        } else if (!p_2d.equals(p_2d)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_2d.notEquals(p_2d)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_2d);
        }
        System.out.print("+++ 3D string constructor...");
        RasPoint p_3d = new RasPoint("[11,22,33]");
        if (p_3d == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_3d.dimension() != 3) {
            System.out.println("ERROR: dimension is not 3 but " + p_3d.dimension());
        } else if (p_3d.item(2) != 33L) {
            System.out.println("ERROR: item(2) returns wrong component " + p_3d.item(0));
        } else if (!p_3d.equals(p_3d)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_3d.notEquals(p_3d)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_3d);
        }
        System.out.print("+++ 4D string constructor...");
        RasPoint p_4d = new RasPoint("[11,22,33,44]");
        if (p_4d == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_4d.dimension() != 4) {
            System.out.println("ERROR: dimension is not 4 but " + p_4d.dimension());
        } else if (p_4d.item(3) != 44L) {
            System.out.println("ERROR: item(3) returns wrong component " + p_4d.item(0));
        } else if (!p_4d.equals(p_4d)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_4d.notEquals(p_4d)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_4d);
        }
        System.out.print("+++ 5D string constructor...");
        RasPoint p_5d = new RasPoint("[11,22,33,44,55]");
        if (p_5d == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_5d.dimension() != 5) {
            System.out.println("ERROR: dimension is not 5 but " + p_5d.dimension());
        } else if (p_5d.item(4) != 55L) {
            System.out.println("ERROR: item(4) returns wrong component " + p_5d.item(0));
        } else if (!p_5d.equals(p_5d)) {
            System.out.println("ERROR: point not equal to itself.");
        } else if (p_5d.notEquals(p_5d)) {
            System.out.println("ERROR: point notEqual to itself.");
        } else {
            System.out.println("OK, result=" + p_5d);
        }
        System.out.print("+++ copy constructor...");
        RasPoint p_cp = new RasPoint(p_2d);
        if (p_cp == null) {
            System.out.println("ERROR: result is null.");
        } else if (p_cp.dimension() != p_2d.dimension()) {
            System.out.println("ERROR: dimension mismatch.");
        } else if (p_cp.item(0) != p_2d.item(0)) {
            System.out.println("ERROR: item(0) returns wrong component " + p_cp.item(0));
        } else if (p_cp.item(1) != p_2d.item(1)) {
            System.out.println("ERROR: item(1) returns wrong component " + p_cp.item(1));
        } else if (!p_cp.equals(p_2d)) {
            System.out.println("ERROR: point not equal to origin.");
        } else if (p_cp.notEquals(p_2d)) {
            System.out.println("ERROR: point notEqual to origin.");
        } else {
            System.out.println("OK, result=" + p_cp);
        }
        System.out.println("+++ +++ testing constructor done.\n");
    }

    static void testAdd() throws RasDimensionMismatchException, RasIndexOutOfBoundsException, RasStreamInputOverflowException {
        System.out.println("+++ +++ testing add started.");
        RasPoint p1 = new RasPoint(33L, 44L);
        RasPoint p2 = new RasPoint(33L, 44L);
        p2 = p2.add(p2);
        boolean b1 = false;
        b1 = p2.comparedWith(p1) == 0 ? p1.equals(p2) : false;
        System.out.println("points are equal: " + b1);
        b1 = false;
        if (p1.dimension() == 2 && 2 == p2.dimension()) {
            b1 = true;
        }
        System.out.println("dimensions of points are correct: " + b1);
        b1 = false;
        p2.setItem(1, 48L);
        if (p2.item(1) == 48L) {
            b1 = true;
        }
        System.out.println("read and write access of points is OK: " + b1);
        b1 = false;
        p2.setTo(p2.mult(p1));
        if (p2.equals(new RasPoint(443556L, 42624L))) {
            b1 = true;
        }
        System.out.println("mult and setTo is OK: " + b1);
        b1 = false;
        RasPoint ps = new RasPoint(3);
        ps.stream(42L);
        if (ps.item(0) == 42L) {
            b1 = true;
        }
        System.out.println("stream initializing of points is OK: " + b1);
        System.out.println("+++ +++ testing add done.\n");
    }
}

