/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.Iterator;
import org.odmg.DBag;
import org.odmg.OQLQuery;
import rasj.RasClientInternalException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStreamInputOverflowException;
import rasj.global.RasGlobalDefs;

abstract class RasFastBaseScale
implements RasGlobalDefs {
    OQLQuery query = null;
    String collectionName = null;
    RasMInterval fullDomain = null;
    double lastScaleUsed;

    public RasFastBaseScale(String collection, OQLQuery queryObject) {
        this.collectionName = collection;
        this.query = queryObject;
        this.fullDomain = this.readFullDomain(this.collectionName);
    }

    public final RasMInterval getFullDomain() {
        return this.fullDomain;
    }

    public RasMInterval scaleGetDomain(RasMInterval areaOp, RasPoint origin, double scale) throws RasClientInternalException {
        try {
            int dim = areaOp.dimension();
            RasMInterval areaScale = new RasMInterval(dim);
            for (int i = 0; i < dim; ++i) {
                int low = (int)((double)origin.item(i) + (double)(areaOp.item(i).low() - origin.item(i)) * scale);
                int high = (int)((double)origin.item(i) + (double)(areaOp.item(i).high() + 1L - origin.item(i)) * scale - 1.0);
                if (high < low) {
                    return null;
                }
                areaScale.stream(new RasSInterval((long)low, (long)high));
            }
            return areaScale;
        }
        catch (RasIndexOutOfBoundsException e1) {
            throw new RasClientInternalException("RasFastBaseScale", "scaleGetDomain", e1.getMessage());
        }
        catch (RasStreamInputOverflowException e2) {
            throw new RasClientInternalException("RasFastBaseScale", "scaleGetDomain", e2.getMessage());
        }
        catch (RasResultIsNoIntervalException e3) {
            throw new RasClientInternalException("RasFastBaseScale", "scaleGetDomain", e3.getMessage());
        }
    }

    protected RasMInterval readFullDomain(String collection) throws RasClientInternalException {
        try {
            this.query.create("SELECT sdom(img) FROM " + collection + " AS img");
            DBag resultBag = (DBag)this.query.execute();
            if (resultBag != null) {
                Iterator iter = resultBag.iterator();
                if (iter.hasNext()) {
                    return (RasMInterval)iter.next();
                }
                throw new RasClientInternalException("RasFastScale", "readFullDomain", "query produced no result.");
            }
            throw new RasClientInternalException("RasFastScale", "readFullDomain", "query produced no result.");
        }
        catch (Exception e1) {
            throw new RasClientInternalException("RasFastScale", "readFullDomain", e1.getMessage());
        }
    }

    protected RasGMArray getMinimalArray(String collection) throws RasClientInternalException {
        try {
            RasMInterval iv = this.readFullDomain(collection);
            RasMInterval getDomain = new RasMInterval(iv.dimension());
            for (int i = 0; i < iv.dimension(); ++i) {
                getDomain.stream(new RasSInterval(iv.item(i).low(), iv.item(i).low()));
            }
            this.query.create("SELECT img" + getDomain.toString() + " FROM " + collection + " AS img");
            DBag resultBag = (DBag)this.query.execute();
            if (resultBag != null) {
                Iterator iter = resultBag.iterator();
                if (iter.hasNext()) {
                    return (RasGMArray)iter.next();
                }
                throw new RasClientInternalException("RasFastScale", "getMinimalArray", "query produced no result.");
            }
            throw new RasClientInternalException("RasFastScale", "getMinimalArray", "query produced no result.");
        }
        catch (Exception e1) {
            throw new RasClientInternalException("RasFastScale", "getMinimalArray", e1.getMessage());
        }
    }

    public RasMInterval getScaledDomain(RasMInterval area, double scale) throws RasClientInternalException {
        RasMInterval retval = null;
        int nearest = -1;
        int i = 0;
        double nearScale = 0.0;
        i = 0;
        while (i < 8 && !(FAST_PRE_SCALE_FACTORS[i] < scale)) {
            nearest = i++;
        }
        if (nearest != -1) {
            retval = this.scaleGetDomain(area, this.fullDomain.getOrigin(), FAST_PRE_SCALE_FACTORS[nearest]);
            if (scale != FAST_PRE_SCALE_FACTORS[nearest] && retval != null) {
                nearScale = scale / FAST_PRE_SCALE_FACTORS[nearest];
                retval = this.scaleGetDomain(retval, this.fullDomain.getOrigin(), nearScale);
            }
        } else {
            retval = this.scaleGetDomain(area, this.fullDomain.getOrigin(), scale);
        }
        return retval;
    }

    public double getLastScale() {
        return this.lastScaleUsed;
    }
}

