/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import org.odmg.DBag;
import org.odmg.OQLQuery;
import org.odmg.QueryException;
import rasj.RasClientInternalException;
import rasj.RasFastBaseScale;
import rasj.RasMInterval;
import rasj.global.RasGlobalDefs;

public class RasFastScale
extends RasFastBaseScale
implements RasGlobalDefs {
    static final String rcsid = "@(#)Package rasj, class RasFastScale, RasFastBaseScale: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasFastScale.java,v 1.17 2003/12/10 21:04:23 rasdev Exp $";

    public RasFastScale(String collection, OQLQuery queryObject) {
        super(collection, queryObject);
    }

    public Object getScaledImage(RasMInterval trimDomain, double scalingFactor, int domType) throws QueryException {
        int nearest = -1;
        String suffix = null;
        Object res = null;
        DBag result = null;
        int i = 0;
        while (i < 8 && !(FAST_PRE_SCALE_FACTORS[i] < scalingFactor)) {
            nearest = i++;
        }
        try {
            block8: {
                RasMInterval scaledTrimDomain;
                double nearScale;
                while (true) {
                    if (nearest == -1 || nearest == 0) {
                        nearScale = 1.0;
                        suffix = "";
                    } else {
                        nearScale = FAST_PRE_SCALE_FACTORS[nearest];
                        suffix = FAST_PRE_SCALE_SUFFIXES[nearest];
                    }
                    if (domType == 0) {
                        this.query.create("SELECT scale(img," + scalingFactor / nearScale + ')' + trimDomain + " FROM " + this.collectionName + suffix + " AS img");
                        break block8;
                    }
                    scaledTrimDomain = null;
                    scaledTrimDomain = this.getScaledDomain(trimDomain, nearScale);
                    if (scaledTrimDomain != null) break;
                    --nearest;
                }
                this.query.create("SELECT scale(img" + scaledTrimDomain + ',' + scalingFactor / nearScale + ") FROM " + this.collectionName + suffix + " AS img");
            }
            DBag resultBag = (DBag)this.query.execute();
            if (resultBag == null) {
                throw new RasClientInternalException("RasFastScale", "getScaledImage", "query returned no result.");
            }
            result = resultBag;
        }
        catch (Exception e1) {
            throw new RasClientInternalException("RasFastScale", "getScaledImage", e1.getMessage());
        }
        return result;
    }
}

