/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import rasj.RasBaseType;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMArrayType;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasResultIsNoCellException;
import rasj.RasStorageLayout;
import rasj.RasType;
import rasj.global.RasGlobalDefs;
import rasj.odmg.RasObject;

public class RasGMArray
extends RasObject
implements RasGlobalDefs {
    static final String rcsid = "@(#)Package rasj, class RasGMArray: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasGMArray.java,v 1.26 2003/12/10 21:04:23 rasdev Exp $";
    protected RasMInterval domain;
    protected byte[] data;
    protected Object objectData;
    protected byte[] currentCell;
    protected long dataSize;
    protected long typeLength;
    protected int currentFormat;
    protected RasStorageLayout storageLayout;

    public RasGMArray() {
        super(1);
        this.data = null;
        this.objectData = null;
        this.currentCell = null;
        this.dataSize = 0L;
        this.domain = null;
        this.typeLength = 0L;
        this.currentFormat = 0;
        this.storageLayout = new RasStorageLayout();
    }

    public RasGMArray(RasMInterval initDomain, long cellTypeLength) {
        super(1);
        this.data = null;
        this.objectData = null;
        this.dataSize = 0L;
        this.domain = initDomain;
        this.typeLength = cellTypeLength;
        this.currentFormat = 0;
        this.storageLayout = new RasStorageLayout();
        this.dataSize = (this.domain.dimension() != 0 ? this.domain.cellCount() : 1L) * this.typeLength;
        this.data = new byte[(int)this.dataSize];
        this.currentCell = new byte[(int)cellTypeLength];
    }

    public RasGMArray(RasMInterval initDomain, long cellTypeLength, RasStorageLayout stl) {
        super(1);
        this.data = null;
        this.objectData = null;
        this.dataSize = 0L;
        this.domain = initDomain;
        this.typeLength = cellTypeLength;
        this.currentFormat = 0;
        this.storageLayout = stl;
        this.dataSize = (this.domain.dimension() != 0 ? this.domain.cellCount() : 1L) * this.typeLength;
        this.data = new byte[(int)this.dataSize];
        this.currentCell = new byte[(int)cellTypeLength];
    }

    public RasGMArray(RasGMArray obj) {
        super(obj, 1);
        if (this.data != null) {
            System.arraycopy(obj.getArray(), 0, this.data, 0, (int)obj.dataSize);
            this.objectData = null;
        }
        this.dataSize = obj.getArraySize();
        this.domain = obj.spatialDomain();
        this.typeLength = obj.typeLength;
        this.currentFormat = obj.currentFormat;
        this.storageLayout = new RasStorageLayout(obj.storageLayout);
        if (obj.typeLength != 0L) {
            this.currentCell = new byte[(int)obj.typeLength];
        }
    }

    public RasGMArray setTo(RasGMArray mArray) {
        if (this != mArray) {
            if (this.data != null) {
                this.data = null;
            }
            if (mArray.data != null) {
                this.dataSize = mArray.dataSize;
                this.data = mArray.data;
            }
            if (mArray.objectData != null) {
                this.dataSize = mArray.dataSize;
                this.objectData = mArray.objectData;
            }
            if (this.storageLayout != null) {
                this.storageLayout = null;
            }
            if (mArray.storageLayout != null) {
                this.storageLayout = new RasStorageLayout(mArray.storageLayout);
            }
            this.domain = mArray.domain;
            this.typeLength = mArray.typeLength;
            this.currentFormat = mArray.currentFormat;
        }
        return this;
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        if (this.typeLength == 0L) {
            return null;
        }
        System.arraycopy(this.data, (int)(this.domain.cellOffset(point) * this.typeLength), this.currentCell, 0, (int)this.typeLength);
        return this.currentCell;
    }

    public final RasStorageLayout getStorageLayout() {
        return this.storageLayout;
    }

    public void setStorageLayout(RasStorageLayout stl) throws RasDimensionMismatchException {
        if (!stl.isCompatible(this.domain)) {
            throw new RasDimensionMismatchException((long)this.domain.dimension(), stl.getSpatialDomain().dimension());
        }
        this.storageLayout = stl;
    }

    public RasGMArray intersectionWith(RasMInterval where) {
        RasGMArray tile = new RasGMArray();
        try {
            RasMInterval objDomain = this.spatialDomain();
            int numDims = objDomain.dimension();
            long tlength = this.getTypeLength();
            byte[] objData = new byte[(int)(where.cellCount() * tlength)];
            tile.setSpatialDomain(where);
            tile.setTypeLength(tlength);
            tile.setArray(objData);
            tile.setArraySize(where.cellCount() * tlength);
            long blockLength = where.item(numDims - 1).high() - where.item(numDims - 1).low() + 1L;
            long total = where.cellCount() / blockLength;
            byte[] dest = objData;
            byte[] source = this.getArray();
            int blength = (int)(blockLength * tlength);
            for (long cell = 0L; cell < total; ++cell) {
                RasPoint p = where.cellPoint(cell * blockLength);
                System.arraycopy(source, (int)(objDomain.cellOffset(p) * tlength), dest, (int)(where.cellOffset(p) * tlength), blength);
            }
            return tile;
        }
        catch (RasIndexOutOfBoundsException e1) {
            throw new RasClientInternalException("RasGMArray", "intersectionWith()", e1.getMessage());
        }
        catch (RasResultIsNoCellException e2) {
            throw new RasClientInternalException("RasGMArray", "intersectionWith()", e2.getMessage());
        }
    }

    public final RasMInterval spatialDomain() {
        return this.domain;
    }

    public byte[] getArray() {
        return this.data;
    }

    public final long getArraySize() {
        return this.dataSize;
    }

    public final long getTypeLength() {
        return this.typeLength;
    }

    public final int getCurrentFormat() {
        return this.currentFormat;
    }

    public void setSpatialDomain(RasMInterval dom) {
        this.domain = dom;
    }

    public void setArray(byte[] newData) {
        this.data = newData;
        this.dataSize = newData.length;
        this.objectData = null;
    }

    public void setArraySize(long newValue) {
        this.dataSize = newValue;
    }

    public void setTypeLength(long newValue) {
        this.typeLength = newValue;
        this.currentCell = new byte[(int)newValue];
    }

    public void setCurrentFormat(int newFormat) {
        this.currentFormat = newFormat;
    }

    public String toString() {
        String tileDomain = "";
        RasType typeSchema = this.getTypeSchema();
        RasBaseType baseTypeSchema = this.getBaseTypeSchema();
        tileDomain = this.storageLayout.getSpatialDomain() == null ? this.getTilingDomain(this.domain, this.typeLength) : this.storageLayout.getSpatialDomain().toString();
        String s = "\n" + this.getClass().getName();
        s = s + "\n" + "  Oid...................: " + this.getOID() + "\n" + "  Object Name...........: " + this.getObjectName() + "\n" + "  Object Type...........: " + this.getObjectType() + "\n" + "  Object Type Name......: " + this.getObjectTypeName() + "\n" + "  Type Structure........: " + (this.getTypeStructure() != null ? this.getTypeStructure() : "<nn>") + "\n" + "  Type Schema...........: " + (typeSchema != null ? typeSchema.toString() : "<nn>") + "\n" + "  Domain................: " + this.domain + "\n" + "  TilingDomain..........: " + tileDomain + "\n" + "  TileSize..............: " + this.storageLayout.getTileSize() + " bytes\n" + "  Base Type Schema......: " + (baseTypeSchema != null ? baseTypeSchema.toString() : "<nn>") + "\n" + "  Base Type Length......: " + this.typeLength + "\n" + "  Data format...........: " + this.currentFormat + "\n" + "  Data size (bytes).....: " + this.dataSize + "\n";
        return s;
    }

    public String toTestString() {
        String tileDomain = "";
        RasType typeSchema = this.getTypeSchema();
        RasBaseType baseTypeSchema = this.getBaseTypeSchema();
        tileDomain = this.storageLayout.getSpatialDomain() == null ? this.getTilingDomain(this.domain, this.typeLength) : this.storageLayout.getSpatialDomain().toString();
        StringBuffer buffer = new StringBuffer(this.getArray().length * 4);
        buffer.append("\n" + this.getClass().getName());
        buffer.append("\n  Object Name...........: " + this.getObjectName() + "\n" + "  Object Type...........: " + this.getObjectType() + "\n" + "  Object Type Name......: " + this.getObjectTypeName() + "\n" + "  Type Structure........: " + (this.getTypeStructure() != null ? this.getTypeStructure() : "<nn>") + "\n" + "  Type Schema...........: " + (typeSchema != null ? typeSchema.toString() : "<nn>") + "\n" + "  Domain................: " + this.domain + "\n" + "  TilingDomain..........: " + tileDomain + "\n" + "  TileSize..............: " + this.storageLayout.getTileSize() + " bytes\n" + "  Base Type Schema......: " + (baseTypeSchema != null ? baseTypeSchema.toString() : "<nn>") + "\n" + "  Base Type Length......: " + this.typeLength + "\n" + "  Data format...........: " + this.currentFormat + "\n" + "  Data size (bytes).....: " + this.dataSize + "\n");
        for (int j = 0; j < this.getArray().length; ++j) {
            buffer.append(" " + this.getArray()[j]);
        }
        return buffer.toString();
    }

    public RasBaseType getBaseTypeSchema() {
        RasType type = this.getTypeSchema();
        RasBaseType baseType = null;
        if (type != null && type.getTypeID() == 1) {
            RasMArrayType mArrayType = (RasMArrayType)type;
            baseType = mArrayType.getBaseType();
        }
        return baseType;
    }

    private String getTilingDomain(RasMInterval originalDomain, long typeLength) {
        long tileSize = this.storageLayout.getTileSize();
        int dim = originalDomain.dimension();
        double tmp = 1.0 / (double)dim;
        int size = (int)Math.pow(tileSize / typeLength, tmp) - 1;
        String retVal = "0:" + String.valueOf(size);
        for (int x = 1; x < dim; ++x) {
            retVal = retVal + ",0:" + size;
        }
        return "[" + retVal + "]";
    }
}

