/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.Implementation;
import org.odmg.NotImplementedException;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasImplementationInterface;
import rasj.global.Debug;
import rasj.odmg.RasODMGImplementation;
import rasj.rnp.RasRNPImplementation;

public class RasImplementation
implements Implementation {
    private RasImplementationInterface imp = null;
    private static boolean isRNP = true;
    public static final String PROTOCOL_RNP = "RNP";
    public static final String PROTOCOL_RPC = "RPC";
    public static final String PROTOCOL_HTTP = "HTTP";
    public static final String PROTOCOL_COMP = "COMPAT";
    public static final int TYPE_TYPE_SET = 1;
    public static final int TYPE_TYPE_MDD = 2;
    public static final int TYPE_TYPE_BASE = 3;

    public RasImplementation(String server) {
        Debug.talkSparse("rasj: rasdaman Java API. rasdaman 6.1test -- generated Tue Jan  6 17:52:20 CET 2009.");
        Debug.talkSparse(" Using server " + server);
        String envVar = System.getProperty("RMANPROTOCOL");
        boolean useRNP = isRNP;
        if (envVar != null) {
            Debug.talkWarning("environment variable RMANPROTOCOL enforces protocol " + envVar);
            if (envVar.equalsIgnoreCase(PROTOCOL_RNP)) {
                useRNP = true;
            } else if (envVar.equalsIgnoreCase(PROTOCOL_RPC)) {
                Debug.talkCritical("Error: protocol RPC not supported by rasj: using RNP instead.");
                useRNP = true;
            } else if (envVar.equalsIgnoreCase(PROTOCOL_HTTP)) {
                useRNP = false;
            } else if (envVar.equalsIgnoreCase(PROTOCOL_COMP)) {
                Debug.talkCritical("Compatibility mode specified, using RNP.");
                useRNP = true;
            } else {
                Debug.talkCritical("Error: unknown protocol: " + envVar + "; using protocol " + PROTOCOL_RNP + ".");
                useRNP = true;
            }
        }
        if (useRNP) {
            Debug.talkVerbose("RasImplementation.constructor: using protocol RNP.");
            this.imp = new RasRNPImplementation(server);
        } else {
            Debug.talkVerbose("RasImplementation.constructor: using protocol HTTP.");
            this.imp = new RasODMGImplementation(server);
        }
    }

    public RasImplementation(String server, String protocol) {
        Debug.talkSparse("rasj: rasdaman Java API. rasdaman 6.1test -- generated Tue Jan  6 17:52:20 CET 2009.");
        Debug.talkSparse(" Using server " + server);
        if (protocol.equalsIgnoreCase(PROTOCOL_RNP)) {
            Debug.talkVerbose("Using protocol RNP.");
            this.imp = new RasRNPImplementation(server);
        } else if (protocol.equalsIgnoreCase(PROTOCOL_HTTP)) {
            Debug.talkVerbose("Using protocol HTTP.");
            this.imp = new RasODMGImplementation(server);
        } else {
            Debug.talkCritical("Error: unknown protocol: " + protocol + "; using " + PROTOCOL_RNP + " instead.");
            this.imp = new RasRNPImplementation(server);
        }
    }

    public static void setRNP() {
        isRNP = true;
    }

    public static void setHTTP() {
        isRNP = false;
    }

    public boolean isDefaultRNP() {
        Debug.talkVerbose("RasImplementation.isDefaultRNP: RNP=" + isRNP + ".");
        return isRNP;
    }

    public int dbIsOpen() {
        return this.imp.dbIsOpen();
    }

    public Transaction newTransaction() {
        return this.imp.newTransaction();
    }

    public Transaction currentTransaction() {
        return this.imp.currentTransaction();
    }

    public Database newDatabase() {
        return this.imp.newDatabase();
    }

    public OQLQuery newOQLQuery() {
        return this.imp.newOQLQuery();
    }

    public DList newDList() {
        return this.imp.newDList();
    }

    public DBag newDBag() {
        return this.imp.newDBag();
    }

    public DSet newDSet() {
        return this.imp.newDSet();
    }

    public DArray newDArray() {
        throw new NotImplementedException();
    }

    public DMap newDMap() {
        throw new NotImplementedException();
    }

    public String getObjectId(Object obj) {
        return this.imp.getObjectId(obj);
    }

    public Database getDatabase(Object obj) {
        throw new NotImplementedException();
    }

    public void openDB(String name, int accessMode) throws ODMGException {
        this.imp.openDB(name, accessMode);
    }

    public void closeDB() throws ODMGException {
        this.imp.closeDB();
    }

    public void beginTA() throws ODMGException {
        this.imp.beginTA();
    }

    public boolean isOpenTA() throws ODMGException {
        Debug.talkCritical("RasImplementation::isOpenTA: calling imp.isOpenTA()");
        return this.imp.isOpenTA();
    }

    public void commitTA() throws ODMGException {
        this.imp.commitTA();
    }

    public void abortTA() throws ODMGException {
        this.imp.abortTA();
    }

    public void setMaxRetry(int newRetry) {
        this.imp.setMaxRetry(newRetry);
    }

    public int getMaxRetry() {
        return this.imp.getMaxRetry();
    }

    public void setUserIdentification(String userName, String plainPass) {
        this.imp.setUserIdentification(userName, plainPass);
    }

    public void setTraceThreshold(int level) {
        Debug.talkCritical("setting trace level to " + level);
        Debug.setDebugThreshold(level);
    }

    public String getTypeStructure(String typename, int typetype) {
        return this.imp.getTypeStructure(typename, typetype);
    }
}

