/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasStorageLayout;

public class RasMArrayDouble
extends RasGMArray {
    public RasMArrayDouble() {
        this.typeLength = 8L;
    }

    public RasMArrayDouble(RasMInterval initDomain) {
        super(initDomain, 8L);
        this.objectData = new double[(int)(this.dataSize / 8L)];
        this.data = null;
    }

    public RasMArrayDouble(RasMInterval initDomain, RasStorageLayout stl) {
        super(initDomain, 8L, stl);
        this.objectData = new double[(int)(this.dataSize / 8L)];
        this.data = null;
    }

    public RasMArrayDouble(RasMArrayDouble obj) {
        super(obj);
        if (obj.objectData != null) {
            this.objectData = new double[(int)(obj.dataSize / 8L)];
            System.arraycopy(obj.getDoubleArray(), 0, this.objectData, 0, (int)(obj.dataSize / 8L));
            this.data = null;
        }
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        double cellValue = ((double[])this.objectData)[(int)this.domain.cellOffset(point)];
        for (int i = 0; i < 8; ++i) {
            long tmp = Double.doubleToRawLongBits(cellValue);
            this.currentCell[i] = (byte)(tmp >>>= (7 - i) * 8);
        }
        return this.currentCell;
    }

    public double getDouble(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        return ((double[])this.objectData)[(int)this.domain.cellOffset(point)];
    }

    public double[] getDoubleArray() {
        if (this.objectData == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bis);
            this.objectData = new double[this.data.length / 8];
            try {
                for (int j = 0; j < this.data.length / 8; ++j) {
                    ((double[])this.objectData)[j] = dis.readDouble();
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayDouble", "getDoubleArray()", "IOException while converting data to objectData array " + e.getMessage());
            }
        }
        return (double[])this.objectData;
    }

    public byte[] getArray() {
        if (this.data == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                for (int j = 0; j < ((double[])this.objectData).length; ++j) {
                    dos.writeDouble(((double[])this.objectData)[j]);
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayDouble", "getArray()", "IOException while converting objectData to data array " + e.getMessage());
            }
            this.data = bos.toByteArray();
        }
        return this.data;
    }

    public void setArray(double[] newData) {
        this.objectData = newData;
        this.data = null;
        this.dataSize = newData.length * 8;
    }
}

