/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasStorageLayout;

public class RasMArrayFloat
extends RasGMArray {
    public RasMArrayFloat() {
        this.typeLength = 4L;
    }

    public RasMArrayFloat(RasMInterval initDomain) {
        super(initDomain, 4L);
        this.objectData = new float[(int)(this.dataSize / 4L)];
        this.data = null;
    }

    public RasMArrayFloat(RasMInterval initDomain, RasStorageLayout stl) {
        super(initDomain, 4L, stl);
        this.objectData = new float[(int)(this.dataSize / 4L)];
        this.data = null;
    }

    public RasMArrayFloat(RasMArrayFloat obj) {
        super(obj);
        if (obj.objectData != null) {
            this.objectData = new float[(int)(obj.dataSize / 4L)];
            System.arraycopy(obj.getFloatArray(), 0, this.objectData, 0, (int)(obj.dataSize / 4L));
            this.data = null;
        }
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        float cellValue = ((float[])this.objectData)[(int)this.domain.cellOffset(point)];
        for (int i = 0; i < 4; ++i) {
            int tmp = Float.floatToRawIntBits(cellValue);
            this.currentCell[i] = (byte)(tmp >>>= (3 - i) * 8);
        }
        return this.currentCell;
    }

    public float getFloat(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        return ((float[])this.objectData)[(int)this.domain.cellOffset(point)];
    }

    public float[] getFloatArray() {
        if (this.objectData == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bis);
            this.objectData = new float[this.data.length / 4];
            try {
                for (int j = 0; j < this.data.length / 4; ++j) {
                    ((float[])this.objectData)[j] = dis.readFloat();
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayFloat", "getFloatArray()", "IOException while converting data to objectData array " + e.getMessage());
            }
        }
        return (float[])this.objectData;
    }

    public byte[] getArray() {
        if (this.data == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                for (int j = 0; j < ((float[])this.objectData).length; ++j) {
                    dos.writeFloat(((float[])this.objectData)[j]);
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayFloat", "getArray()", "IOException while converting objectData to data array " + e.getMessage());
            }
            this.data = bos.toByteArray();
        }
        return this.data;
    }

    public void setArray(float[] newData) {
        this.objectData = newData;
        this.data = null;
        this.dataSize = newData.length * 4;
    }
}

