/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasStorageLayout;

public class RasMArrayInteger
extends RasGMArray {
    public RasMArrayInteger() {
        this.typeLength = 4L;
    }

    public RasMArrayInteger(RasMInterval initDomain) {
        super(initDomain, 4L);
        this.objectData = new int[(int)(this.dataSize / 4L)];
        this.data = null;
    }

    public RasMArrayInteger(RasMInterval initDomain, RasStorageLayout stl) {
        super(initDomain, 4L, stl);
        this.objectData = new int[(int)(this.dataSize / 4L)];
        this.data = null;
    }

    public RasMArrayInteger(RasMArrayInteger obj) {
        super(obj);
        if (obj.objectData != null) {
            this.objectData = new int[(int)(obj.dataSize / 4L)];
            System.arraycopy(obj.getIntArray(), 0, this.objectData, 0, (int)(obj.dataSize / 4L));
            this.data = null;
        }
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        int cellValue = ((int[])this.objectData)[(int)this.domain.cellOffset(point)];
        for (int i = 0; i < 4; ++i) {
            int tmp = cellValue;
            this.currentCell[i] = (byte)(tmp >>>= (3 - i) * 8);
        }
        return this.currentCell;
    }

    public int getInt(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        return ((int[])this.objectData)[(int)this.domain.cellOffset(point)];
    }

    public int[] getIntArray() {
        if (this.objectData == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bis);
            this.objectData = new int[this.data.length / 4];
            try {
                for (int j = 0; j < this.data.length / 4; ++j) {
                    ((int[])this.objectData)[j] = dis.readInt();
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayInteger", "getIntArray()", "IOException while converting data to objectData array " + e.getMessage());
            }
        }
        return (int[])this.objectData;
    }

    public byte[] getArray() {
        if (this.data == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                for (int j = 0; j < ((int[])this.objectData).length; ++j) {
                    dos.writeInt(((int[])this.objectData)[j]);
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayInteger", "getArray()", "IOException while converting objectData to data array " + e.getMessage());
            }
            this.data = bos.toByteArray();
        }
        return this.data;
    }

    public void setArray(int[] newData) {
        this.objectData = newData;
        this.data = null;
        this.dataSize = newData.length * 4;
    }
}

