/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasStorageLayout;

public class RasMArrayLong
extends RasGMArray {
    public RasMArrayLong() {
        this.typeLength = 8L;
    }

    public RasMArrayLong(RasMInterval initDomain) {
        super(initDomain, 8L);
        this.objectData = new long[(int)(this.dataSize / 8L)];
        this.data = null;
    }

    public RasMArrayLong(RasMInterval initDomain, RasStorageLayout stl) {
        super(initDomain, 8L, stl);
        this.objectData = new long[(int)(this.dataSize / 8L)];
        this.data = null;
    }

    public RasMArrayLong(RasMArrayLong obj) {
        super(obj);
        if (obj.objectData != null) {
            this.objectData = new long[(int)(obj.dataSize / 8L)];
            System.arraycopy(obj.getLongArray(), 0, this.objectData, 0, (int)(obj.dataSize / 8L));
            this.data = null;
        }
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        long cellValue = ((long[])this.objectData)[(int)this.domain.cellOffset(point)];
        for (int i = 0; i < 8; ++i) {
            long tmp = cellValue;
            this.currentCell[i] = (byte)(tmp >>>= (7 - i) * 8);
        }
        return this.currentCell;
    }

    public long getLong(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        return ((long[])this.objectData)[(int)this.domain.cellOffset(point)];
    }

    public long[] getLongArray() {
        if (this.objectData == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bis);
            this.objectData = new long[this.data.length / 8];
            try {
                for (int j = 0; j < this.data.length / 8; ++j) {
                    ((long[])this.objectData)[j] = dis.readLong();
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayLong", "getLongArray()", "IOException while converting data to objectData array " + e.getMessage());
            }
        }
        return (long[])this.objectData;
    }

    public byte[] getArray() {
        if (this.data == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                for (int j = 0; j < ((long[])this.objectData).length; ++j) {
                    dos.writeLong(((long[])this.objectData)[j]);
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayLong", "getArray()", "IOException while converting objectData to data array " + e.getMessage());
            }
            this.data = bos.toByteArray();
        }
        return this.data;
    }

    public void setArray(long[] newData) {
        this.objectData = newData;
        this.data = null;
        this.dataSize = newData.length * 8;
    }
}

