/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasStorageLayout;

public class RasMArrayShort
extends RasGMArray {
    public RasMArrayShort() {
        this.typeLength = 2L;
    }

    public RasMArrayShort(RasMInterval initDomain) {
        super(initDomain, 2L);
        this.objectData = new short[(int)(this.dataSize / 2L)];
        this.data = null;
    }

    public RasMArrayShort(RasMInterval initDomain, RasStorageLayout stl) {
        super(initDomain, 2L, stl);
        this.objectData = new short[(int)(this.dataSize / 2L)];
        this.data = null;
    }

    public RasMArrayShort(RasMArrayShort obj) {
        super(obj);
        if (obj.objectData != null) {
            this.objectData = new short[(int)(obj.dataSize / 2L)];
            System.arraycopy(obj.getShortArray(), 0, this.objectData, 0, (int)(obj.dataSize / 2L));
            this.data = null;
        }
    }

    public byte[] getCell(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        short cellValue = ((short[])this.objectData)[(int)this.domain.cellOffset(point)];
        for (int i = 0; i < 2; ++i) {
            short tmp = cellValue;
            tmp = (short)(tmp >>> (1 - i) * 8);
            this.currentCell[i] = (byte)tmp;
        }
        return this.currentCell;
    }

    public int getShort(RasPoint point) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        if (point.dimension() != this.domain.dimension()) {
            throw new RasDimensionMismatchException((long)point.dimension(), this.domain.dimension());
        }
        return ((short[])this.objectData)[(int)this.domain.cellOffset(point)];
    }

    public short[] getShortArray() {
        if (this.objectData == null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bis);
            this.objectData = new short[this.data.length / 2];
            try {
                for (int j = 0; j < this.data.length / 2; ++j) {
                    ((short[])this.objectData)[j] = dis.readShort();
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayShort", "getShortArray()", "IOException while converting data to objectData array " + e.getMessage());
            }
        }
        return (short[])this.objectData;
    }

    public byte[] getArray() {
        if (this.data == null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                for (int j = 0; j < ((short[])this.objectData).length; ++j) {
                    dos.writeShort(((short[])this.objectData)[j]);
                }
            }
            catch (IOException e) {
                throw new RasClientInternalException("RasMArrayShort", "getArray()", "IOException while converting objectData to data array " + e.getMessage());
            }
            this.data = bos.toByteArray();
        }
        return this.data;
    }

    public void setArray(short[] newData) {
        this.objectData = newData;
        this.data = null;
        this.dataSize = newData.length * 2;
    }
}

