/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.StringTokenizer;
import rasj.RasClientInternalException;
import rasj.RasDimensionMismatchException;
import rasj.RasException;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasPoint;
import rasj.RasResultIsNoCellException;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStreamInputOverflowException;

public class RasMInterval {
    static final String rcsid = "@(#)Package rasj, class RasMInterval: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasMInterval.java,v 1.15 2003/12/10 21:04:23 rasdev Exp $";
    protected RasSInterval[] intervals;
    protected int dimensionality;
    protected int streamInitCnt;

    public RasMInterval(int dim) {
        this.dimensionality = dim;
        this.streamInitCnt = 0;
        this.intervals = new RasSInterval[this.dimensionality];
        for (int i = 0; i < dim; ++i) {
            this.intervals[i] = new RasSInterval();
        }
    }

    public RasMInterval(String mIntStr) throws RasResultIsNoIntervalException {
        this.dimensionality = 1;
        this.streamInitCnt = 0;
        if (mIntStr.trim().charAt(0) != '[') {
            this.dimensionality = 0;
            return;
        }
        StringTokenizer strTok = new StringTokenizer(mIntStr.trim(), "[:,]");
        String strCurTok = null;
        this.dimensionality = strTok.countTokens() / 2;
        this.intervals = new RasSInterval[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            RasSInterval sint = new RasSInterval();
            strCurTok = strTok.nextToken();
            if (strCurTok.equals("*")) {
                sint.setLow('*');
            } else {
                sint.setLow(Long.parseLong(strCurTok.trim()));
            }
            strCurTok = strTok.nextToken();
            if (strCurTok.equals("*")) {
                sint.setHigh('*');
            } else {
                sint.setHigh(Long.parseLong(strCurTok.trim()));
            }
            this.intervals[i] = sint;
        }
    }

    public void stream(RasSInterval newInterval) throws RasStreamInputOverflowException {
        if (this.streamInitCnt >= this.dimensionality) {
            throw new RasStreamInputOverflowException();
        }
        this.intervals[this.streamInitCnt++] = newInterval;
    }

    public void stream(long p) throws RasStreamInputOverflowException, RasResultIsNoIntervalException {
        if (this.streamInitCnt >= this.dimensionality) {
            throw new RasStreamInputOverflowException();
        }
        this.intervals[this.streamInitCnt++] = new RasSInterval(p, p);
    }

    public RasMInterval() {
        this.dimensionality = 0;
        this.streamInitCnt = 0;
        this.intervals = null;
    }

    public RasMInterval(RasMInterval mInterval) throws RasStreamInputOverflowException, RasIndexOutOfBoundsException {
        this.dimensionality = mInterval.dimension();
        this.streamInitCnt = mInterval.streamInitCnt;
        this.intervals = new RasSInterval[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            this.intervals[i] = new RasSInterval(mInterval.item(i));
        }
    }

    public boolean intersectsWith(RasMInterval mInterval) throws RasDimensionMismatchException, RasIndexOutOfBoundsException {
        boolean result = true;
        if (this.dimensionality != mInterval.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mInterval.dimension());
        }
        for (int i = 0; i < this.dimensionality; ++i) {
            if (0 != this.intervals[i].intersectsWith(mInterval.item(i)) && -1 != this.intervals[i].intersectsWith(mInterval.item(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public RasSInterval item(int i) throws RasIndexOutOfBoundsException {
        if (i < 0 || i >= this.dimensionality) {
            throw new RasIndexOutOfBoundsException(0L, this.dimensionality - 1, i);
        }
        return this.intervals[i];
    }

    public void setItem(int i, RasSInterval value) throws RasIndexOutOfBoundsException {
        if (i < 0 || i >= this.dimensionality) {
            throw new RasIndexOutOfBoundsException(0L, this.dimensionality - 1, i);
        }
        this.intervals[i] = value;
    }

    public boolean equals(RasMInterval mint) {
        boolean returnValue = false;
        try {
            if (this.dimensionality == mint.dimensionality) {
                returnValue = true;
                for (int i = 0; i < this.dimensionality && returnValue; returnValue &= this.intervals[i] == mint.item(i), ++i) {
                }
            }
            return returnValue;
        }
        catch (RasIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean notEquals(RasMInterval mint) {
        return !this.equals(mint);
    }

    public final int covers(RasPoint pnt) {
        if (this.dimensionality != pnt.dimension()) {
            return -1;
        }
        try {
            for (int i = 0; i < pnt.dimension(); ++i) {
                if ((!this.intervals[i].isLowFixed() || pnt.item(i) >= this.intervals[i].low()) && (!this.intervals[i].isHighFixed() || pnt.item(i) <= this.intervals[i].high())) continue;
                return 0;
            }
            return 1;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "covers(RasPoint pnt)", e.getMessage());
        }
    }

    public int covers(RasMInterval inter2) {
        if (this.dimensionality != inter2.dimension()) {
            return -1;
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                if ((!this.intervals[i].isLowFixed() || inter2.item(i).isLowFixed() && this.intervals[i].low() <= inter2.item(i).low()) && (!this.intervals[i].isHighFixed() || inter2.item(i).isHighFixed() && this.intervals[i].high() >= inter2.item(i).high())) continue;
                return 0;
            }
            return 1;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "covers(RasMInterval inter2)", e.getMessage());
        }
    }

    public int dimension() {
        return this.dimensionality;
    }

    public RasPoint getOrigin() {
        try {
            RasPoint pt = new RasPoint(this.dimensionality);
            for (int i = 0; i < this.dimensionality; ++i) {
                pt.stream(this.intervals[i].low());
            }
            return pt;
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "getOrigin()", e.getMessage());
        }
    }

    public RasPoint getHigh() {
        try {
            RasPoint pt = new RasPoint(this.dimensionality);
            for (int i = 0; i < this.dimensionality; ++i) {
                pt.stream(this.intervals[i].high());
            }
            return pt;
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "getHigh()", e.getMessage());
        }
    }

    public RasPoint getExtent() {
        try {
            RasPoint pt = new RasPoint(this.dimensionality);
            for (int i = 0; i < this.dimensionality; ++i) {
                pt.stream(this.intervals[i].high() - this.intervals[i].low() + 1L);
            }
            return pt;
        }
        catch (RasStreamInputOverflowException e) {
            System.err.println("Error in method RasMInterval.getExtent()");
            return null;
        }
    }

    public boolean isMergeable(RasMInterval b) {
        RasMInterval a = this;
        if (a.dimensionality != b.dimensionality) {
            return false;
        }
        int onesDifferences = 0;
        boolean isMerg = true;
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                if (a.item(i).low() != b.item(i).low()) {
                    if (a.item(i).low() == b.item(i).high() + 1L || b.item(i).low() == a.item(i).high() + 1L) {
                        ++onesDifferences;
                        continue;
                    }
                    isMerg = false;
                    break;
                }
                if (a.item(i).high() == b.item(i).high()) continue;
                isMerg = false;
                break;
            }
            if (isMerg && onesDifferences != 1) {
                isMerg = false;
            }
            return isMerg;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "isMergeable()", e.getMessage());
        }
    }

    public RasMInterval translate(RasPoint t) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != t.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, t.dimension());
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i].setInterval(this.intervals[i].low() + t.item(i), this.intervals[i].high() + t.item(i));
            }
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "translate()", e.getMessage());
        }
        return this;
    }

    public RasMInterval createTranslation(RasPoint t) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != t.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, t.dimension());
        }
        RasMInterval result = new RasMInterval(this.dimensionality);
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                result.intervals[i].setInterval(this.intervals[i].low() + t.item(i), this.intervals[i].high() + t.item(i));
            }
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "createTranslation()", e.getMessage());
        }
        return result;
    }

    public RasMInterval unionOf(RasMInterval mint1, RasMInterval mint2) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (mint1.dimension() != mint2.dimension()) {
            throw new RasDimensionMismatchException((long)mint1.dimension(), mint2.dimension());
        }
        this.streamInitCnt = this.dimensionality = mint1.dimension();
        this.intervals = new RasSInterval[this.dimensionality];
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i] = new RasSInterval();
                this.intervals[i].unionOf(mint1.item(i), mint2.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "unionOf()", e.getMessage());
        }
    }

    public RasMInterval unionWith(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i].unionWith(mint.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "unionWith()", e.getMessage());
        }
    }

    public RasMInterval addToSelf(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.unionWith(mint);
    }

    public RasMInterval createUnion(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        RasMInterval result = new RasMInterval(this.dimensionality);
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.intervals[i].createUnion(mint.item(i)));
            }
            return result;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "createUnion()", e.getMessage());
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "createUnion()", e.getMessage());
        }
    }

    public RasMInterval add(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.createUnion(mint);
    }

    public RasMInterval differenceOf(RasMInterval mint1, RasMInterval mint2) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (mint1.dimension() != mint2.dimension()) {
            throw new RasDimensionMismatchException((long)mint1.dimension(), mint2.dimension());
        }
        this.streamInitCnt = this.dimensionality = mint1.dimension();
        this.intervals = new RasSInterval[this.dimensionality];
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i] = new RasSInterval();
                this.intervals[i].differenceOf(mint1.item(i), mint2.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "differenceOf()", e.getMessage());
        }
    }

    public RasMInterval differenceWith(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i].differenceWith(mint.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "differenceWith()", e.getMessage());
        }
    }

    public RasMInterval diffFromSelf(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.differenceWith(mint);
    }

    public RasMInterval createDifference(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        RasMInterval result = new RasMInterval(this.dimensionality);
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.intervals[i].createDifference(mint.item(i)));
            }
            return result;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "createDifference()", e.getMessage());
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "createDifference()", e.getMessage());
        }
    }

    public RasMInterval diff(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.createDifference(mint);
    }

    public RasMInterval intersectionOf(RasMInterval mint1, RasMInterval mint2) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (mint1.dimension() != mint2.dimension()) {
            throw new RasDimensionMismatchException((long)mint1.dimension(), mint2.dimension());
        }
        this.streamInitCnt = this.dimensionality = mint1.dimension();
        this.intervals = new RasSInterval[this.dimensionality];
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i] = new RasSInterval();
                this.intervals[i].intersectionOf(mint1.item(i), mint2.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "intersectionOf()", e.getMessage());
        }
    }

    public RasMInterval intersectionWith(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i].intersectionWith(mint.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "intersectionWith()", e.getMessage());
        }
    }

    public RasMInterval multWithSelf(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.intersectionWith(mint);
    }

    public RasMInterval createIntersection(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        RasMInterval result = new RasMInterval(this.dimensionality);
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.intervals[i].createIntersection(mint.item(i)));
            }
            return result;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "createIntersection()", e.getMessage());
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "createIntersection()", e.getMessage());
        }
    }

    public RasMInterval mult(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        return this.createIntersection(mint);
    }

    public RasMInterval closureOf(RasMInterval mint1, RasMInterval mint2) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (mint1.dimension() != mint2.dimension()) {
            throw new RasDimensionMismatchException((long)mint1.dimension(), mint2.dimension());
        }
        this.streamInitCnt = this.dimensionality = mint1.dimension();
        this.intervals = new RasSInterval[this.dimensionality];
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i] = new RasSInterval();
                this.intervals[i].closureOf(mint1.item(i), mint2.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "closureOf()", e.getMessage());
        }
    }

    public RasMInterval closureWith(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.intervals[i].closureWith(mint.item(i));
            }
            return this;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "closureWith()", e.getMessage());
        }
    }

    public RasMInterval createClosure(RasMInterval mint) throws RasDimensionMismatchException, RasResultIsNoIntervalException {
        if (this.dimensionality != mint.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, mint.dimension());
        }
        RasMInterval result = new RasMInterval(this.dimensionality);
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.intervals[i].createClosure(mint.item(i)));
            }
            return result;
        }
        catch (RasIndexOutOfBoundsException e) {
            throw new RasClientInternalException("RasMInterval", "createClosure()", e.getMessage());
        }
        catch (RasStreamInputOverflowException e) {
            throw new RasClientInternalException("RasMInterval", "createClosure()", e.getMessage());
        }
    }

    long cellCount() {
        long cellCount = 1L;
        for (int i = 0; i < this.dimensionality; ++i) {
            cellCount *= this.intervals[i].high() - this.intervals[i].low() + 1L;
        }
        return cellCount;
    }

    long cellOffset(RasPoint point) throws RasIndexOutOfBoundsException {
        int i = 0;
        long offset = 0L;
        for (i = 0; i < this.dimensionality - 1; ++i) {
            if (point.item(i) < this.intervals[i].low() || point.item(i) > this.intervals[i].high()) {
                throw new RasIndexOutOfBoundsException(this.intervals[i].low(), this.intervals[i].high(), point.item(i));
            }
            offset = (offset + point.item(i) - this.intervals[i].low()) * (this.intervals[i + 1].high() - this.intervals[i + 1].low() + 1L);
        }
        if (point.item(i) < this.intervals[i].low() || point.item(i) > this.intervals[i].high()) {
            throw new RasIndexOutOfBoundsException(this.intervals[i].low(), this.intervals[i].high(), point.item(i));
        }
        return offset += point.item(i) - this.intervals[i].low();
    }

    RasPoint cellPoint(long offset) throws RasResultIsNoCellException {
        long factor = 1L;
        RasPoint pt = new RasPoint(this.dimensionality);
        try {
            int i;
            if (offset >= this.cellCount()) {
                throw new RasResultIsNoCellException();
            }
            for (i = 0; i < this.dimensionality; ++i) {
                factor *= this.intervals[i].high() - this.intervals[i].low() + 1L;
            }
            for (i = 0; i < this.dimensionality; ++i) {
                pt.stream(this.intervals[i].low() + (offset - offset % (factor /= this.intervals[i].high() - this.intervals[i].low() + 1L)) / factor);
                offset %= factor;
            }
            return pt;
        }
        catch (RasStreamInputOverflowException e) {
            System.err.println("Error in method RasMInterval.cellPoint().");
            return null;
        }
    }

    void deleteDimension(int dim) throws RasException {
        if (dim < 0 || dim >= this.dimensionality) {
            throw new RasIndexOutOfBoundsException(0L, this.dimensionality - 1, dim);
        }
        --this.dimensionality;
        this.streamInitCnt = this.dimensionality;
        RasSInterval[] newIntervals = new RasSInterval[this.dimensionality];
        int i = 0;
        int j = 0;
        while (i < this.dimensionality) {
            if (i == dim) {
                ++j;
            }
            newIntervals[i] = this.intervals[j];
            ++i;
            ++j;
        }
        this.intervals = newIntervals;
    }

    long getStorageSize() {
        long sz = 26L;
        if (this.dimensionality > 0) {
            sz += (long)(this.dimensionality * 18);
        }
        return sz;
    }

    public String toString() {
        String retString = "";
        if (this.dimensionality > 0) {
            for (int i = 0; i < this.dimensionality - 1; ++i) {
                retString = retString + this.intervals[i].toString() + ",";
            }
            retString = retString + this.intervals[this.dimensionality - 1].toString();
        }
        return "[" + retString + "]";
    }
}

