/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.StringTokenizer;
import rasj.RasDimensionMismatchException;
import rasj.RasException;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasStreamInputOverflowException;

public class RasPoint {
    static final String rcsid = "@(#)Package rasj, class RasPoint: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasPoint.java,v 1.9 2003/12/10 21:04:23 rasdev Exp $";
    private long[] points;
    private int dimensionality;
    private int streamInitCnt;

    public RasPoint(int dim) {
        this.dimensionality = dim;
        this.streamInitCnt = 0;
        this.points = new long[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            this.points[i] = 0L;
        }
    }

    public RasPoint stream(long newElement) throws RasStreamInputOverflowException {
        if (this.streamInitCnt >= this.dimensionality) {
            throw new RasStreamInputOverflowException();
        }
        this.points[this.streamInitCnt++] = newElement;
        return this;
    }

    public RasPoint(String stringRep) {
        this.dimensionality = 1;
        this.streamInitCnt = 0;
        if (stringRep.trim().charAt(0) != '[') {
            this.dimensionality = 0;
            return;
        }
        StringTokenizer strTok = new StringTokenizer(stringRep.trim(), "[,]");
        String strCurTok = null;
        this.dimensionality = strTok.countTokens();
        this.points = new long[this.dimensionality];
        for (int i = 0; i < this.dimensionality; ++i) {
            strCurTok = strTok.nextToken();
            this.points[i] = Long.parseLong(strCurTok.trim());
        }
    }

    public RasPoint(long p1, long p2) {
        this.dimensionality = 2;
        this.streamInitCnt = 2;
        this.points = new long[this.dimensionality];
        this.points[0] = p1;
        this.points[1] = p2;
    }

    public RasPoint(long p1, long p2, long p3) {
        this.dimensionality = 3;
        this.streamInitCnt = 3;
        this.points = new long[this.dimensionality];
        this.points[0] = p1;
        this.points[1] = p2;
        this.points[2] = p3;
    }

    public RasPoint(long p1, long p2, long p3, long p4) {
        this.dimensionality = 4;
        this.streamInitCnt = 4;
        this.points = new long[this.dimensionality];
        this.points[0] = p1;
        this.points[1] = p2;
        this.points[2] = p3;
        this.points[3] = p4;
    }

    public RasPoint(long p1, long p2, long p3, long p4, long p5) {
        this.dimensionality = 5;
        this.streamInitCnt = 5;
        this.points = new long[this.dimensionality];
        this.points[0] = p1;
        this.points[1] = p2;
        this.points[2] = p3;
        this.points[3] = p4;
        this.points[4] = p5;
    }

    public RasPoint() {
        this.dimensionality = 0;
        this.streamInitCnt = 0;
        this.points = null;
    }

    public RasPoint(RasPoint pt) {
        this.streamInitCnt = this.dimensionality = pt.dimension();
        this.points = new long[this.dimensionality];
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                this.points[i] = pt.item(i);
            }
        }
        catch (RasIndexOutOfBoundsException e) {
            System.out.println("Error in RasPoint copy constructor.");
        }
    }

    public long item(int i) throws RasIndexOutOfBoundsException {
        if (i < 0 || i >= this.dimensionality) {
            throw new RasIndexOutOfBoundsException(0L, this.dimensionality - 1, i);
        }
        return this.points[i];
    }

    public void setItem(int i, long value) throws RasIndexOutOfBoundsException {
        if (i < 0 || i >= this.dimensionality) {
            throw new RasIndexOutOfBoundsException(0L, this.dimensionality - 1, i);
        }
        this.points[i] = value;
    }

    public final RasPoint setTo(RasPoint pt) throws RasIndexOutOfBoundsException {
        if (this != pt) {
            if (this.points != null && this.dimensionality != pt.dimension()) {
                this.points = null;
            }
            this.streamInitCnt = this.dimensionality = pt.dimension();
            if (this.points == null) {
                this.points = new long[this.dimensionality];
            }
            for (int i = 0; i < this.dimensionality; ++i) {
                this.points[i] = pt.item(i);
            }
        }
        return this;
    }

    public final int comparedWith(RasPoint p) {
        if (this.dimensionality != p.dimensionality) {
            return -2;
        }
        try {
            for (int i = 0; i < this.dimensionality; ++i) {
                if (this.points[i] > p.item(i)) {
                    return 1;
                }
                if (this.points[i] >= p.item(i)) continue;
                return -1;
            }
            return 0;
        }
        catch (RasIndexOutOfBoundsException e) {
            System.out.println("Error in method RasPoint.comparedWith().");
            return -2;
        }
    }

    public boolean equals(RasPoint pt) throws RasDimensionMismatchException {
        boolean returnValue = false;
        if (this.dimensionality != pt.dimensionality) {
            throw new RasDimensionMismatchException((long)this.dimensionality, pt.dimensionality);
        }
        try {
            returnValue = true;
            for (int i = 0; i < this.dimensionality && returnValue; returnValue &= this.points[i] == pt.item(i), ++i) {
            }
            return returnValue;
        }
        catch (RasIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean notEquals(RasPoint pt) throws RasDimensionMismatchException {
        return !this.equals(pt);
    }

    public RasPoint add(RasPoint pt) throws RasDimensionMismatchException {
        if (this.dimensionality != pt.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, pt.dimension());
        }
        try {
            RasPoint result = new RasPoint(this.dimensionality);
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.points[i] + pt.item(i));
            }
            return result;
        }
        catch (RasException e) {
            System.err.println("Error in method RasPoint.add().");
            return null;
        }
    }

    public RasPoint mult(RasPoint pt) throws RasDimensionMismatchException {
        if (this.dimensionality != pt.dimension()) {
            throw new RasDimensionMismatchException((long)this.dimensionality, pt.dimension());
        }
        try {
            RasPoint result = new RasPoint(this.dimensionality);
            for (int i = 0; i < this.dimensionality; ++i) {
                result.stream(this.points[i] * pt.item(i));
            }
            return result;
        }
        catch (RasException e) {
            System.err.println("Error in method RasPoint.mult().");
            return null;
        }
    }

    public int dimension() {
        return this.dimensionality;
    }

    public String toString() {
        String retString = "";
        if (this.dimensionality > 0) {
            for (int i = 0; i < this.dimensionality - 1; ++i) {
                retString = retString + Long.toString(this.points[i]) + ",";
            }
            retString = retString + Long.toString(this.points[this.dimensionality - 1]);
        }
        return "[" + retString + "]";
    }
}

