/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import rasj.RasBaseType;
import rasj.RasTypeInvalidException;
import rasj.global.RasGlobalDefs;

public class RasPrimitiveType
extends RasBaseType
implements RasGlobalDefs {
    static final String rcsid = "@(#)Package rasj, class RasPrimitiveType: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasPrimitiveType.java,v 1.8 2003/12/10 21:04:23 rasdev Exp $";
    private String rasTypeName = null;

    public RasPrimitiveType() {
    }

    public RasPrimitiveType(String name, int type) {
        super(name, 0L);
        this.typeID = type;
        switch (this.typeID) {
            case 12: {
                this.typeSize = 4L;
                this.rasTypeName = "RAS_LONG";
                break;
            }
            case 13: {
                this.typeSize = 4L;
                this.rasTypeName = "RAS_ULONG";
                break;
            }
            case 10: {
                this.typeSize = 2L;
                this.rasTypeName = "RAS_SHORT";
                break;
            }
            case 11: {
                this.typeSize = 2L;
                this.rasTypeName = "RAS_USHORT";
                break;
            }
            case 16: {
                this.typeSize = 1L;
                this.rasTypeName = "RAS_BOOLEAN";
                break;
            }
            case 17: {
                this.typeSize = 1L;
                this.rasTypeName = "RAS_BYTE";
                break;
            }
            case 15: {
                this.typeSize = 8L;
                this.rasTypeName = "RAS_DOUBLE";
                break;
            }
            case 14: {
                this.typeSize = 4L;
                this.rasTypeName = "RAS_FLOAT";
                break;
            }
            case 18: {
                this.typeSize = 1L;
                this.rasTypeName = "RAS_CHAR";
            }
        }
    }

    public int getTypeID() {
        return this.typeID;
    }

    public String toString() {
        return super.toString();
    }

    public Boolean getBoolean(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 16) {
            throw new RasTypeInvalidException("RAS_BOOLEAN", this.rasTypeName);
        }
        return (Boolean)cell;
    }

    public Character getCharacter(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 18) {
            throw new RasTypeInvalidException("RAS_CHAR", this.rasTypeName);
        }
        return (Character)cell;
    }

    public Byte getByte(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 17) {
            throw new RasTypeInvalidException("RAS_BYTE", this.rasTypeName);
        }
        return (Byte)cell;
    }

    public Short getShort(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 10) {
            throw new RasTypeInvalidException("RAS_SHORT", this.rasTypeName);
        }
        return (Short)cell;
    }

    public Integer getInteger(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 12 || this.typeID != 11) {
            throw new RasTypeInvalidException("RAS_LONG", this.rasTypeName);
        }
        return (Integer)cell;
    }

    public Long getLong(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 13) {
            throw new RasTypeInvalidException("RAS_ULONG", this.rasTypeName);
        }
        return (Long)cell;
    }

    public Float getFloat(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 14) {
            throw new RasTypeInvalidException("RAS_FLOAT", this.rasTypeName);
        }
        return (Float)cell;
    }

    public Double getDouble(Object cell) throws RasTypeInvalidException {
        if (this.typeID != 15) {
            throw new RasTypeInvalidException("RAS_DOUBLE", this.rasTypeName);
        }
        return (Double)cell;
    }
}

