/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.StringTokenizer;
import org.odmg.QueryInvalidException;
import rasj.global.RasErrorTexts;

public class RasQueryExecutionFailedException
extends QueryInvalidException {
    static final String rcsid = "@(#)Package rasj, class RasQueryExecutionFailedException: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasQueryExecutionFailedException.java,v 1.10 2003/12/19 16:22:27 rasdev Exp $";
    private int errNo;
    private int line;
    private int column;
    private String token;

    public RasQueryExecutionFailedException(String string) {
        if (string == null) {
            this.line = 0;
            this.column = 0;
            this.token = "(null)";
        } else {
            StringTokenizer tokenizer = new StringTokenizer(string, "\t");
            String Ttoken = tokenizer.nextToken();
            Ttoken = tokenizer.nextToken();
            this.errNo = Integer.parseInt(Ttoken);
            if (tokenizer.hasMoreTokens()) {
                this.line = Integer.parseInt(tokenizer.nextToken());
                this.column = Integer.parseInt(tokenizer.nextToken());
                this.token = tokenizer.nextToken();
            } else {
                this.line = 0;
                this.column = 0;
                this.token = "";
            }
        }
    }

    public RasQueryExecutionFailedException(int errorNo, int lineNo, int colNo, String tok) {
        this.errNo = errorNo;
        this.line = lineNo;
        this.column = colNo;
        this.token = tok == null ? "(null)" : tok;
    }

    public String getMessage() {
        if (super.getMessage() == null) {
            String msg = RasErrorTexts.getErrorMessage(this.errNo);
            StringBuffer buf = new StringBuffer(msg);
            int index = msg.indexOf("$token");
            if (index != -1) {
                buf.replace(index, index + "$token".length(), this.token);
            }
            if ((index = (msg = buf.toString()).indexOf("$errorNo")) != -1) {
                buf.replace(index, index + "$errorNo".length(), String.valueOf(this.errNo));
            }
            if ((index = (msg = buf.toString()).indexOf("$lineNo")) != -1) {
                buf.replace(index, index + "$lineNo".length(), String.valueOf(this.line));
            }
            if ((index = (msg = buf.toString()).indexOf("$columnNo")) != -1) {
                buf.replace(index, index + "$columnNo".length(), String.valueOf(this.column));
            }
            return buf.toString();
        }
        return super.getMessage();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getToken() {
        return this.token;
    }
}

