/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.StringTokenizer;
import rasj.RasResultIsNoIntervalException;

public class RasSInterval {
    static final String rcsid = "@(#)Package rasj, class RasSInterval: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasSInterval.java,v 1.7 2003/12/10 21:04:23 rasdev Exp $";
    long lowerBound;
    long upperBound;
    boolean lowFixed;
    boolean highFixed;

    public RasSInterval() {
        this.lowerBound = 0L;
        this.upperBound = 0L;
        this.lowFixed = false;
        this.highFixed = false;
    }

    public RasSInterval(RasSInterval sint) {
        this.lowerBound = sint.lowerBound;
        this.upperBound = sint.upperBound;
        this.lowFixed = sint.lowFixed;
        this.highFixed = sint.highFixed;
    }

    public RasSInterval(String stringRep) throws RasResultIsNoIntervalException {
        this.lowerBound = 0L;
        this.upperBound = 0L;
        this.lowFixed = false;
        this.highFixed = false;
        StringTokenizer strTok = new StringTokenizer(stringRep.trim(), ":");
        String strCurTok = strTok.nextToken();
        if (strCurTok.equals("*")) {
            this.setLow('*');
        } else {
            this.setLow(Long.parseLong(strCurTok.trim()));
        }
        strCurTok = strTok.nextToken();
        if (strCurTok.equals("*")) {
            this.setHigh('*');
        } else {
            this.setHigh(Long.parseLong(strCurTok.trim()));
        }
    }

    public RasSInterval(long low, long high) throws RasResultIsNoIntervalException {
        this.lowerBound = low;
        this.upperBound = high;
        this.lowFixed = true;
        this.highFixed = true;
        if (low > high) {
            throw new RasResultIsNoIntervalException();
        }
    }

    public RasSInterval(char c, long high) {
        this.lowerBound = 0L;
        this.upperBound = high;
        this.lowFixed = false;
        this.highFixed = true;
    }

    public RasSInterval(long low, char c) {
        this.lowerBound = low;
        this.upperBound = 0L;
        this.lowFixed = true;
        this.highFixed = false;
    }

    public RasSInterval(char c1, char c2) {
        this.lowerBound = 0L;
        this.upperBound = 0L;
        this.lowFixed = false;
        this.highFixed = false;
    }

    public boolean equals(RasSInterval interval) {
        boolean returnValue = true;
        returnValue = this.lowFixed ? (returnValue &= interval.lowFixed && this.lowerBound == interval.lowerBound) : (returnValue &= !interval.lowFixed);
        returnValue = this.highFixed ? (returnValue &= interval.highFixed && this.upperBound == interval.upperBound) : (returnValue &= !interval.highFixed);
        return returnValue;
    }

    public boolean notEquals(RasSInterval interval) {
        return !this.equals(interval);
    }

    public long low() {
        return this.lowerBound;
    }

    public long high() {
        return this.upperBound;
    }

    public boolean isLowFixed() {
        return this.lowFixed;
    }

    public boolean isHighFixed() {
        return this.highFixed;
    }

    public void setLow(long low) throws RasResultIsNoIntervalException {
        if (this.highFixed && low > this.upperBound) {
            throw new RasResultIsNoIntervalException();
        }
        this.lowerBound = low;
        this.lowFixed = true;
    }

    public void setHigh(long high) throws RasResultIsNoIntervalException {
        if (this.lowFixed && high < this.lowerBound) {
            throw new RasResultIsNoIntervalException();
        }
        this.upperBound = high;
        this.highFixed = true;
    }

    public void setLow(char c) {
        this.lowerBound = 0L;
        this.lowFixed = false;
    }

    public void setHigh(char c) {
        this.upperBound = 0L;
        this.highFixed = false;
    }

    public void setInterval(long low, long high) throws RasResultIsNoIntervalException {
        if (low > high) {
            throw new RasResultIsNoIntervalException();
        }
        this.lowerBound = low;
        this.upperBound = high;
        this.lowFixed = true;
        this.highFixed = true;
    }

    public void setInterval(char c, long high) {
        this.lowerBound = 0L;
        this.upperBound = high;
        this.lowFixed = false;
        this.highFixed = true;
    }

    public void setInterval(long low, char c) {
        this.lowerBound = low;
        this.upperBound = 0L;
        this.lowFixed = true;
        this.highFixed = false;
    }

    public void setInterval(char c1, char c2) {
        this.lowerBound = 0L;
        this.upperBound = 0L;
        this.lowFixed = false;
        this.highFixed = false;
    }

    public int intersectsWith(RasSInterval interval) {
        int classnr = this.classify(this, interval);
        if (classnr != 1 && classnr != 6 && classnr != 16 && classnr != 21 && classnr != 26 && classnr != 31 && classnr != 34 && classnr != 37) {
            return classnr;
        }
        return -1;
    }

    public RasSInterval unionOf(RasSInterval interval1, RasSInterval interval2) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcUnion(interval1, interval2), this);
        return this;
    }

    public RasSInterval unionWith(RasSInterval interval) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcUnion(this, interval), this);
        return this;
    }

    public RasSInterval addToSelf(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval retInterval = new RasSInterval();
        retInterval = this.calcUnion(interval, this);
        return retInterval;
    }

    public RasSInterval createUnion(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcUnion(interval, this);
        return result;
    }

    public RasSInterval add(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcUnion(interval, this);
        return result;
    }

    public RasSInterval differenceOf(RasSInterval interval1, RasSInterval interval2) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcDifference(interval1, interval2), this);
        return this;
    }

    public RasSInterval differenceWith(RasSInterval interval) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcDifference(interval, this), this);
        return this;
    }

    public RasSInterval diffFromSelf(RasSInterval interval) throws RasResultIsNoIntervalException {
        return this.differenceWith(interval);
    }

    public RasSInterval createDifference(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcDifference(interval, this);
        return result;
    }

    public RasSInterval diff(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcDifference(interval, this);
        return result;
    }

    public RasSInterval intersectionOf(RasSInterval interval1, RasSInterval interval2) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcIntersection(interval1, interval2), this);
        return this;
    }

    public RasSInterval intersectionWith(RasSInterval interval) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcIntersection(interval, this), this);
        return this;
    }

    public RasSInterval multWithSelf(RasSInterval interval) throws RasResultIsNoIntervalException {
        return this.intersectionWith(interval);
    }

    public RasSInterval createIntersection(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcIntersection(interval, this);
        return result;
    }

    public RasSInterval mult(RasSInterval interval) throws RasResultIsNoIntervalException {
        return this.createIntersection(interval);
    }

    public RasSInterval closureOf(RasSInterval interval1, RasSInterval interval2) throws RasResultIsNoIntervalException {
        this.copySInterval(this.calcClosure(interval1, interval2), this);
        return this;
    }

    public RasSInterval closureWith(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval retInterval = new RasSInterval();
        retInterval = this.calcClosure(interval, this);
        return retInterval;
    }

    public RasSInterval createClosure(RasSInterval interval) throws RasResultIsNoIntervalException {
        RasSInterval result = this.calcClosure(interval, this);
        return result;
    }

    private long getStorageSize() {
        return 18L;
    }

    private void copySInterval(RasSInterval source, RasSInterval target) {
        target.lowerBound = source.lowerBound;
        target.upperBound = source.upperBound;
        target.highFixed = source.highFixed;
        target.lowFixed = source.lowFixed;
    }

    private RasSInterval calcUnion(RasSInterval a, RasSInterval b) throws RasResultIsNoIntervalException {
        RasSInterval result = new RasSInterval();
        switch (this.classify(a, b)) {
            case 2: 
            case 7: 
            case 9: 
            case 12: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 35: 
            case 36: {
                if (a.isLowFixed()) {
                    result.setLow(a.low());
                } else {
                    result.setLow('*');
                }
                if (b.isHighFixed()) {
                    result.setHigh(b.high());
                    break;
                }
                result.setHigh('*');
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 38: 
            case 39: {
                if (b.isLowFixed()) {
                    result.setLow(b.low());
                } else {
                    result.setLow('*');
                }
                if (a.isHighFixed()) {
                    result.setHigh(a.high());
                    break;
                }
                result.setHigh('*');
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: 
            case 52: {
                result = a;
                break;
            }
            case 5: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 40: 
            case 45: 
            case 47: 
            case 50: 
            case 51: {
                result = b;
                break;
            }
            default: {
                throw new RasResultIsNoIntervalException();
            }
        }
        return result;
    }

    private RasSInterval calcDifference(RasSInterval a, RasSInterval b) throws RasResultIsNoIntervalException {
        RasSInterval result = new RasSInterval();
        switch (this.classify(a, b)) {
            case 2: 
            case 9: 
            case 20: 
            case 23: 
            case 28: 
            case 36: 
            case 39: 
            case 43: 
            case 49: {
                if (a.isLowFixed()) {
                    result.setLow(a.low());
                } else {
                    result.setLow('*');
                }
                if (b.isLowFixed()) {
                    result.setHigh(b.low());
                    break;
                }
                result.setHigh('*');
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                result = a;
                break;
            }
            case 4: 
            case 10: 
            case 15: 
            case 18: 
            case 33: 
            case 42: 
            case 48: {
                if (b.isHighFixed()) {
                    result.setLow(b.high());
                } else {
                    result.setLow('*');
                }
                if (a.isHighFixed()) {
                    result.setHigh(a.high());
                    break;
                }
                result.setHigh('*');
                break;
            }
            default: {
                throw new RasResultIsNoIntervalException();
            }
        }
        return result;
    }

    private RasSInterval calcIntersection(RasSInterval a, RasSInterval b) throws RasResultIsNoIntervalException {
        RasSInterval result = new RasSInterval();
        switch (this.classify(a, b)) {
            case 4: 
            case 18: 
            case 33: 
            case 39: {
                if (a.isLowFixed()) {
                    result.setLow(a.low());
                } else {
                    result.setLow('*');
                }
                if (b.isHighFixed()) {
                    result.setHigh(b.high());
                    break;
                }
                result.setHigh('*');
                break;
            }
            case 2: 
            case 23: 
            case 28: 
            case 36: {
                if (b.isLowFixed()) {
                    result.setLow(b.low());
                } else {
                    result.setLow('*');
                }
                if (a.isHighFixed()) {
                    result.setHigh(a.high());
                    break;
                }
                result.setHigh('*');
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: {
                result = a;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 42: 
            case 43: 
            case 46: 
            case 48: 
            case 49: {
                result = b;
                break;
            }
            case 7: 
            case 22: 
            case 27: 
            case 35: {
                if (a.isHighFixed()) {
                    result.setInterval(a.high(), a.high());
                    break;
                }
                result.setInterval('*', '*');
                break;
            }
            case 8: 
            case 17: 
            case 32: 
            case 38: {
                if (b.isHighFixed()) {
                    result.setInterval(b.high(), b.high());
                    break;
                }
                result.setInterval('*', '*');
                break;
            }
            default: {
                throw new RasResultIsNoIntervalException();
            }
        }
        return result;
    }

    private RasSInterval calcClosure(RasSInterval a, RasSInterval b) throws RasResultIsNoIntervalException {
        RasSInterval closure = new RasSInterval();
        if (!a.isLowFixed() || !b.isLowFixed()) {
            closure.setLow('*');
        } else {
            closure.setLow(Math.min(a.low(), b.low()));
        }
        if (!a.isHighFixed() || !b.isHighFixed()) {
            closure.setHigh('*');
        } else {
            closure.setHigh(Math.max(a.high(), b.high()));
        }
        return closure;
    }

    private int classify(RasSInterval a, RasSInterval b) {
        int classification = 0;
        classification = a.isLowFixed() && a.isHighFixed() && b.isLowFixed() && b.isHighFixed() ? (a.low() < b.low() ? (a.high() < b.high() ? (a.high() < b.low() ? 1 : (a.high() == b.low() ? 7 : 2)) : (a.high() == b.high() ? 9 : 3)) : (a.low() == b.low() ? (a.high() < b.high() ? 12 : (a.high() == b.high() ? 11 : 10)) : (a.high() < b.high() ? 5 : (a.high() == b.high() ? 13 : (a.low() < b.high() ? 4 : (a.low() == b.high() ? 8 : 6)))))) : (a.isLowFixed() && !a.isHighFixed() && b.isLowFixed() && b.isHighFixed() ? (a.low() < b.low() ? 14 : (a.low() == b.low() ? 15 : (b.high() < a.low() ? 16 : (b.high() == a.low() ? 17 : 18)))) : (!a.isLowFixed() && a.isHighFixed() && b.isLowFixed() && b.isHighFixed() ? (a.high() > b.high() ? 19 : (a.high() == b.high() ? 20 : (a.high() < b.low() ? 21 : (a.high() == b.low() ? 22 : 23)))) : (a.isLowFixed() && a.isHighFixed() && b.isLowFixed() && !b.isHighFixed() ? (b.low() < a.low() ? 24 : (b.low() == a.low() ? 25 : (a.high() < b.low() ? 26 : (a.high() == b.low() ? 27 : 28)))) : (a.isLowFixed() && a.isHighFixed() && !b.isLowFixed() && b.isHighFixed() ? (b.high() > a.high() ? 29 : (b.high() == a.high() ? 30 : (b.high() < a.low() ? 31 : (b.high() == a.low() ? 32 : 33)))) : (!a.isLowFixed() && a.isHighFixed() && b.isLowFixed() && !b.isHighFixed() ? (a.high() < b.low() ? 34 : (a.high() == b.low() ? 35 : 36)) : (a.isLowFixed() && !a.isHighFixed() && !b.isLowFixed() && b.isHighFixed() ? (b.high() < a.low() ? 37 : (b.high() == a.low() ? 38 : 39)) : (!a.isLowFixed() && a.isHighFixed() && !b.isLowFixed() && b.isHighFixed() ? (a.high() < b.high() ? 40 : (a.high() == b.high() ? 41 : 42)) : (a.isLowFixed() && !a.isHighFixed() && b.isLowFixed() && !b.isHighFixed() ? (a.low() < b.low() ? 43 : (a.low() == b.low() ? 44 : 45)) : (!a.isLowFixed() && !a.isHighFixed() && b.isLowFixed() && b.isHighFixed() ? 46 : (a.isLowFixed() && a.isHighFixed() && !b.isLowFixed() && !b.isHighFixed() ? 47 : (!a.isLowFixed() && !a.isHighFixed() && !b.isLowFixed() && b.isHighFixed() ? 48 : (!a.isLowFixed() && !a.isHighFixed() && b.isLowFixed() && !b.isHighFixed() ? 49 : (!a.isLowFixed() && a.isHighFixed() && !b.isLowFixed() && !b.isHighFixed() ? 50 : (a.isLowFixed() && !a.isHighFixed() && !b.isLowFixed() && !b.isHighFixed() ? 51 : 52))))))))))))));
        return classification;
    }

    public String toString() {
        return (this.lowFixed ? Long.toString(this.lowerBound) : "*") + ":" + (this.highFixed ? Long.toString(this.upperBound) : "*");
    }
}

