/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.odmg.DList;
import rasj.RasBaseType;
import rasj.RasResultIsNoIntervalException;
import rasj.RasStructureType;
import rasj.odmg.RasList;
import rasj.rnp.RasRNPImplementation;

public class RasStructure {
    private DList elements;
    private RasStructureType type;

    public RasStructure(RasStructureType type, DataInputStream dis) throws IOException, RasResultIsNoIntervalException {
        RasBaseType[] bts;
        this.type = type;
        this.elements = new RasList();
        for (RasBaseType bt : bts = type.getBaseTypes()) {
            if (bt == null) continue;
            this.elements.add(RasRNPImplementation.getElement(dis, bt, null));
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("{");
        int i = 0;
        for (Object element : this.elements) {
            if (element == null) continue;
            if (i > 0) {
                ret.append(",");
            }
            ret.append(" ").append(element.toString());
            i = 1;
        }
        ret.append(" }");
        return ret.toString();
    }

    public List getElements() {
        return this.elements;
    }

    public RasStructureType getType() {
        return this.type;
    }
}

