/*
 * Decompiled with CFR 0.152.
 */
package rasj;

import java.util.StringTokenizer;
import rasj.RasBaseType;
import rasj.RasCollectionType;
import rasj.RasMArrayType;
import rasj.RasMIntervalType;
import rasj.RasOIDType;
import rasj.RasPointType;
import rasj.RasPrimitiveType;
import rasj.RasSIntervalType;
import rasj.RasStructureType;
import rasj.RasTypeUnknownException;

public class RasType {
    static final String rcsid = "@(#)Package rasj, class RasType: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/RasType.java,v 1.10 2003/12/10 21:04:23 rasdev Exp $";
    protected String typeName;
    protected int typeID;

    public RasType() {
        this.typeName = "";
        this.typeID = 0;
    }

    public RasType(String newTypeName) {
        this.typeName = newTypeName;
        this.typeID = 0;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public String getName() {
        return this.typeName;
    }

    public boolean isStructType() {
        return false;
    }

    public boolean isBaseType() {
        return false;
    }

    public static RasType getAnyType(String typeString) {
        StringTokenizer strTok = new StringTokenizer(typeString, "{}[]<>,: ");
        String currentStr = "";
        RasType returnValue = null;
        if (strTok.hasMoreTokens()) {
            currentStr = strTok.nextToken();
            returnValue = currentStr.equals("set") ? RasType.getSet(strTok.nextToken("")) : (currentStr.equals("marray") ? RasType.getMArrayType(strTok.nextToken("")) : RasType.getType(typeString));
        }
        return returnValue;
    }

    private static RasType getSet(String setStr) {
        StringTokenizer setTok = new StringTokenizer(setStr, "{}[]<>,: ");
        String currentStr = "";
        RasCollectionType returnValue = null;
        RasType elementType = null;
        if (setTok.hasMoreTokens()) {
            currentStr = setTok.nextToken();
            elementType = currentStr.equals("marray") ? RasType.getMArrayType(setTok.nextToken("")) : RasType.getType(setStr);
        }
        returnValue = new RasCollectionType(elementType);
        return returnValue;
    }

    private static RasType getType(String typeStr) {
        StringTokenizer typeTok = new StringTokenizer(typeStr, "{}[]<>,: ");
        String currentStr = "";
        RasType returnValue = null;
        if (typeTok.hasMoreTokens()) {
            currentStr = typeTok.nextToken();
            if (currentStr.equals("struct")) {
                returnValue = RasType.getStructureType(typeTok.nextToken(""));
            } else if (currentStr.equals("interval")) {
                returnValue = RasType.getSIntervalType(typeTok.nextToken(""));
                returnValue.typeID = 3;
            } else if (currentStr.equals("minterval")) {
                returnValue = RasType.getMIntervalType(typeTok.nextToken(""));
                returnValue.typeID = 4;
            } else if (currentStr.equals("point")) {
                returnValue = RasType.getPointType(typeTok.nextToken(""));
                returnValue.typeID = 5;
            } else if (currentStr.equals("oid")) {
                returnValue = RasType.getOIDType(typeTok.nextToken(""));
                returnValue.typeID = 6;
            } else {
                returnValue = RasType.getPrimitiveType(typeStr);
            }
        }
        return returnValue;
    }

    private static RasMArrayType getMArrayType(String mArrayStr) {
        RasMArrayType returnValue = null;
        RasBaseType baseType = null;
        baseType = RasType.getBaseType(mArrayStr);
        returnValue = new RasMArrayType(baseType);
        return returnValue;
    }

    private static RasBaseType getBaseType(String baseStr) {
        StringTokenizer baseTok = new StringTokenizer(baseStr, "{}[]<>,: ");
        String currentStr = "";
        RasBaseType returnValue = null;
        if (baseTok.hasMoreTokens()) {
            currentStr = baseTok.nextToken();
            returnValue = currentStr.equals("struct") ? RasType.getStructureType(baseTok.nextToken("")) : RasType.getPrimitiveType(baseStr);
        }
        return returnValue;
    }

    private static RasPrimitiveType getPrimitiveType(String primStr) throws RasTypeUnknownException {
        StringTokenizer primTok = new StringTokenizer(primStr, "{}[]<>,: ");
        String currentStr = "";
        RasPrimitiveType returnValue = null;
        if (primTok.hasMoreTokens()) {
            currentStr = primTok.nextToken();
            if (currentStr.equals("char")) {
                returnValue = new RasPrimitiveType("RAS_CHAR", 18);
            } else if (currentStr.equals("octet")) {
                returnValue = new RasPrimitiveType("RAS_BYTE", 17);
            } else if (currentStr.equals("short")) {
                returnValue = new RasPrimitiveType("RAS_SHORT", 10);
            } else if (currentStr.equals("ushort")) {
                returnValue = new RasPrimitiveType("RAS_USHORT", 11);
            } else if (currentStr.equals("long")) {
                returnValue = new RasPrimitiveType("RAS_LONG", 12);
            } else if (currentStr.equals("ulong")) {
                returnValue = new RasPrimitiveType("RAS_ULONG", 13);
            } else if (currentStr.equals("bool")) {
                returnValue = new RasPrimitiveType("RAS_BOOLEAN", 16);
            } else if (currentStr.equals("float")) {
                returnValue = new RasPrimitiveType("RAS_FLOAT", 14);
            } else if (currentStr.equals("double")) {
                returnValue = new RasPrimitiveType("RAS_DOUBLE", 15);
            } else {
                throw new RasTypeUnknownException(currentStr);
            }
        }
        return returnValue;
    }

    private static RasStructureType getStructureType(String structStr) throws RasTypeUnknownException {
        String more;
        int structureEnd = structStr.indexOf("}");
        if (structureEnd < 0) {
            throw new RasTypeUnknownException("Incorrect structure schema");
        }
        StringTokenizer structTok = new StringTokenizer(structStr.substring(0, structureEnd), "[]<>,: ");
        RasStructureType returnValue = null;
        String structName = "";
        if (structTok.hasMoreTokens()) {
            structName = structTok.nextToken();
            if (structName.equals("{")) {
                structName = "";
            } else {
                structTok.nextToken();
            }
        } else {
            throw new RasTypeUnknownException("");
        }
        int size = structTok.countTokens() / 2;
        RasBaseType[] baseType = new RasBaseType[size];
        String[] attributeName = new String[size];
        for (int i = 0; i < attributeName.length && !(more = structTok.nextToken()).equals("}"); ++i) {
            baseType[i] = RasType.getBaseType(more);
            if (!structTok.hasMoreTokens()) {
                throw new RasTypeUnknownException("");
            }
            attributeName[i] = structTok.nextToken();
        }
        returnValue = new RasStructureType(structName, baseType, attributeName);
        return returnValue;
    }

    private static RasSIntervalType getSIntervalType(String sintStr) {
        return new RasSIntervalType();
    }

    private static RasMIntervalType getMIntervalType(String mintStr) {
        return new RasMIntervalType();
    }

    private static RasPointType getPointType(String pointStr) {
        return new RasPointType();
    }

    private static RasOIDType getOIDType(String oidStr) {
        return new RasOIDType();
    }

    public String toString() {
        return "typeName: " + this.typeName + "\n typeID:  " + this.typeID + "\n ";
    }
}

