/*
 * Decompiled with CFR 0.152.
 */
package rasj.clientcommhttp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.odmg.DBag;
import org.odmg.DCollection;
import rasj.RasBaseType;
import rasj.RasClientInternalException;
import rasj.RasCollectionType;
import rasj.RasConnectionFailedException;
import rasj.RasGMArray;
import rasj.RasMArrayByte;
import rasj.RasMArrayDouble;
import rasj.RasMArrayFloat;
import rasj.RasMArrayInteger;
import rasj.RasMArrayLong;
import rasj.RasMArrayShort;
import rasj.RasMArrayType;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasPrimitiveType;
import rasj.RasQueryExecutionFailedException;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStructureType;
import rasj.RasType;
import rasj.RasTypeNotSupportedException;
import rasj.clientcommhttp.RasCommDefs;
import rasj.clientcommhttp.RasUtils;
import rasj.global.BenchmarkTimer;
import rasj.global.Debug;
import rasj.global.RasGlobalDefs;
import rasj.odmg.RasBag;
import rasj.odmg.RasOID;

public class RasHttpRequest
implements RasCommDefs,
RasGlobalDefs {
    static final String rcsid = "@(#)Package rasj.clientcommhttp, class RasRequest: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/clientcommhttp/RasHttpRequest.java,v 1.35 2003/12/19 15:36:43 rasdev Exp $";
    private String client = "RASCLIENT";
    private byte resultType = 0;
    private Object result = null;

    public void execute(String serverURL, String parameters) throws RasQueryExecutionFailedException, RasConnectionFailedException {
        Debug.enterVerbose("RasHttpRequest.execute: start. serverURL=" + serverURL + ", parameters=" + parameters);
        BenchmarkTimer httpTimer = new BenchmarkTimer("httpRequest");
        BenchmarkTimer rcvTimer = new BenchmarkTimer("receive");
        try {
            URL url = new URL(serverURL);
            Debug.talkVerbose("RasHttpRequest.execute: sending to " + url + " POST request=" + parameters);
            httpTimer.startTimer();
            BenchmarkTimer sendTimer = new BenchmarkTimer("send");
            sendTimer.startTimer();
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Content-type", "application/octet-stream");
            con.setRequestProperty("User-Agent", "RasDaMan Java Client");
            con.setRequestProperty("Version", "1.0");
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            OutputStreamWriter out = new OutputStreamWriter(con.getOutputStream(), "8859_1");
            out.write(parameters, 0, parameters.length());
            out.flush();
            out.close();
            sendTimer.stopTimer();
            sendTimer.print();
            rcvTimer.startTimer();
            BenchmarkTimer getInputTimer = new BenchmarkTimer("getInputStream");
            getInputTimer.startTimer();
            DataInputStream in = new DataInputStream(con.getInputStream());
            getInputTimer.stopTimer();
            getInputTimer.print();
            byte[] b1 = new byte[1];
            byte[] b4 = new byte[4];
            byte endianess = 0;
            String collType = null;
            int numberOfResults = 0;
            int dataSize = 0;
            byte[] binData = null;
            int readBytes = 0;
            int readBytesTmp = 0;
            RasGMArray res = null;
            in.read(b1);
            this.resultType = b1[0];
            Debug.talkVerbose("RasHttpRequest.execute: resultType=" + this.resultType);
            switch (this.resultType) {
                case 98: 
                case 99: {
                    break;
                }
                case 1: {
                    Debug.talkVerbose("RasHttpRequest.execute: result type is MDD.");
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    collType = RasUtils.readString(in);
                    Debug.talkVerbose("RasHttpRequest.execute: colltype=" + collType);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    numberOfResults = RasUtils.ubytesToInt(b4, endianess);
                    Debug.talkVerbose("RasHttpRequest.execute: number of results: " + numberOfResults);
                    RasBag resultBag = new RasBag();
                    String mddBaseType = null;
                    String domain = null;
                    String oid = "";
                    RasOID roid = null;
                    for (int x = 0; x < numberOfResults; ++x) {
                        Debug.talkVerbose("RasHttpRequest.execute: handling result #" + (x + 1));
                        mddBaseType = RasUtils.readString(in);
                        domain = RasUtils.readString(in);
                        oid = RasUtils.readString(in);
                        roid = new RasOID(oid);
                        while (in.available() < 4) {
                        }
                        in.read(b4);
                        dataSize = RasUtils.ubytesToInt(b4, endianess);
                        Debug.talkVerbose("RasHttpRequest.execute: mddBaseType is " + mddBaseType + ", spatialDomain=" + domain + ", size of BinData=" + dataSize);
                        binData = new byte[dataSize];
                        readBytesTmp = 0;
                        for (readBytes = 0; readBytesTmp != -1 && readBytes < dataSize; readBytes += readBytesTmp) {
                            readBytesTmp = in.read(binData, readBytes, dataSize - readBytes);
                        }
                        Debug.talkVerbose("RasHttpRequest.execute: read " + readBytes + " bytes.");
                        RasType rType = RasType.getAnyType(mddBaseType);
                        RasBaseType rb = null;
                        if (!rType.getClass().getName().equals("rasj.RasMArrayType")) {
                            Debug.talkCritical("RasHttpRequest.execute: exception: element of MDD Collection is no MArray");
                            throw new RasClientInternalException("RasHttpRequest", "execute()", "element of MDD Collection is no MArray");
                        }
                        RasMArrayType tmp = (RasMArrayType)rType;
                        rb = tmp.getBaseType();
                        if (rb.isBaseType()) {
                            if (rb.isStructType()) {
                                RasStructureType sType = (RasStructureType)rb;
                                res = new RasGMArray(new RasMInterval(domain), 0L);
                                res.setTypeLength(rb.getSize());
                                res.setArraySize(dataSize);
                                res.setArray(binData);
                                res.setTypeStructure(mddBaseType);
                                resultBag.add(res);
                                break;
                            }
                            RasPrimitiveType pType = (RasPrimitiveType)rb;
                            switch (pType.getTypeID()) {
                                case 16: 
                                case 17: 
                                case 18: {
                                    res = new RasMArrayByte(new RasMInterval(domain));
                                    break;
                                }
                                case 10: {
                                    res = new RasMArrayShort(new RasMInterval(domain));
                                    break;
                                }
                                case 11: {
                                    byte[] tmData = new byte[dataSize * 2];
                                    for (int i = 0; i < dataSize * 2; i += 4) {
                                        tmData[i] = 0;
                                        tmData[i + 1] = 0;
                                        tmData[i + 2] = binData[i / 2];
                                        tmData[i + 3] = binData[i / 2 + 1];
                                    }
                                    binData = tmData;
                                    res = new RasMArrayInteger(new RasMInterval(domain));
                                    break;
                                }
                                case 9: 
                                case 12: {
                                    res = new RasMArrayInteger(new RasMInterval(domain));
                                    break;
                                }
                                case 13: {
                                    byte[] tmpData = new byte[dataSize * 2];
                                    for (int i = 0; i < dataSize * 2; i += 8) {
                                        tmpData[i] = 0;
                                        tmpData[i + 1] = 0;
                                        tmpData[i + 2] = 0;
                                        tmpData[i + 3] = 0;
                                        tmpData[i + 4] = binData[i / 2];
                                        tmpData[i + 5] = binData[i / 2 + 1];
                                        tmpData[i + 6] = binData[i / 2 + 2];
                                        tmpData[i + 7] = binData[i / 2 + 3];
                                    }
                                    binData = tmpData;
                                    res = new RasMArrayLong(new RasMInterval(domain));
                                    break;
                                }
                                case 14: {
                                    res = new RasMArrayFloat(new RasMInterval(domain));
                                    break;
                                }
                                case 15: {
                                    res = new RasMArrayDouble(new RasMInterval(domain));
                                    break;
                                }
                                default: {
                                    res = new RasGMArray(new RasMInterval(domain), pType.getSize());
                                }
                            }
                        } else {
                            throw new RasClientInternalException("RasHttpRequest", "execute()", "Type of MDD is no Base Type");
                        }
                        res.setArray(binData);
                        res.setOID(roid);
                        res.setTypeStructure(mddBaseType);
                        resultBag.add(res);
                    }
                    this.result = resultBag;
                    in.close();
                    break;
                }
                case 2: {
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    collType = RasUtils.readString(in);
                    RasType rt = new RasType();
                    try {
                        rt = RasType.getAnyType(collType);
                    }
                    catch (Exception e) {
                        throw new RasTypeNotSupportedException(rt + " as RasCollectionType");
                    }
                    if (rt.getTypeID() != 2) {
                        throw new RasTypeNotSupportedException(rt + " as RasCollectionType");
                    }
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    numberOfResults = RasUtils.ubytesToInt(b4, endianess);
                    RasBag resultBag = new RasBag();
                    block45: for (int x = 0; x < numberOfResults; ++x) {
                        String elementType = RasUtils.readString(in);
                        RasType et = new RasType();
                        et = ((RasCollectionType)rt).getElementType();
                        while (in.available() < 4) {
                        }
                        in.read(b4);
                        dataSize = RasUtils.ubytesToInt(b4, endianess);
                        binData = new byte[dataSize];
                        readBytesTmp = 0;
                        for (readBytes = 0; readBytesTmp != -1 && readBytes < dataSize; readBytes += readBytesTmp) {
                            readBytesTmp = in.read(binData, readBytes, dataSize - readBytes);
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(binData);
                        DataInputStream dis = new DataInputStream(bis);
                        switch (et.getTypeID()) {
                            case 4: {
                                resultBag.add(new RasMInterval(new String(binData)));
                                continue block45;
                            }
                            case 3: {
                                resultBag.add(new RasSInterval(new String(binData)));
                                continue block45;
                            }
                            case 5: {
                                resultBag.add(new RasPoint(new String(binData)));
                                continue block45;
                            }
                            case 6: {
                                resultBag.add(new RasOID(new String(binData)));
                                continue block45;
                            }
                            case 16: 
                            case 17: 
                            case 18: {
                                byte b = binData[0];
                                resultBag.add(new Byte(b));
                                continue block45;
                            }
                            case 15: {
                                double d = dis.readDouble();
                                resultBag.add(new Double(d));
                                continue block45;
                            }
                            case 14: {
                                float f = dis.readFloat();
                                resultBag.add(new Float(f));
                                continue block45;
                            }
                            case 13: {
                                byte[] bu = new byte[]{0, 0, 0, 0, dis.readByte(), dis.readByte(), dis.readByte(), dis.readByte()};
                                ByteArrayInputStream bis2 = new ByteArrayInputStream(bu);
                                DataInputStream dis2 = new DataInputStream(bis2);
                                long ul = dis2.readLong();
                                resultBag.add(new Long(ul));
                                continue block45;
                            }
                            case 9: 
                            case 12: {
                                int i = dis.readInt();
                                resultBag.add(new Integer(i));
                                continue block45;
                            }
                            case 11: {
                                int j = dis.readUnsignedShort();
                                resultBag.add(new Integer(j));
                                continue block45;
                            }
                            case 10: {
                                short s = dis.readShort();
                                resultBag.add(new Short(s));
                                continue block45;
                            }
                            default: {
                                throw new RasTypeNotSupportedException(et + " as ElementType ");
                            }
                        }
                    }
                    this.result = resultBag;
                    in.close();
                    break;
                }
                case 0: {
                    Debug.talkCritical("RasHttpRequest.execute: execution failed. Error = 0");
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int errNo = RasUtils.ubytesToInt(b4, endianess);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int lineNo = RasUtils.ubytesToInt(b4, endianess);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int colNo = RasUtils.ubytesToInt(b4, endianess);
                    String token = RasUtils.readString(in);
                    Debug.talkCritical("RasHttpRequest.execute: Errno=" + errNo + ", lineNo=" + lineNo + ", colNo=" + colNo + ", Token=" + token);
                    throw new RasQueryExecutionFailedException(errNo, lineNo, colNo, token);
                }
                case 3: {
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    this.result = new Integer(RasUtils.ubytesToInt(b4, endianess));
                    break;
                }
                case 4: {
                    String sys = RasUtils.readString(in);
                    String base = RasUtils.readString(in);
                    double d = in.readDouble();
                    RasBag resultBag = new RasBag();
                    resultBag.add(new RasOID(sys, base, d));
                    this.result = resultBag;
                    in.close();
                    break;
                }
                default: {
                    Debug.talkCritical("RasHttpRequest.execute: illegal response type: " + this.resultType);
                }
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            Debug.leaveCritical("RasHttpRequest.execute: leave. malformed URL: " + e.getMessage());
            throw new RasConnectionFailedException(800, serverURL);
        }
        catch (IOException e) {
            Debug.leaveCritical("RasHttpRequest.execute: leave. IO exception: " + e.getMessage());
            throw new RasClientInternalException("RasHttpRequest", "execute()", e.getMessage());
        }
        catch (RasResultIsNoIntervalException e) {
            Debug.leaveCritical("RasHttpRequest.execute: leave. result no interval: " + e.getMessage());
            throw new RasClientInternalException("RasHttpRequest", "execute()", e.getMessage());
        }
        rcvTimer.stopTimer();
        rcvTimer.print();
        httpTimer.stopTimer();
        httpTimer.print();
        Debug.leaveVerbose("RasHttpRequest.execute: leave. resultType=" + this.resultType);
    }

    public byte getResultType() {
        return this.resultType;
    }

    public Object getResult() {
        return this.result;
    }

    public int getIntegerResult() {
        if (this.result != null) {
            Integer myInt = (Integer)this.result;
            return myInt;
        }
        return 0;
    }

    public DCollection getDCollection() {
        return (DCollection)this.result;
    }

    public DBag getDBag() {
        return (DBag)this.result;
    }

    public void setClientType(String clientType) {
        this.client = clientType;
    }
}

