/*
 * Decompiled with CFR 0.152.
 */
package rasj.global;

import rasj.global.Debug;

public class BenchmarkTimer {
    private static final String srcFileVersion = "CVS version information: $Source: /home/rasdev/CVS-repository/rasdaman/java/rasj/global/BenchmarkTimer.java,v $ $Revision: 1.1 $";
    private static final String OUTPUTPREFIX = "-- Timer ";
    String text;
    long startTime;
    long endTime;
    long totalTime;

    public BenchmarkTimer(String t) {
        this.text = t == null ? "(no text)" : t;
        this.reset();
    }

    public void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.totalTime = 0L;
    }

    public void startTimer() {
        Debug.talkSparse(OUTPUTPREFIX + this.text + " started.");
        this.startTime = System.currentTimeMillis();
    }

    public void stopTimer() {
        this.endTime = System.currentTimeMillis();
        this.totalTime += this.endTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void print() {
        Debug.talkSparse(OUTPUTPREFIX + this.text + ": " + (this.totalTime - this.startTime) + " ms elapsed.");
    }

    public static void main(String[] a) {
        Debug.enterVerbose("Benchmark test start");
        BenchmarkTimer timer = new BenchmarkTimer("Test");
        timer.startTimer();
        for (int i = 0; i < 20000000; ++i) {
        }
        timer.stopTimer();
        timer.print();
        Debug.leaveVerbose("Benchmark test stop");
    }
}

