/*
 * Decompiled with CFR 0.152.
 */
package rasj.global;

public class Debug {
    static final String rcsid = "@(#)Package rasj.global, class Debug: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/global/Debug.java,v 1.2 2006/01/19 18:24:16 rasdev Exp $";
    public static final int CRITICAL_LEVEL = 0;
    public static final int WARNING_LEVEL = 1;
    public static final int SPARSE_LEVEL = 2;
    public static final int VERBOSE_LEVEL = 3;
    public static final int DEFAULT_LEVEL = 1;
    private static int debugThreshold = 1;
    private static final String INDENT = ". ";
    private static int indentLevel = 0;

    public static void setDebugThreshold(int level) {
        if (level >= 0) {
            debugThreshold = level;
            System.err.println("Debug::setDebugThreshold: setting debug level to " + level);
        } else {
            System.err.println("Debug::setDebugThreshold: ignoring illegal debug level value: " + level);
        }
    }

    public static void enterCritical(String what) {
        Debug.enter(0, what);
    }

    public static void enterWarning(String what) {
        Debug.enter(1, what);
    }

    public static void enterSparse(String what) {
        Debug.enter(2, what);
    }

    public static void enterVerbose(String what) {
        Debug.enter(3, what);
    }

    public static void leaveCritical(String what) {
        Debug.leave(0, what);
    }

    public static void leaveWarning(String what) {
        Debug.leave(1, what);
    }

    public static void leaveSparse(String what) {
        Debug.leave(2, what);
    }

    public static void leaveVerbose(String what) {
        Debug.leave(3, what);
    }

    public static void talkCritical(String what) {
        Debug.talk(0, what);
    }

    public static void talkWarning(String what) {
        Debug.talk(1, what);
    }

    public static void talkSparse(String what) {
        Debug.talk(2, what);
    }

    public static void talkVerbose(String what) {
        Debug.talk(3, what);
    }

    private static void enter(int level, String what) {
        StringBuffer s = new StringBuffer(100);
        if (level <= debugThreshold) {
            ++indentLevel;
            s.append("rasj[" + Integer.toString(level) + "] ");
            for (int i = 0; i < indentLevel; ++i) {
                s.append(INDENT);
            }
            s.append(what);
            System.err.println(s);
        }
    }

    static void leave(int level, String what) {
        StringBuffer s = new StringBuffer(100);
        if (level <= debugThreshold) {
            s.append("rasj[" + Integer.toString(level) + "] ");
            for (int i = 0; i < indentLevel; ++i) {
                s.append(INDENT);
            }
            s.append(what);
            System.err.println(s);
            --indentLevel;
        }
    }

    static void talk(int level, String what) {
        StringBuffer s = new StringBuffer(100);
        if (level <= debugThreshold) {
            s.append("rasj[" + Integer.toString(level) + "] ");
            for (int i = 0; i < indentLevel; ++i) {
                s.append(INDENT);
            }
            s.append(what);
            System.err.println(s);
        }
    }
}

