/*
 * Decompiled with CFR 0.152.
 */
package rasj.odmg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odmg.DBag;
import rasj.global.Debug;
import rasj.odmg.RasCollection;

public class RasBag
extends RasCollection
implements DBag {
    static final String rcsid = "@(#)Package rasj.odmg, class RasBag: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/odmg/RasBag.java,v 1.3 2003/12/19 15:42:56 rasdev Exp $";
    List content;

    public RasBag() {
        Debug.enterVerbose("RasBag.constructor start.");
        this.content = new ArrayList();
        Debug.leaveVerbose("RasBag.constructor done.");
    }

    public boolean add(Object o) {
        boolean result = this.content.add(o);
        Debug.talkVerbose("RasBag.add: result=" + result);
        return result;
    }

    public int occurrences(Object obj) {
        Debug.enterVerbose("RasBag.occurrences start.");
        RasBag tmpBag = new RasBag();
        tmpBag.addAll(this.content);
        int count = 0;
        while (tmpBag.contains(obj)) {
            ++count;
            tmpBag.remove(obj);
        }
        Debug.leaveVerbose("RasBag.occurrences done. count=" + count);
        return count;
    }

    public DBag difference(DBag otherBag) {
        Debug.enterVerbose("RasBag.difference start.");
        RasBag diffBag = new RasBag();
        diffBag.addAll(otherBag);
        RasBag retBag = new RasBag();
        for (Object tmp : this.content) {
            if (!diffBag.contains(tmp)) {
                retBag.add(tmp);
                continue;
            }
            diffBag.remove(tmp);
        }
        retBag.addAll(diffBag);
        Debug.leaveVerbose("RasBag.difference done.");
        return retBag;
    }

    public DBag intersection(DBag otherBag) {
        Debug.enterVerbose("RasBag.intersection start.");
        RasBag intBag = new RasBag();
        intBag.addAll(otherBag);
        RasBag retBag = new RasBag();
        for (Object tmp : this.content) {
            if (!intBag.contains(tmp)) continue;
            retBag.add(tmp);
            intBag.remove(tmp);
        }
        Debug.leaveVerbose("RasBag.intersection done.");
        return retBag;
    }

    public DBag union(DBag otherBag) {
        Debug.enterVerbose("RasBag.union start.");
        RasBag retBag = new RasBag();
        retBag.addAll(this.content);
        retBag.addAll(otherBag);
        Debug.leaveVerbose("RasBag.union done.");
        return retBag;
    }

    public Iterator iterator() {
        Debug.talkVerbose("RasBag.iterator.");
        return this.content.iterator();
    }

    public int size() {
        int result = this.content.size();
        Debug.talkVerbose("RasBag.size: size=" + result);
        return result;
    }
}

