/*
 * Decompiled with CFR 0.152.
 */
package rasj.odmg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.NotImplementedException;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasClientInternalException;
import rasj.RasConnectionFailedException;
import rasj.RasImplementationInterface;
import rasj.RasQueryExecutionFailedException;
import rasj.clientcommhttp.RasCommDefs;
import rasj.clientcommhttp.RasHttpRequest;
import rasj.global.BenchmarkTimer;
import rasj.global.Debug;
import rasj.odmg.MD5;
import rasj.odmg.RasBag;
import rasj.odmg.RasDatabase;
import rasj.odmg.RasList;
import rasj.odmg.RasOID;
import rasj.odmg.RasOQLQuery;
import rasj.odmg.RasObject;
import rasj.odmg.RasSet;
import rasj.odmg.RasTransaction;

public class RasODMGImplementation
implements RasImplementationInterface,
RasCommDefs {
    private String rasServer = "";
    private String rasMgr = "";
    private int rasMgrPort = 7001;
    private String userIdentification = "rasguest:8e70a429be359b6dace8b5b2500dedb0";
    private String databaseName = "";
    private String capability = "dummy";
    private int maxRetry = 5;
    private boolean isOpenTA = false;
    private RasTransaction transaction = null;
    private RasDatabase database = null;
    private RasOQLQuery query = null;
    private int accessMode = 0;
    private int dbIsOpen = 0;
    private int taIsOpen = 0;
    private int clientID = 0;
    private String errorStatus = "";
    private String strHostID = null;
    private static int idcounter = 0;

    public RasODMGImplementation(String server) {
        Debug.enterVerbose("RasODMGImplementation.constructor: start, server=" + server + ".");
        try {
            StringTokenizer t = new StringTokenizer(server, "/");
            String xxx = t.nextToken();
            this.rasMgr = t.nextToken("/:");
            String portStr = t.nextToken(":");
            this.rasMgrPort = Integer.parseInt(portStr);
        }
        catch (NoSuchElementException e) {
            Debug.leaveVerbose("RasODMGImplementation.constructor: done. server URL format error.");
            throw new RasConnectionFailedException(213, server);
        }
        this.isOpenTA = false;
        Debug.leaveVerbose("RasODMGImplementation.constructor: done. ok.");
    }

    public String getRasServer() {
        Debug.talkVerbose("RasODMGImplementation.getRasServer: server=" + this.rasServer + ".");
        return this.rasServer;
    }

    public int dbIsOpen() {
        Debug.talkVerbose("RasODMGImplementation.dbIsOpen: dbIsOpen=" + this.dbIsOpen + ".");
        return this.dbIsOpen;
    }

    public int getClientID() {
        Debug.talkVerbose("RasODMGImplementation.getClientID: clientID=" + this.clientID + ".");
        return this.clientID;
    }

    public int getAccessMode() {
        Debug.talkVerbose("RasODMGImplementation.getAccessMode: accessMode=" + this.accessMode + ".");
        return this.accessMode;
    }

    public String getErrorStatus() {
        Debug.talkVerbose("RasODMGImplementation.getErrorStatus: errorStatus=" + this.errorStatus + ".");
        return this.errorStatus;
    }

    public Transaction newTransaction() {
        Debug.enterVerbose("RasODMGImplementation.newTransaction: start.");
        this.transaction = new RasTransaction(this);
        Debug.leaveVerbose("RasODMGImplementation.newTransaction: done.");
        return this.transaction;
    }

    public Transaction currentTransaction() {
        Debug.talkVerbose("RasODMGImplementation.currentTransaction.");
        return this.transaction;
    }

    public Database newDatabase() {
        Debug.enterVerbose("RasODMGImplementation.newDatabase: start.");
        this.database = new RasDatabase(this);
        Debug.leaveVerbose("RasODMGImplementation.newDatabase: done.");
        return this.database;
    }

    public OQLQuery newOQLQuery() {
        Debug.enterVerbose("RasODMGImplementation.newOQLQuery: start.");
        this.query = new RasOQLQuery(this);
        Debug.leaveVerbose("RasODMGImplementation.newOQLQuery: done.");
        return this.query;
    }

    public DList newDList() {
        Debug.talkVerbose("RasODMGImplementation.newDList.");
        return new RasList();
    }

    public DBag newDBag() {
        return new RasBag();
    }

    public DSet newDSet() {
        Debug.talkVerbose("RasODMGImplementation.newDSet.");
        return new RasSet();
    }

    public DArray newDArray() {
        Debug.talkWarning("RasODMGImplementation.newDArray: not yet implemented.");
        throw new NotImplementedException();
    }

    public DMap newDMap() {
        Debug.talkWarning("RasODMGImplementation.newDMap: not yet implemented.");
        throw new NotImplementedException();
    }

    public String getObjectId(Object obj) {
        Debug.enterVerbose("RasODMGImplementation.getObjectId: start.");
        if (!(obj instanceof RasObject)) {
            Debug.leaveWarning("RasODMGImplementation.getObjectId: not yet implemented.");
            throw new NotImplementedException();
        }
        RasOID roid = ((RasObject)obj).getOID();
        String oid = roid.toString();
        DBag resultBag = null;
        if (!((RasObject)obj).getOID().isValid()) {
            Debug.talkWarning("RasODMGImplementation.getObjectId: OID not Valid: " + roid + ".");
            String params = "ClientID=" + this.clientID + "&Command=10";
            RasHttpRequest request = new RasHttpRequest();
            if (((RasTransaction)this.currentTransaction()).isOpenLocally()) {
                try {
                    request.execute(this.rasServer, params);
                }
                catch (RasQueryExecutionFailedException e) {
                    Debug.talkCritical("RasODMGImplementation.getObjectId: query execution failed: " + e.getMessage());
                }
            } else {
                Debug.talkSparse("RasODMGImplementation.getObjectId: db not open, opening: " + this.databaseName + ".");
                boolean openedDbHere = false;
                boolean openedTaHere = false;
                Database d = null;
                Transaction t = null;
                try {
                    if (this.dbIsOpen == 0) {
                        Debug.talkSparse("RasODMGImplementation.getObjectId: db not open, opening: " + this.databaseName + ".");
                        d = this.newDatabase();
                        d.open(this.databaseName, 2);
                        openedDbHere = true;
                    }
                    t = this.newTransaction();
                    t.begin();
                    openedTaHere = true;
                    request.execute(this.rasServer, params);
                    t.commit();
                    if (openedDbHere) {
                        Debug.talkSparse("RasODMGImplementation.getObjectId: closing locally opened DB. ");
                        d.close();
                        openedDbHere = false;
                    }
                }
                catch (ODMGException e) {
                    Debug.talkCritical("RasODMGImplementation.getObjectId: failed: " + e.getMessage());
                    try {
                        if (openedTaHere) {
                            t.abort();
                        }
                        if (openedDbHere) {
                            d.close();
                        }
                    }
                    catch (ODMGException e3) {
                        Debug.talkSparse("RasODMGImplementation.getObjectId: error closing locally opened DB (ignored): " + e3.getMessage());
                    }
                }
            }
            resultBag = (DBag)request.getResult();
            if (resultBag != null) {
                Iterator iter = resultBag.iterator();
                if (iter.hasNext()) {
                    roid = (RasOID)iter.next();
                }
                oid = roid.toString();
                ((RasObject)obj).setOID(roid);
            } else {
                Debug.talkCritical("RasODMGImplementation.getObjectId: empty query result, cannot fetch OID.");
                oid = null;
            }
        }
        Debug.leaveVerbose("RasODMGImplementation.getObjectId: done. oid=" + oid + ".");
        return oid;
    }

    public Database getDatabase(Object obj) {
        Debug.talkCritical("RasODMGImplementation.getDatabase: not yet implemented.");
        throw new NotImplementedException();
    }

    public void openDB(String name, int accessMode) throws ODMGException, ODMGRuntimeException {
        Debug.enterVerbose("RasODMGImplementation.openDB: start, db=" + name + ", accessMode=" + accessMode);
        this.databaseName = name;
        this.accessMode = accessMode;
        try {
            this.getFreeServer();
            this.executeOpenDB(this.databaseName, accessMode);
            this.dbIsOpen = 1;
        }
        catch (ODMGException e) {
            Debug.leaveCritical("RasODMGImplementation.openDB: done. Exception: " + e.getMessage());
            throw new ODMGException(e.getMessage());
        }
        catch (ODMGRuntimeException x) {
            Debug.leaveCritical("RasODMGImplementation.openDB: done. ODMGRuntimeException: " + x.getMessage());
            throw new ODMGException(x.getMessage());
        }
        Debug.leaveVerbose("RasODMGImplementation.openDB: done. OK.");
    }

    private void executeOpenDB(String name, int accessMode) throws ODMGException {
        Debug.enterVerbose("RasODMGImplementation.executeOpenDB: start, name=" + name + ", accessMode=" + accessMode);
        String params = "Command=1&Database=" + name + "&Capability=" + this.capability;
        RasHttpRequest request = new RasHttpRequest();
        request.execute(this.rasServer, params);
        this.clientID = 1;
        Debug.leaveVerbose("RasODMGImplementation.executeOpenDB: done.");
    }

    public void closeDB() throws ODMGException {
        Debug.enterVerbose("RasODMGImplementation.closeDB start.");
        this.dbIsOpen = 0;
        Debug.leaveVerbose("RasODMGImplementation.closeDB done.");
    }

    private void executeCloseDB() throws ODMGException {
        String params = "ClientID=" + this.clientID + "&Command=" + 2;
        RasHttpRequest request = new RasHttpRequest();
        request.execute(this.rasServer, params);
    }

    public void beginTA() {
        Debug.enterVerbose("RasODMGImplementation.beginTA start.");
        this.executeBeginTA();
        Debug.leaveVerbose("RasODMGImplementation.beginTA done.");
    }

    private void executeBeginTA() {
        String errorMsg = "Could not open transaction: ";
        if (this.dbIsOpen == 0) {
            throw new DatabaseClosedException(errorMsg + "database not open");
        }
        String params = "ClientID=" + this.clientID + "&Command=";
        params = this.accessMode == 1 ? params + 3 : params + 4;
        params = params + "&Capability=" + this.capability;
        RasHttpRequest request = new RasHttpRequest();
        try {
            request.execute(this.rasServer, params);
        }
        catch (RasQueryExecutionFailedException e) {
            Debug.talkWarning("RasODMGImplementation.executeBeginTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
        }
    }

    public boolean isOpenTA() {
        Debug.enterVerbose("RasODMGImplementation.isOpenTA start.");
        boolean result = false;
        String params = "ClientID=" + this.clientID + "&Command=" + 7;
        RasHttpRequest request = new RasHttpRequest();
        try {
            request.execute(this.rasServer, params);
            result = request.getResultType() == 99;
        }
        catch (RasQueryExecutionFailedException e) {
            Debug.talkWarning("RasODMGImplementation.isOpenTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
            result = false;
        }
        Debug.leaveVerbose("RasODMGImplementation.isOpenTA done. result=" + result);
        return result;
    }

    public void commitTA() {
        Debug.enterVerbose("RasODMGImplementation.commitTA start.");
        try {
            this.executeCommitTA();
            this.executeCloseDB();
        }
        catch (ODMGException e) {
            Debug.talkWarning("RasODMGImplementation.commitTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
        }
        Debug.leaveVerbose("RasODMGImplementation.commitTA done.");
    }

    private void executeCommitTA() {
        String errorMsg = "Could not commit transaction: ";
        if (this.dbIsOpen == 0) {
            throw new DatabaseClosedException(errorMsg + "database not open");
        }
        String params = "ClientID=" + this.clientID + "&Command=" + 5;
        RasHttpRequest request = new RasHttpRequest();
        try {
            request.execute(this.rasServer, params);
        }
        catch (RasQueryExecutionFailedException e) {
            Debug.talkWarning("RasODMGImplementation.executeCommitTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
        }
    }

    public void abortTA() {
        Debug.enterVerbose("RasODMGImplementation.abortTA start.");
        try {
            this.executeAbortTA();
            this.executeCloseDB();
        }
        catch (ODMGException e) {
            Debug.talkWarning("RasODMGImplementation.abortTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
        }
        Debug.leaveVerbose("RasODMGImplementation.abortTA done.");
    }

    private void executeAbortTA() {
        String errorMsg = "Cannot abort transaction: ";
        if (this.dbIsOpen == 0) {
            throw new DatabaseClosedException(errorMsg + "database not open");
        }
        String params = "ClientID=" + this.clientID + "&Command=" + 6;
        RasHttpRequest request = new RasHttpRequest();
        try {
            request.execute(this.rasServer, params);
        }
        catch (RasQueryExecutionFailedException e) {
            Debug.talkWarning("RasODMGImplementation.executeAbortTA: " + e.getMessage());
            this.errorStatus = e.getMessage();
        }
    }

    public void setMaxRetry(int newRetry) {
        Debug.talkVerbose("RasODMGImplementation.setMaxRetry to " + newRetry + ".");
        this.maxRetry = newRetry;
    }

    public int getMaxRetry() {
        Debug.talkVerbose("RasODMGImplementation.getMaxRetry: maxRetry=" + this.maxRetry + ".");
        return this.maxRetry;
    }

    public void getFreeServer() throws RasQueryExecutionFailedException, RasConnectionFailedException {
        Debug.enterVerbose("RasODMGImplementation.getFreeServer: start.");
        String uniqueID = this.uniqueRequestID();
        int millisec = 100;
        for (int retryCount = 1; retryCount <= this.maxRetry; ++retryCount) {
            try {
                this.executeGetFreeServer(uniqueID);
                break;
            }
            catch (RasConnectionFailedException e) {
                Debug.talkCritical("RasODMGImplementation.getFreeServer: cannot obtain a free server:" + e.getMessage());
                int errno = e.getErrorNo();
                if (errno == 801 || errno == 806) {
                    Debug.talkCritical("RasODMGImplementation.getFreeServer: no free server available, errno=" + errno + ", retry #" + retryCount + " of " + this.maxRetry + " after " + (millisec *= 2) + " msecs.");
                    try {
                        Thread.sleep(millisec);
                    }
                    catch (InterruptedException intex) {}
                    continue;
                }
                Debug.talkCritical("RasODMGImplementation.getFreeServer: giving up, cannot obtain free server. marking connection as closed.");
                Debug.leaveVerbose("RasODMGImplementation.getFreeServer: done.");
                this.isOpenTA = false;
                this.dbIsOpen = 0;
                throw e;
            }
        }
        Debug.leaveVerbose("RasODMGImplementation.getFreeServer: done.");
    }

    private void executeGetFreeServer(String uniqueID) throws RasQueryExecutionFailedException, RasConnectionFailedException {
        Debug.enterVerbose("RasODMGImplementation.executeGetFreeServer: enter, uniqueID=" + uniqueID);
        try {
            Socket soclu = new Socket(this.rasMgr, this.rasMgrPort);
            Debug.talkVerbose("RasODMGImplementation.executeGetFreeServer: socket=" + soclu);
            PrintStream ps = new PrintStream(soclu.getOutputStream());
            String body = this.databaseName + " HTTP " + (this.accessMode == 1 ? "ro" : "rw") + " " + uniqueID + " \u0000";
            ps.print("POST getfreeserver HTTP/1.1\r\nAccept: text/plain\r\nContent-type: text/plain\r\nUser-Agent: RasDaMan Java Client1.0\r\nAuthorization: ras " + this.userIdentification + "\r\nContent length: " + body.length() + "\r\n\r\n" + body);
            ps.flush();
            Debug.talkVerbose("RasODMGImplementation.executeGetFreeServer: sent body=" + body);
            BufferedReader ds = new BufferedReader(new InputStreamReader(soclu.getInputStream()));
            int resultCode = this.getResultCode(ds);
            String bodyLine = this.getBodyLine(ds);
            Debug.talkVerbose("RasODMGImplementation.executeGetFreeServer: received result code=" + resultCode + ", bodyLine=" + bodyLine);
            ps.close();
            ds.close();
            soclu.close();
            Debug.talkVerbose("RasODMGImplementation.executeGetFreeServer: socket closed: " + soclu);
            if (resultCode != 200) {
                Debug.talkSparse("RasODMGImplementation.executeGetFreeServer: bodyLine=" + bodyLine);
                StringTokenizer t = new StringTokenizer(bodyLine, " ");
                String errorStr = t.nextToken();
                int errorCode = Integer.parseInt(errorStr);
                if (resultCode < 1000) {
                    Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer: done. connection failed, code=" + errorCode);
                    throw new RasConnectionFailedException(errorCode, null);
                }
                Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer: done. request format error, code=" + errorCode);
                throw new RasConnectionFailedException(808, " code=" + errorCode);
            }
            StringTokenizer t = new StringTokenizer(bodyLine, " ");
            String host = t.nextToken();
            String port = t.nextToken(" ");
            this.capability = t.nextToken(" \t\r\n\u0000");
            this.rasServer = "http://" + host + ":" + port;
        }
        catch (MalformedURLException e) {
            Debug.talkCritical("RasODMGImplementation.executeGetFreeServer: malformed URL exception: " + e.getMessage());
            Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer: done with exception: " + e.getMessage());
            throw new RasConnectionFailedException(800, this.rasMgr);
        }
        catch (IOException e) {
            Debug.talkCritical("RasODMGImplementation.executeGetFreeServer: IO exception: " + e.getMessage());
            Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer: done with exception: " + e.getMessage());
            throw new RasClientInternalException("RasODMGImplementation", "executeGetFreeServer()", e.getMessage());
        }
        Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer: done.");
    }

    public Object queryRequest(String parameters) throws RasQueryExecutionFailedException {
        Debug.enterVerbose("RasODMGImplementation.queryRequest start. parameters=" + parameters + ".");
        BenchmarkTimer qTimer = new BenchmarkTimer("queryRequest");
        qTimer.startTimer();
        RasHttpRequest request = new RasHttpRequest();
        request.execute(this.rasServer, parameters);
        qTimer.stopTimer();
        qTimer.print();
        Debug.leaveVerbose("RasODMGImplementation.executeGetFreeServer done.");
        return request.getResult();
    }

    public String getTypeStructure(String typename, int typetype) {
        Debug.talkCritical("RasODMGImplementation.getTypeStructure: not yet implemented.");
        throw new NotImplementedException();
    }

    public int getResultCode(BufferedReader ds) throws IOException {
        Debug.enterVerbose("RasODMGImplementation.getResultCode start.");
        String s = ds.readLine();
        StringTokenizer t = new StringTokenizer(s, " ");
        String http = t.nextToken();
        String resultString = t.nextToken(" ");
        int result = Integer.parseInt(resultString);
        Debug.leaveVerbose("RasODMGImplementation.getResultCode done. result=" + result + ".");
        return result;
    }

    public String getBodyLine(BufferedReader ds) throws IOException {
        String s;
        Debug.enterVerbose("RasODMGImplementation.getBodyLine start.");
        do {
            if ((s = ds.readLine()) != null) continue;
            Debug.talkCritical("RasODMGImplementation.getBodyLine: Unexpected EOF in rasmgr answer.");
            throw new IOException("Unexpected EOF in rasmgr answer.");
        } while (s.length() != 0);
        String result = ds.readLine();
        Debug.leaveVerbose("RasODMGImplementation.getBodyLine done. result=" + result + ".");
        return result;
    }

    public void setUserIdentification(String userName, String plainPass) {
        Debug.enterVerbose("RasODMGImplementation.setUserIdentification start.");
        MD5 md5 = new MD5();
        md5.Init();
        md5.Update(plainPass);
        String hex = md5.asHex();
        this.userIdentification = userName + ":" + hex;
        Debug.leaveVerbose("RasODMGImplementation.setUserIdentification done.");
    }

    private String uniqueRequestID() {
        Debug.enterVerbose("RasODMGImplementation.uniqueRequestID start.");
        if (this.strHostID == null) {
            long hostid = 0L;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                byte[] ipAddr = addr.getAddress();
                for (int i = 0; i < ipAddr.length; ++i) {
                    int ss = ipAddr[i];
                    if (ss < 0) {
                        ss = 256 + ss;
                    }
                    hostid = hostid * 256L + (long)ss;
                }
            }
            catch (UnknownHostException e) {
                Random random = new Random();
                hostid = random.nextInt();
            }
            idcounter = idcounter + 1 & 0xF;
            this.strHostID = "" + hostid + ':' + (System.currentTimeMillis() & 0xFFFFFFFFFFFFFFF0L) + idcounter;
        }
        Debug.leaveVerbose("RasODMGImplementation.uniqueRequestID done. strHostID=" + this.strHostID + ".");
        return this.strHostID;
    }
}

