/*
 * Decompiled with CFR 0.152.
 */
package rasj.odmg;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odmg.DatabaseClosedException;
import org.odmg.OQLQuery;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;
import org.odmg.TransactionNotInProgressException;
import rasj.RasGMArray;
import rasj.RasImplementationInterface;
import rasj.RasQueryExecutionFailedException;
import rasj.clientcommhttp.RasCommDefs;
import rasj.global.BenchmarkTimer;
import rasj.global.Debug;
import rasj.odmg.utils;

public class RasOQLQuery
implements OQLQuery,
RasCommDefs {
    private RasImplementationInterface rasImplementation = null;
    private String queryString = "";
    private LinkedList qParams = null;
    private int numberOfParams = 0;
    private static Pattern MDD_CONSTANT_PATTERN = Pattern.compile("\\$([0-9]+)");

    public RasOQLQuery(RasImplementationInterface imp) {
        Debug.enterVerbose("RasOQLQuery.constructor start.");
        this.rasImplementation = imp;
        Debug.leaveVerbose("RasOQLQuery.constructor done.");
    }

    public void create(String query) throws QueryInvalidException {
        Debug.talkVerbose("RasOQLQuery.create query=" + query);
        this.queryString = query;
    }

    public void bind(Object parameter) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        Debug.enterVerbose("RasOQLQuery.bind start.");
        if (this.qParams == null) {
            this.qParams = new LinkedList();
        }
        this.qParams.add(parameter);
        ++this.numberOfParams;
        Debug.enterVerbose("RasOQLQuery.bind done.");
    }

    public Object execute() throws QueryException {
        Debug.enterVerbose("RasOQLQuery.execute start.");
        BenchmarkTimer rasjQueryTimer = new BenchmarkTimer("rasjQuery");
        rasjQueryTimer.startTimer();
        String mddData = null;
        String params = null;
        String dummy = null;
        Object result = null;
        try {
            String errorMsg = "Could not execute OQL-Query: ";
            if (this.rasImplementation.dbIsOpen() == 0) {
                Debug.leaveVerbose("RasQOLQuery.execute done. database not open.");
                throw new DatabaseClosedException(errorMsg + "database not open");
            }
            params = "ClientID=" + this.rasImplementation.getClientID() + "&Command=" + 7;
            if (!this.rasImplementation.isOpenTA()) {
                Debug.leaveVerbose("RasQOLQuery.execute done. Error: no open transaction.");
                throw new TransactionNotInProgressException(errorMsg + "no open transaction");
            }
            Matcher matcher = MDD_CONSTANT_PATTERN.matcher(this.queryString);
            int counter = 0;
            while (matcher.find()) {
                try {
                    String group = matcher.group(1);
                    if (Integer.parseInt(group) <= counter) continue;
                    ++counter;
                }
                catch (NumberFormatException e) {
                    Debug.leaveVerbose("RasOQLQuery.execute done. number format exception in query parsing.");
                    throw new QueryParameterCountInvalidException("There are was a NumberFormatException while parsing the query.");
                }
            }
            if (counter != this.numberOfParams) {
                Debug.leaveVerbose("RasOQLQuery.execute done. number of parameters does not match query.");
                throw new QueryParameterCountInvalidException(counter + " variable(s) in the query string vs. " + this.numberOfParams + " parameter(s) bound to the query.");
            }
            this.queryString = dummy = this.queryString.trim();
            if (this.numberOfParams > 0) {
                counter = 0;
                ListIterator iter = this.qParams.listIterator(0);
                while (iter.hasNext()) {
                    ++counter;
                    Object item = iter.next();
                    if (item instanceof RasGMArray) {
                        RasGMArray mdd = (RasGMArray)item;
                        mddData = mddData == null ? utils.getTransferEncoding(mdd) : mddData + utils.getTransferEncoding(mdd);
                        this.queryString = utils.substitute(this.queryString, "$" + counter, "#MDD" + counter + "#");
                        continue;
                    }
                    this.queryString = utils.substitute(this.queryString, "$" + counter, item.toString());
                    iter.remove();
                    --this.numberOfParams;
                }
            }
            if (this.queryString.indexOf("select") != -1 || this.queryString.indexOf("SELECT") != -1) {
                params = "Command=8&ClientID=" + this.rasImplementation.getClientID() + "&QueryString=" + this.queryString;
            } else if (this.queryString.indexOf("insert") != -1 || this.queryString.indexOf("INSERT") != -1) {
                params = "Command=11&ClientID=" + this.rasImplementation.getClientID() + "&QueryString=" + this.queryString + "&Endianess=" + 0 + "&NumberOfQueryParameters=" + this.numberOfParams;
                if (this.numberOfParams > 0) {
                    params = params + "&BinDataSize=" + mddData.length() + "&BinData=" + mddData;
                }
            } else {
                params = "Command=9&ClientID=" + this.rasImplementation.getClientID() + "&QueryString=" + this.queryString + "&Endianess=" + 0 + "&NumberOfQueryParameters=" + this.numberOfParams;
                if (this.numberOfParams > 0) {
                    params = params + "&BinDataSize=" + mddData.length() + "&BinData=" + mddData;
                }
            }
            result = this.rasImplementation.queryRequest(params);
        }
        catch (RasQueryExecutionFailedException e) {
            Debug.leaveVerbose("RasOQLQuery.execute done. query execution failed: " + e.getMessage());
            throw new QueryException(e.getMessage());
        }
        catch (IOException e2) {
            Debug.leaveVerbose("RasOQLQuery.execute done. error while generating transfer encoding: " + e2.getMessage());
            throw new QueryException("Error while generating transfer encoding:\n" + e2.getMessage());
        }
        rasjQueryTimer.stopTimer();
        rasjQueryTimer.print();
        Debug.leaveVerbose("RasOQLQuery.execute done. result=" + result);
        return result;
    }
}

