/*
 * Decompiled with CFR 0.152.
 */
package rasj.odmg;

import rasj.RasInvalidNameException;
import rasj.RasType;
import rasj.global.RasGlobalDefs;
import rasj.odmg.RasOID;

public class RasObject
implements RasGlobalDefs {
    static final String rcsid = "@(#)Package rasj.odmg, class RasObject: $Header: /home/rasdev/CVS-repository/rasdaman/java/rasj/odmg/RasObject.java,v 1.9 2003/12/10 21:04:30 rasdev Exp $";
    protected String objectName = "";
    private String typeName = "";
    private int status = 0;
    private int lock = 0;
    private int type;
    private String typeStructure = "";
    private RasOID oid = new RasOID();

    public RasObject() {
        this.type = 0;
    }

    public RasObject(int objType) {
        this.type = objType;
    }

    public RasObject(RasObject obj, int objType) {
        this.type = objType;
    }

    public RasOID getOID() {
        return this.oid;
    }

    public void setOID(RasOID o) {
        this.oid = o;
    }

    public void setObjectName(String name) throws RasInvalidNameException {
        this.verifyName(name);
        this.objectName = name;
    }

    public void setObjectType(int t) {
        this.type = t;
    }

    public void setObjectTypeName(String name) throws RasInvalidNameException {
        this.verifyName(name);
        this.typeName = name;
    }

    public void setTypeStructure(String structure) {
        this.typeStructure = structure;
    }

    public String getTypeStructure() {
        return this.typeStructure;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getStatus() {
        return this.status;
    }

    public int getObjectType() {
        return this.type;
    }

    public String getObjectTypeName() {
        return this.typeName;
    }

    public void setStatus(int newStatus) {
        this.status = newStatus;
    }

    public int getLock() {
        return this.lock;
    }

    public void setLock(int lockMode) {
        this.lock = lockMode;
    }

    public void rasDeactivate() {
        this.objectName = "";
        this.status = 0;
        this.lock = 0;
        this.oid.rasDeactivate();
    }

    public RasType getTypeSchema() {
        return RasType.getAnyType(this.typeStructure);
    }

    private void verifyName(String name) throws RasInvalidNameException {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || Character.isLetter(c) || Character.isDigit(c) && i > 0) continue;
            throw new RasInvalidNameException(name);
        }
    }
}

