/*
 * Decompiled with CFR 0.152.
 */
package rasj.odmg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.RasGMArray;
import rasj.RasIllegalULongValueException;
import rasj.RasIllegalUShortValueException;
import rasj.RasMArrayInteger;
import rasj.RasMArrayLong;
import rasj.RasMInterval;
import rasj.RasStorageLayout;
import rasj.global.Debug;

abstract class utils {
    utils() {
    }

    static String substitute(String sourceString, String oldString, String newString) {
        Debug.enterVerbose("utils.substitute start.");
        StringBuffer buff = new StringBuffer(sourceString);
        int offset = 0;
        int buffIndex = sourceString.indexOf(oldString, offset);
        while (buffIndex != -1) {
            buff.replace(buffIndex, buffIndex + oldString.length(), newString);
            offset = buffIndex + 1;
            buffIndex = buff.toString().indexOf(oldString, offset);
        }
        String result = buff.toString();
        Debug.leaveVerbose("utils.substitute done. result=" + result);
        return result;
    }

    static String getTransferEncoding(RasGMArray mdd) throws IOException {
        int arraySize;
        Debug.enterVerbose("utils.getTransferEncoding start.");
        String tileDomain = null;
        RasMInterval domain = mdd.spatialDomain();
        long typeLength = mdd.getTypeLength();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DataOutputStream dStream = new DataOutputStream(outStream);
        tileDomain = mdd.getStorageLayout().getSpatialDomain() == null ? utils.getTilingDomain(domain, typeLength, mdd.getStorageLayout()) : mdd.getStorageLayout().getSpatialDomain().toString();
        dStream.writeInt(1);
        dStream.writeBytes(mdd.getObjectTypeName() + String.valueOf('\u0000'));
        dStream.writeBytes(mdd.getTypeStructure() + String.valueOf('\u0000'));
        dStream.writeInt((int)typeLength);
        dStream.writeBytes(domain + String.valueOf('\u0000'));
        dStream.writeBytes(tileDomain + String.valueOf('\u0000'));
        dStream.writeBytes(mdd.getOID().toString() + String.valueOf('\u0000'));
        if (mdd instanceof RasMArrayLong) {
            arraySize = (int)mdd.getArraySize();
            byte[] longArray = mdd.getArray();
            dStream.writeInt(arraySize / 2);
            for (int i = 0; i < arraySize; i += 8) {
                int j;
                for (j = 0; j < 4; ++j) {
                    if (longArray[i + j] == 0) continue;
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(longArray));
                    dis.skipBytes(i);
                    long illegalValue = dis.readLong();
                    Debug.leaveVerbose("utils.getTransferEncoding done. illegal long value.");
                    throw new RasIllegalULongValueException(illegalValue);
                }
                for (j = 4; j < 8; ++j) {
                    dStream.writeByte(longArray[i + j]);
                }
            }
        } else if (mdd instanceof RasMArrayInteger && mdd.getObjectTypeName().regionMatches(0, "UShort", 0, 5)) {
            arraySize = (int)mdd.getArraySize();
            byte[] intArray = mdd.getArray();
            dStream.writeInt(arraySize / 2);
            for (int i = 0; i < arraySize; i += 4) {
                int j;
                for (j = 0; j < 2; ++j) {
                    if (intArray[i + j] == 0) continue;
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(intArray));
                    dis.skipBytes(i);
                    int illegalValue = dis.readInt();
                    Debug.leaveVerbose("utils.getTransferEncoding done. illegal short value.");
                    throw new RasIllegalUShortValueException(illegalValue);
                }
                for (j = 2; j < 4; ++j) {
                    dStream.writeByte(intArray[i + j]);
                }
            }
        } else {
            dStream.writeInt((int)mdd.getArraySize());
            dStream.write(mdd.getArray());
        }
        dStream.flush();
        String result = outStream.toString("8859_1");
        Debug.leaveVerbose("utils.getTransferEncoding done. result=" + result);
        return result;
    }

    static String getTilingDomain(RasMInterval originalDomain, long typeLength, RasStorageLayout layout) {
        Debug.enterVerbose("utils.getTilingDomain start.");
        long tileSize = layout.getTileSize();
        int dim = originalDomain.dimension();
        double tmp = 1.0 / (double)dim;
        int size = (int)Math.pow(tileSize / typeLength, tmp) - 1;
        String retVal = "0:" + String.valueOf(size);
        for (int x = 1; x < dim; ++x) {
            retVal = retVal + ",0:" + size;
        }
        retVal = "[" + retVal + "]";
        Debug.leaveVerbose("utils.getTilingDomain done. result=" + retVal);
        return retVal;
    }
}

