/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.NotImplementedException;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasBaseType;
import rasj.RasClientInternalException;
import rasj.RasCollectionType;
import rasj.RasConnectionFailedException;
import rasj.RasGMArray;
import rasj.RasImplementationInterface;
import rasj.RasMArrayByte;
import rasj.RasMArrayDouble;
import rasj.RasMArrayFloat;
import rasj.RasMArrayInteger;
import rasj.RasMArrayLong;
import rasj.RasMArrayShort;
import rasj.RasMArrayType;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasPrimitiveType;
import rasj.RasQueryExecutionFailedException;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStructure;
import rasj.RasStructureType;
import rasj.RasType;
import rasj.RasTypeNotSupportedException;
import rasj.clientcommhttp.RasCommDefs;
import rasj.clientcommhttp.RasUtils;
import rasj.global.Debug;
import rasj.global.RasGlobalDefs;
import rasj.odmg.RasBag;
import rasj.odmg.RasDatabase;
import rasj.odmg.RasList;
import rasj.odmg.RasOID;
import rasj.odmg.RasOQLQuery;
import rasj.odmg.RasObject;
import rasj.odmg.RasSet;
import rasj.odmg.RasTransaction;
import rasj.rnp.MD5;
import rasj.rnp.RnpBaseClientComm;
import rasj.rnp.RnpFragment;

public class RasRNPImplementation
extends RnpBaseClientComm
implements RasImplementationInterface,
RasCommDefs,
RasGlobalDefs {
    public static final int pmt_none = 0;
    public static final int pmt_clientid = 1;
    public static final int pmt_rErrorString = 2;
    public static final int pmt_dbname = 3;
    public static final int pmt_accesmode = 4;
    public static final int pmt_queryString = 5;
    public static final int pmt_httpqanswer = 6;
    public static final int pmt_oidstring = 7;
    public static final int pmt_capability = 8;
    public static final int pmt_transstatus = 9;
    public static final int pmt_objecttype = 10;
    public static final int pmt_typename = 15;
    public static final int pmt_typelength = 16;
    public static final int pmt_typetype = 17;
    public static final int pmt_typestructure = 18;
    public static final int cmd_none = 0;
    public static final int cmd_connect = 1;
    public static final int cmd_disconnect = 2;
    public static final int cmd_opendb = 3;
    public static final int cmd_closedb = 4;
    public static final int cmd_beginta = 5;
    public static final int cmd_committa = 6;
    public static final int cmd_abortta = 7;
    public static final int cmd_istaopen = 8;
    public static final int cmd_queryhttp = 9;
    public static final int cmd_getnewoid = 10;
    public static final int cmd_gettypestruct = 21;
    public static final int rasServerId = 0x2EE002;
    private String rasServer = "";
    private String rasMgr = "";
    private int rasMgrPort = 7001;
    private String userIdentification = "rasguest:8e70a429be359b6dace8b5b2500dedb0";
    private String databaseName = "";
    private String capability = "dummy";
    private int maxRetry = 5;
    private RasTransaction transaction = null;
    private RasDatabase database = null;
    private RasOQLQuery query = null;
    private int accessMode = 0;
    private boolean readWrite = false;
    private int dbIsOpen = 0;
    private int taIsOpen = 0;
    private int clientID = 0;
    private String errorStatus = "";
    public static boolean useTurbo = true;
    private String strHostID = null;
    private static int idcounter = 0;

    public RasRNPImplementation(String server) {
        super(0x2EE002);
        Debug.enterVerbose("RasRNPImplementation.RasRNPImplementation start. server=" + server);
        try {
            StringTokenizer t = new StringTokenizer(server, "/");
            String xxx = t.nextToken();
            this.rasMgr = t.nextToken("/:");
            String portStr = t.nextToken(":");
            this.rasMgrPort = Integer.parseInt(portStr);
        }
        catch (NoSuchElementException e) {
            Debug.talkCritical("RasRNPImplementation.RasRNPImplementation: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.RasRNPImplementation done: " + e.getMessage());
            throw new RasConnectionFailedException(213, server);
        }
        Debug.leaveVerbose("RasRNPImplementation.RasRNPImplementation done.");
    }

    public String getErrorStatus() {
        Debug.talkSparse("RasRNPImplementation.getErrorStatus: " + this.errorStatus);
        return this.errorStatus;
    }

    public String getRasServer() {
        Debug.talkSparse("RasRNPImplementation.getRasServer: " + this.rasServer);
        return this.rasServer;
    }

    public int dbIsOpen() {
        Debug.talkSparse("RasRNPImplementation.dbIsOpen: " + this.dbIsOpen);
        return this.dbIsOpen;
    }

    public int getClientID() {
        Debug.talkSparse("RasRNPImplementation.getClientID: " + this.clientID);
        return this.clientID;
    }

    public int getAccessMode() {
        Debug.talkSparse("RasRNPImplementation.getAccessMode: " + this.accessMode);
        return this.accessMode;
    }

    public Transaction newTransaction() {
        this.transaction = new RasTransaction(this);
        Debug.talkSparse("RasRNPImplementation.newTransaction.");
        return this.transaction;
    }

    public Transaction currentTransaction() {
        Debug.talkSparse("RasRNPImplementation.currentTransaction.");
        return this.transaction;
    }

    public Database newDatabase() {
        this.database = new RasDatabase(this);
        Debug.talkSparse("RasRNPImplementation.newDatabase.");
        return this.database;
    }

    public OQLQuery newOQLQuery() {
        this.query = new RasOQLQuery(this);
        Debug.talkSparse("RasRNPImplementation.newOQLQuery.");
        return this.query;
    }

    public DList newDList() {
        Debug.talkSparse("RasRNPImplementation.newDList.");
        return new RasList();
    }

    public DBag newDBag() {
        Debug.talkSparse("RasRNPImplementation.newDBag.");
        return new RasBag();
    }

    public DSet newDSet() {
        Debug.talkSparse("RasRNPImplementation.newDSet.");
        return new RasSet();
    }

    public DArray newDArray() {
        Debug.talkCritical("RasRNPImplementation.newDArray: not yet implemented.");
        throw new NotImplementedException();
    }

    public DMap newDMap() {
        Debug.talkCritical("RasRNPImplementation.newDMap: not yet implemented.");
        throw new NotImplementedException();
    }

    public Database getDatabase(Object obj) {
        Debug.talkCritical("RasRNPImplementation.getDatabase: not yet implemented.");
        throw new NotImplementedException();
    }

    public String getObjectId(Object obj) {
        Debug.enterVerbose("RasRNPImplementation.getObjectId start.");
        String oid = null;
        if (obj instanceof RasObject) {
            RasOID roid = ((RasObject)obj).getOID();
            oid = roid.toString();
            if (!((RasObject)obj).getOID().isValid()) {
                roid = this.executeGetNewObjectId();
                oid = roid.toString();
                ((RasObject)obj).setOID(roid);
            } else {
                Debug.leaveCritical("RasRNPImplementation.getObjectId done. not yet implemented.");
                throw new NotImplementedException();
            }
        }
        Debug.leaveVerbose("RasRNPImplementation.getObjectId done. oid=" + oid);
        return oid;
    }

    public void setMaxRetry(int newRetry) {
        Debug.talkVerbose("RasRNPImplementation.setMaxRetry: setting to " + newRetry);
        this.maxRetry = newRetry;
    }

    public int getMaxRetry() {
        Debug.talkVerbose("RasRNPImplementation.getMaxRetry: is " + this.maxRetry);
        return this.maxRetry;
    }

    public void openDB(String name, int accessMode) throws ODMGException {
        Debug.enterVerbose("RasRNPImplementation.openDB start. db=" + name + ", accessMode=" + accessMode);
        this.databaseName = name;
        this.accessMode = accessMode;
        this.readWrite = accessMode != 1;
        this.getFreeServer(true);
        this.executeConnect();
        this.executeOpenDB(this.databaseName);
        this.executeCloseDB();
        this.executeDisconnect();
        this.dbIsOpen = 1;
        Debug.leaveVerbose("RasRNPImplementation.openDB done.");
    }

    public void closeDB() throws ODMGException {
        Debug.talkVerbose("RasRNPImplementation.closeDB.");
        this.dbIsOpen = 0;
    }

    public void beginTA() {
        Debug.enterVerbose("RasRNPImplementation.beginTA start.");
        if (!useTurbo) {
            try {
                this.getFreeServer(true);
                this.executeConnect();
                this.executeOpenDB(this.databaseName);
                this.executeBeginTA();
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.beginTA: " + this.errorStatus);
            }
        } else {
            try {
                this.getFreeServer(true);
                this.executeTurboBegin(this.databaseName);
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.beginTA: " + this.errorStatus);
            }
        }
        Debug.leaveVerbose("RasRNPImplementation.beginTA done.");
    }

    public boolean isOpenTA() {
        Debug.enterVerbose("RasRNPImplementation.isOpenTA start.");
        boolean result = false;
        try {
            if (this.executeIsOpenTA() != 0) {
                result = true;
            }
        }
        catch (ODMGException e) {
            this.errorStatus = e.getMessage();
            Debug.talkCritical("RasRNPImplementation.isOpenTA: " + this.errorStatus);
        }
        Debug.leaveVerbose("RasRNPImplementation.isOpenTA done. result=" + result);
        return result;
    }

    public void commitTA() {
        Debug.enterVerbose("RasRNPImplementation.commitTA start.");
        if (!useTurbo) {
            try {
                this.executeCommitTA();
                this.executeCloseDB();
                this.executeDisconnect();
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.commitTA: " + this.errorStatus);
            }
        } else {
            try {
                this.executeTurboCommit();
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.commitTA: " + this.errorStatus);
            }
        }
        Debug.leaveVerbose("RasRNPImplementation.commitTA done.");
    }

    public void abortTA() {
        Debug.enterVerbose("RasRNPImplementation.abortTA done.");
        if (!useTurbo) {
            try {
                this.executeAbortTA();
                this.executeCloseDB();
                this.executeDisconnect();
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.abortTA: " + this.errorStatus);
            }
        } else {
            try {
                this.executeTurboAbort();
            }
            catch (ODMGException e) {
                this.errorStatus = e.getMessage();
                Debug.talkCritical("RasRNPImplementation.abortTA: " + this.errorStatus);
            }
        }
        Debug.leaveVerbose("RasRNPImplementation.abortTA done.");
    }

    public Object queryRequest(String parameters) throws RasQueryExecutionFailedException {
        Debug.talkVerbose("RasRNPImplementation.queryRequest.");
        return this.executeQueryRequest(parameters);
    }

    public String getTypeStructure(String typename, int typetype) {
        Debug.talkVerbose("RasRNPImplementation.getTypeStructure.");
        return this.executeGetTypeStructure(typename, typetype);
    }

    private void executeTurboOpen(String name) throws ODMGException {
        Debug.enterVerbose("RasRNPImplementation.executeTurboOpen start. name=" + name);
        this.clientID = 0;
        this.startMessage();
        this.startFragment(1);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(8, this.capability);
        this.endFragment();
        this.startFragment(3);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(3, name);
        this.endFragment();
        this.startFragment(4);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.startFragment(2);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.endMessage();
        this.turboSendRequestGetAnswer();
        RnpFragment fragment = this.decoder.getFirstFragment();
        this.checkForError();
        this.decoder.getFirstParameter();
        this.clientID = this.decoder.getDataAsInteger();
        fragment = this.decoder.getNextFragment(fragment);
        this.checkForError();
        fragment = this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.clientID = 0;
        Debug.leaveVerbose("RasRNPImplementation.executeTurboOpen done.");
    }

    private void executeTurboBegin(String name) throws ODMGException {
        Debug.enterVerbose("RasRNPImplementation.executeTurboBegin start. name=" + name);
        this.clientID = 0;
        this.startMessage();
        this.startFragment(1);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(8, this.capability);
        this.endFragment();
        this.startFragment(3);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(3, name);
        this.endFragment();
        this.startFragment(5);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterInt32(4, this.readWrite ? 1 : 0);
        this.endFragment();
        this.endMessage();
        this.turboSendRequestGetAnswer();
        RnpFragment fragment = this.decoder.getFirstFragment();
        this.checkForError();
        this.decoder.getFirstParameter();
        this.clientID = this.decoder.getDataAsInteger();
        fragment = this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.decoder.getNextFragment(fragment);
        this.checkForError();
        Debug.leaveVerbose("RasRNPImplementation.executeTurboBegin done.");
    }

    private void executeTurboCommit() throws ODMGException {
        Debug.enterVerbose("RasRNPImplementation.executeTurboCommit start.");
        this.startMessage();
        this.startFragment(6);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.startFragment(4);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.startFragment(2);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.endMessage();
        this.turboSendRequestGetAnswer();
        RnpFragment fragment = this.decoder.getFirstFragment();
        this.checkForError();
        fragment = this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.clientID = 0;
        Debug.leaveVerbose("RasRNPImplementation.executeTurboCommit done.");
    }

    private void executeTurboAbort() throws ODMGException {
        Debug.enterVerbose("RasRNPImplementation.executeTurboAbort start.");
        this.startMessage();
        this.startFragment(7);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.startFragment(4);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.startFragment(2);
        this.encoder.addParameterInt32(1, this.clientID);
        this.endFragment();
        this.endMessage();
        this.turboSendRequestGetAnswer();
        RnpFragment fragment = this.decoder.getFirstFragment();
        this.checkForError();
        fragment = this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.decoder.getNextFragment(fragment);
        this.checkForError();
        this.clientID = 0;
        Debug.leaveVerbose("RasRNPImplementation.executeTurboAbort done.");
    }

    private RasOID executeGetNewObjectId() {
        Debug.enterVerbose("RasRNPImplementation.executeGetNewObjectId start.");
        this.startRequest(10);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterInt32(10, 1);
        this.sendRequestGetAnswer();
        this.decoder.getFirstParameter();
        RasOID result = new RasOID(this.decoder.getDataAsString());
        Debug.leaveVerbose("RasRNPImplementation.executeGetNewObjectId done.");
        return result;
    }

    private int executeIsOpenTA() throws ODMGException {
        this.startRequest(8);
        this.encoder.addParameterInt32(1, this.clientID);
        this.sendRequestGetAnswer();
        this.decoder.getFirstParameter();
        int result = this.decoder.getDataAsInteger();
        Debug.leaveVerbose("RasRNPImplementation.executeIsOpenTA done. result=" + result);
        return result;
    }

    private String executeGetTypeStructure(String typename, int typetype) {
        this.startRequest(21);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(15, typename);
        this.encoder.addParameterInt32(18, typetype);
        this.sendRequestGetAnswer();
        this.decoder.getFirstParameter();
        int status = this.decoder.getDataAsInteger();
        Debug.leaveVerbose("RasRNPImplementation.executeGetTypeStructure done. status=" + status);
        this.decoder.getNextParameter();
        String res = this.decoder.getDataAsString();
        return res;
    }

    private void executeConnect() throws ODMGException {
        this.startRequest(1);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(8, this.capability);
        this.sendRequestGetAnswer();
        this.checkForError();
        this.decoder.getFirstParameter();
        this.clientID = this.decoder.getDataAsInteger();
    }

    private void executeDisconnect() throws ODMGException {
        this.startRequest(2);
        this.encoder.addParameterInt32(1, this.clientID);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    private void executeOpenDB(String name) throws ODMGException {
        this.startRequest(3);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterString(3, name);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    private void executeCloseDB() throws ODMGException {
        this.startRequest(4);
        this.encoder.addParameterInt32(1, this.clientID);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    private void executeBeginTA() throws ODMGException {
        this.startRequest(5);
        this.encoder.addParameterInt32(1, this.clientID);
        this.encoder.addParameterInt32(4, this.readWrite ? 1 : 0);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    private void executeCommitTA() throws ODMGException {
        this.startRequest(6);
        this.encoder.addParameterInt32(1, this.clientID);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    private void executeAbortTA() throws ODMGException {
        this.startRequest(7);
        this.encoder.addParameterInt32(1, this.clientID);
        this.sendRequestGetAnswer();
        this.checkForError();
    }

    public void getFreeServer(boolean realServer) throws RasQueryExecutionFailedException, RasConnectionFailedException {
        Debug.enterVerbose("RasRNPImplementation.getFreeServer start. realServer=" + realServer);
        String uniqueID = this.uniqueRequestID();
        int retryCount = 0;
        while (true) {
            try {
                this.executeGetFreeServer(realServer, uniqueID);
            }
            catch (RasConnectionFailedException e) {
                int errno = e.getErrorNo();
                if ((errno == 801 || errno == 806) && retryCount < this.maxRetry) {
                    int millisec = 50 * retryCount + 50;
                    if (millisec > 1000) {
                        millisec = 1000;
                    }
                    Debug.talkVerbose("RasRNPImplementation.getFreeServer: retry #" + retryCount + ", sleeping " + millisec + "msecs");
                    try {
                        Thread.sleep(millisec);
                    }
                    catch (InterruptedException intex) {}
                } else {
                    Debug.talkCritical("RasRNPImplementation.getFreeServer: " + e.getMessage());
                    Debug.leaveVerbose("RasRNPImplementation.getFreeServer done: " + e.getMessage());
                    throw e;
                }
                ++retryCount;
                continue;
            }
            break;
        }
        Debug.leaveVerbose("RasRNPImplementation.getFreeServer done.");
    }

    private void executeGetFreeServer(boolean realServer, String uniqueID) throws RasQueryExecutionFailedException, RasConnectionFailedException {
        Debug.enterVerbose("RasRNPImplementation.executeGetFreeServer start. realServer=" + realServer + ", uniqueID=" + uniqueID);
        try {
            Debug.talkVerbose("RasRNPImplementation.executeGetFreeServer: rasmgr=" + this.rasMgr + ", port=" + this.rasMgrPort);
            Socket socket = new Socket(this.rasMgr, this.rasMgrPort);
            Debug.talkVerbose("RasRNPImplementation.executeGetFreeServer: socket=" + socket);
            PrintStream ps = new PrintStream(socket.getOutputStream());
            String accessFlag = this.accessMode == 1 ? "ro" : "rw";
            String body = this.databaseName + " RNP " + accessFlag + ' ' + uniqueID + " \u0000";
            if (realServer) {
                ps.print("POST getfreeserver RNP/1.1\r\nAccept: text/plain\r\nContent-type: text/plain\r\nUser-Agent: RasDaMan Java Client1.0\r\nAuthorization: ras " + this.userIdentification + "\r\nContent length: " + body.length() + "\r\n\r\n" + body);
            } else {
                ps.print("POST getfreeserver2 RNP/1.1\r\nAccept: text/plain\r\nContent-type: text/plain\r\nUser-Agent: RasDaMan Java Client1.0\r\nAuthorization: ras " + this.userIdentification + "\r\nContent length: " + body.length() + "\r\n\r\n" + body);
            }
            ps.flush();
            BufferedReader ds = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            int resultCode = this.getResultCode(ds);
            String bodyLine = this.getBodyLine(ds);
            Debug.talkVerbose("RasRNPImplementation.executeGetFreeServer: bodyLine: " + bodyLine);
            ps.close();
            ds.close();
            socket.close();
            Debug.talkVerbose("RasRNPImplementation.executeGetFreeServer: socket closed: " + socket);
            if (resultCode != 200) {
                StringTokenizer t = new StringTokenizer(bodyLine, " ");
                String errorStr = t.nextToken();
                int errorCode = Integer.parseInt(errorStr);
                if (resultCode < 1000) {
                    Debug.talkCritical("RasRNPImplementation.executeGetFreeServer: " + errorCode);
                    Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer: done. errorcode=" + errorCode);
                    throw new RasConnectionFailedException(errorCode, null);
                }
                Debug.talkCritical("RasRNPImplementation.executeGetFreeServer: " + errorCode);
                Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer: done. errorcode=" + errorCode);
                throw new RasConnectionFailedException(808, " code=" + errorCode);
            }
            StringTokenizer t = new StringTokenizer(bodyLine, " ");
            String host = t.nextToken();
            String port = t.nextToken(" ");
            this.capability = t.nextToken(" \t\r\n\u0000");
            this.rasServer = "http://" + host + ":" + port;
            this.setConnectionParameters(host, Integer.parseInt(port));
        }
        catch (MalformedURLException e) {
            Debug.talkCritical("RasRNPImplementation.executeGetFreeServer: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer: done. " + e.getMessage());
            throw new RasConnectionFailedException(800, this.rasMgr);
        }
        catch (IOException e) {
            Debug.talkCritical("RasRNPImplementation.executeGetFreeServer: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer: done. " + e.getMessage());
            throw new RasClientInternalException("RasODMGImplementation", "getFreeServer()", e.getMessage());
        }
        catch (NumberFormatException e) {
            Debug.talkCritical("RasRNPImplementation.executeGetFreeServer: cannot decode integer: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer: done. " + e.getMessage());
            throw new RasClientInternalException("RasODMGImplementation", "getFreeServer()", e.getMessage());
        }
        Debug.leaveVerbose("RasRNPImplementation.executeGetFreeServer done.");
    }

    public int getResultCode(BufferedReader ds) throws IOException {
        Debug.enterVerbose("RasRNPImplementation.getResultCode: start.");
        String s = ds.readLine();
        StringTokenizer t = new StringTokenizer(s, " ");
        String http = t.nextToken();
        String resultString = t.nextToken(" ");
        int result = 0;
        try {
            result = Integer.parseInt(resultString);
        }
        catch (NumberFormatException e) {
            Debug.talkCritical("RasRNPImplementation.getResultCode: cannot decode integer: " + e.getMessage());
            result = 0;
        }
        Debug.leaveVerbose("RasRNPImplementation.getResultCode: done. result=" + result);
        return result;
    }

    public String getBodyLine(BufferedReader ds) throws IOException {
        String s;
        Debug.enterVerbose("RasRNPImplementation.getBodyLine: start.");
        do {
            if ((s = ds.readLine()) != null) continue;
            Debug.talkCritical("RasRNPImplementation.getBodyLine: done. Unexpected EOF in rasmgr answer.");
            Debug.leaveVerbose("RasRNPImplementation.getBodyLine: done, with eof exception.");
            throw new IOException("Unexpected EOF in rasmgr answer.");
        } while (s.length() != 0);
        String result = ds.readLine();
        Debug.leaveVerbose("RasRNPImplementation.getBodyLine: done. result=" + result);
        return result;
    }

    private Object executeQueryRequest(String parameters) throws RasQueryExecutionFailedException {
        Debug.enterVerbose("RasRNPImplementation.executeQueryRequest: start. parameters=" + parameters);
        this.startRequest(9);
        this.encoder.addParameterInt32(1, this.clientID);
        try {
            this.encoder.addParameterOpaque(5, parameters.getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.talkCritical("RasRNPImplementation.executeQueryRequest: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.executeQueryRequest: done, " + e.getMessage());
            throw new RasClientInternalException("RasRNPImplementation", "executeQueryRequest()", e.getMessage());
        }
        this.sendRequestGetAnswer();
        this.checkForError();
        this.decoder.getFirstParameter();
        Object result = this.getResponse(this.decoder.getDataOpaque());
        Debug.leaveVerbose("RasRNPImplementation.executeQueryRequest: done. result=" + result);
        return result;
    }

    private Object getResponse(byte[] opaqueAnswer) throws RasQueryExecutionFailedException {
        Debug.enterVerbose("RasRNPImplementation.getResponse: start.");
        Object result = null;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(opaqueAnswer));
        byte[] b1 = new byte[1];
        byte[] b4 = new byte[4];
        byte endianess = 0;
        String collType = null;
        int numberOfResults = 0;
        int dataSize = 0;
        byte[] binData = null;
        int readBytes = 0;
        int readBytesTmp = 0;
        RasGMArray res = null;
        try {
            in.read(b1);
            byte resultType = b1[0];
            switch (resultType) {
                case 98: 
                case 99: {
                    break;
                }
                case 1: {
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    collType = RasUtils.readString(in);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    numberOfResults = RasUtils.ubytesToInt(b4, endianess);
                    RasBag resultBag = new RasBag();
                    String mddBaseType = null;
                    String domain = null;
                    String oid = "";
                    RasOID roid = null;
                    for (int x = 0; x < numberOfResults; ++x) {
                        mddBaseType = RasUtils.readString(in);
                        domain = RasUtils.readString(in);
                        oid = RasUtils.readString(in);
                        roid = new RasOID(oid);
                        while (in.available() < 4) {
                        }
                        in.read(b4);
                        dataSize = RasUtils.ubytesToInt(b4, endianess);
                        binData = new byte[dataSize];
                        readBytesTmp = 0;
                        for (readBytes = 0; readBytesTmp != -1 && readBytes < dataSize; readBytes += readBytesTmp) {
                            readBytesTmp = in.read(binData, readBytes, dataSize - readBytes);
                        }
                        RasType rType = RasType.getAnyType(mddBaseType);
                        RasBaseType rb = null;
                        if (!rType.getClass().getName().equals("rasj.RasMArrayType")) {
                            Debug.talkCritical("RasRNPImplementation.getResponse: collection element is no MArray.");
                            Debug.leaveVerbose("RasRNPImplementation.getResponse: done, with exception.");
                            throw new RasClientInternalException("RasHttpRequest", "execute()", "element of MDD Collection is no MArray");
                        }
                        RasMArrayType tmp = (RasMArrayType)rType;
                        rb = tmp.getBaseType();
                        if (rb.isBaseType()) {
                            if (rb.isStructType()) {
                                RasStructureType sType = (RasStructureType)rb;
                                res = new RasGMArray(new RasMInterval(domain), 0L);
                                res.setTypeLength(rb.getSize());
                                res.setArraySize(dataSize);
                                res.setArray(binData);
                                res.setTypeStructure(mddBaseType);
                                resultBag.add(res);
                                continue;
                            }
                            RasPrimitiveType pType = (RasPrimitiveType)rb;
                            switch (pType.getTypeID()) {
                                case 16: 
                                case 17: 
                                case 18: {
                                    res = new RasMArrayByte(new RasMInterval(domain));
                                    break;
                                }
                                case 10: {
                                    res = new RasMArrayShort(new RasMInterval(domain));
                                    break;
                                }
                                case 11: {
                                    byte[] tmData = new byte[dataSize * 2];
                                    for (int i = 0; i < dataSize * 2; i += 4) {
                                        tmData[i] = 0;
                                        tmData[i + 1] = 0;
                                        tmData[i + 2] = binData[i / 2];
                                        tmData[i + 3] = binData[i / 2 + 1];
                                    }
                                    binData = tmData;
                                    res = new RasMArrayInteger(new RasMInterval(domain));
                                    break;
                                }
                                case 9: 
                                case 12: {
                                    res = new RasMArrayInteger(new RasMInterval(domain));
                                    break;
                                }
                                case 13: {
                                    byte[] tmpData = new byte[dataSize * 2];
                                    for (int i = 0; i < dataSize * 2; i += 8) {
                                        tmpData[i] = 0;
                                        tmpData[i + 1] = 0;
                                        tmpData[i + 2] = 0;
                                        tmpData[i + 3] = 0;
                                        tmpData[i + 4] = binData[i / 2];
                                        tmpData[i + 5] = binData[i / 2 + 1];
                                        tmpData[i + 6] = binData[i / 2 + 2];
                                        tmpData[i + 7] = binData[i / 2 + 3];
                                    }
                                    binData = tmpData;
                                    res = new RasMArrayLong(new RasMInterval(domain));
                                    break;
                                }
                                case 14: {
                                    res = new RasMArrayFloat(new RasMInterval(domain));
                                    break;
                                }
                                case 15: {
                                    res = new RasMArrayDouble(new RasMInterval(domain));
                                    break;
                                }
                                default: {
                                    res = new RasGMArray(new RasMInterval(domain), pType.getSize());
                                }
                            }
                            res.setArray(binData);
                            res.setOID(roid);
                            res.setTypeStructure(mddBaseType);
                            resultBag.add(res);
                            continue;
                        }
                        Debug.talkCritical("RasRNPImplementation.getResponse: type is not base type.");
                        Debug.leaveVerbose("RasRNPImplementation.getResponse: done, type is not base type.");
                        throw new RasClientInternalException("RasHttpRequest", "execute()", "Type of MDD is no Base Type");
                    }
                    result = resultBag;
                    in.close();
                    break;
                }
                case 2: {
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    collType = RasUtils.readString(in);
                    RasType rt = new RasType();
                    try {
                        rt = RasType.getAnyType(collType);
                    }
                    catch (Exception e) {
                        Debug.talkCritical("RasRNPImplementation.getResponse: type not supported: " + rt);
                        Debug.leaveVerbose("RasRNPImplementation.getResponse: done, unsupported type");
                        throw new RasTypeNotSupportedException(rt + " as RasCollectionType");
                    }
                    if (rt.getTypeID() != 2) {
                        Debug.leaveCritical("RasRNPImplementation.getResponse: done. type not supported: " + rt);
                        throw new RasTypeNotSupportedException(rt + " as RasCollectionType");
                    }
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    numberOfResults = RasUtils.ubytesToInt(b4, endianess);
                    RasBag resultBag = new RasBag();
                    for (int x = 0; x < numberOfResults; ++x) {
                        String elementType = RasUtils.readString(in);
                        RasType et = new RasType();
                        et = ((RasCollectionType)rt).getElementType();
                        while (in.available() < 4) {
                        }
                        in.read(b4);
                        dataSize = RasUtils.ubytesToInt(b4, endianess);
                        binData = new byte[dataSize];
                        readBytesTmp = 0;
                        for (readBytes = 0; readBytesTmp != -1 && readBytes < dataSize; readBytes += readBytesTmp) {
                            readBytesTmp = in.read(binData, readBytes, dataSize - readBytes);
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(binData);
                        DataInputStream dis = new DataInputStream(bis);
                        resultBag.add(RasRNPImplementation.getElement(dis, et, binData));
                    }
                    result = resultBag;
                    in.close();
                    break;
                }
                case 0: {
                    while (in.read(b1) == 0) {
                    }
                    endianess = b1[0];
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int errNo = RasUtils.ubytesToInt(b4, endianess);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int lineNo = RasUtils.ubytesToInt(b4, endianess);
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    int colNo = RasUtils.ubytesToInt(b4, endianess);
                    String token = RasUtils.readString(in);
                    Debug.leaveCritical("RasRNPImplementation.getResponse: query failed, errNo=" + errNo + ", lineNo=" + lineNo + ", colNo=" + colNo + ", token=" + token);
                    throw new RasQueryExecutionFailedException(errNo, lineNo, colNo, token);
                }
                case 3: {
                    while (in.available() < 4) {
                    }
                    in.read(b4);
                    result = new Integer(RasUtils.ubytesToInt(b4, endianess));
                    break;
                }
                case 4: {
                    String sys = RasUtils.readString(in);
                    String base = RasUtils.readString(in);
                    double d = in.readDouble();
                    RasBag resultBag = new RasBag();
                    resultBag.add(new RasOID(sys, base, d));
                    result = resultBag;
                    in.close();
                    break;
                }
            }
        }
        catch (IOException e) {
            Debug.talkCritical("RasRNPImplementation.getResponse: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.getResponse: done, communication exception.");
            throw new RasClientInternalException("RasRNPImplementation", "getResponse()", e.getMessage());
        }
        catch (RasResultIsNoIntervalException e) {
            Debug.talkCritical("RasRNPImplementation.getResponse: " + e.getMessage());
            Debug.leaveVerbose("RasRNPImplementation.getResponse: done, result not an interval.");
            throw new RasClientInternalException("RasRNPImplementation", "getResponse()", e.getMessage());
        }
        Debug.leaveVerbose("RasRNPImplementation.getResponse: done. result=" + result);
        return result;
    }

    public static Object getElement(DataInputStream dis, RasType et, byte[] binData) throws IOException, RasResultIsNoIntervalException {
        Object ret = null;
        switch (et.getTypeID()) {
            case 4: {
                ret = new RasMInterval(new String(binData));
                break;
            }
            case 3: {
                ret = new RasSInterval(new String(binData));
                break;
            }
            case 5: {
                ret = new RasPoint(new String(binData));
                break;
            }
            case 6: {
                ret = new RasOID(new String(binData));
                break;
            }
            case 16: 
            case 18: {
                ret = dis.readUnsignedByte();
                break;
            }
            case 17: {
                ret = dis.readByte();
                break;
            }
            case 15: {
                double d = dis.readDouble();
                ret = new Double(d);
                break;
            }
            case 14: {
                float f = dis.readFloat();
                ret = new Float(f);
                break;
            }
            case 13: {
                byte[] bu = new byte[]{0, 0, 0, 0, dis.readByte(), dis.readByte(), dis.readByte(), dis.readByte()};
                ByteArrayInputStream bis2 = new ByteArrayInputStream(bu);
                DataInputStream dis2 = new DataInputStream(bis2);
                long ul = dis2.readLong();
                ret = new Long(ul);
                break;
            }
            case 9: 
            case 12: {
                int i = dis.readInt();
                ret = new Integer(i);
                break;
            }
            case 11: {
                int j = dis.readUnsignedShort();
                ret = new Integer(j);
                break;
            }
            case 10: {
                ret = new Short(dis.readShort());
                break;
            }
            case 7: 
            case 8: {
                RasStructureType st = (RasStructureType)et;
                ret = new RasStructure(st, dis);
                break;
            }
            default: {
                Debug.talkCritical("RasRNPImplementation.getResponse: type not supported: " + et);
                Debug.leaveVerbose("RasRNPImplementation.getResponse: done, unsupported type.");
                throw new RasTypeNotSupportedException(et + " as ElementType ");
            }
        }
        return ret;
    }

    public void setUserIdentification(String userName, String plainPass) {
        Debug.enterVerbose("RasRNPImplementation.setUserIdentification: start.");
        MD5 md5 = new MD5();
        md5.Init();
        md5.Update(plainPass);
        String hex = md5.asHex();
        this.userIdentification = userName + ":" + hex;
        Debug.leaveVerbose("RasRNPImplementation.setUserIdentification: done.");
    }

    private String uniqueRequestID() {
        Debug.enterVerbose("RasRNPImplementation.uniqueRequestID: start.");
        if (this.strHostID == null) {
            long hostid = 0L;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                byte[] ipAddr = addr.getAddress();
                for (int i = 0; i < ipAddr.length; ++i) {
                    int ss = ipAddr[i];
                    if (ss < 0) {
                        ss = 256 + ss;
                    }
                    hostid = hostid * 256L + (long)ss;
                }
            }
            catch (UnknownHostException e) {
                Random random = new Random();
                hostid = random.nextInt();
            }
            idcounter = idcounter + 1 & 0xF;
            this.strHostID = "" + hostid + ':' + (System.currentTimeMillis() & 0xFFFFFFFFFFFFFFF0L) + idcounter;
        }
        Debug.leaveVerbose("RasRNPImplementation.uniqueRequestID: done. result=" + this.strHostID);
        return this.strHostID;
    }
}

