/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import rasj.RasClientInternalException;
import rasj.RasConnectionFailedException;
import rasj.RasQueryExecutionFailedException;
import rasj.global.Debug;
import rasj.rnp.RnpDecoder;
import rasj.rnp.RnpEncoder;
import rasj.rnp.RnpException;
import rasj.rnp.RnpMessage;

public class RnpBaseClientComm {
    RnpEncoder encoder;
    RnpDecoder decoder;
    int serverID;
    String rasServerHost;
    int rasServerPort;

    public RnpBaseClientComm(int serverType) {
        Debug.enterVerbose("RnpBaseClientComm.RnpBaseClientComm: start. serverType=" + serverType);
        this.encoder = new RnpEncoder();
        this.serverID = serverType;
        Debug.leaveVerbose("RnpBaseClientComm.RnpBaseClientComm: done.");
    }

    public void setConnectionParameters(String s, int p) {
        Debug.enterVerbose("RnpBaseClientComm.setConnectionParameters: start. server=" + s + ", port=" + p);
        this.rasServerHost = s;
        this.rasServerPort = p;
        Debug.leaveVerbose("RnpBaseClientComm.setConnectionParameters: done.");
    }

    public void startRequest(int commandCode) {
        Debug.enterVerbose("RnpBaseClientComm.startRequest: start. cmdCode=" + commandCode);
        this.encoder.startMessage(this.serverID);
        this.encoder.startFragment(1, commandCode);
        Debug.leaveVerbose("RnpBaseClientComm.startRequest: done.");
    }

    public void startMessage() {
        Debug.enterVerbose("RnpBaseClientComm.startMessage: start.");
        this.encoder.startMessage(this.serverID);
        Debug.leaveVerbose("RnpBaseClientComm.startMessage: done.");
    }

    public void startFragment(int commandCode) {
        Debug.enterVerbose("RnpBaseClientComm.startFragment: start. cmdCode=" + commandCode);
        this.encoder.startFragment(1, commandCode);
        Debug.leaveVerbose("RnpBaseClientComm.startFragment: done.");
    }

    public void endFragment() {
        Debug.enterVerbose("RnpBaseClientComm.endFragment: start.");
        this.encoder.endFragment();
        Debug.leaveVerbose("RnpBaseClientComm.endFragment: done.");
    }

    public void endMessage() {
        Debug.enterVerbose("RnpBaseClientComm.endMessage: start.");
        this.encoder.endMessage();
        Debug.leaveVerbose("RnpBaseClientComm.endMessage: done.");
    }

    public void turboSendRequestGetAnswer() {
        Debug.enterVerbose("RnpBaseClientComm.turboSendRequestGetAnswer: start.");
        RnpMessage answer = this.communicate(this.rasServerHost, this.rasServerPort, this.encoder.message);
        this.decoder = new RnpDecoder(answer);
        Debug.leaveVerbose("RnpBaseClientComm.turboSendRequestGetAnswer: done.");
    }

    public void sendRequestGetAnswer() {
        Debug.enterVerbose("RnpBaseClientComm.sendRequestGetAnswer: start.");
        this.encoder.endFragment();
        this.encoder.endMessage();
        RnpMessage answer = this.communicate(this.rasServerHost, this.rasServerPort, this.encoder.message);
        this.decoder = new RnpDecoder(answer);
        this.decoder.getFirstFragment();
        Debug.leaveVerbose("RnpBaseClientComm.sendRequestGetAnswer: done.");
    }

    public void checkForError() throws RasQueryExecutionFailedException {
        Debug.enterVerbose("RnpBaseClientComm.checkForError: start.");
        if (this.decoder.getFragmentType() != 3) {
            Debug.leaveVerbose("RnpBaseClientComm.checkForError: done.");
            return;
        }
        this.decoder.getFirstParameter();
        int errorType = this.decoder.getParameterType();
        if (errorType == 3) {
            this.decoder.getNextParameter();
            String s = this.decoder.getDataAsString();
            Debug.leaveCritical("RnpBaseClientComm.checkForError: done. query failed: " + s);
            throw new RasQueryExecutionFailedException(s);
        }
        Debug.leaveCritical("RnpBaseClientComm.checkForError: done. query failed, unexpected error: " + errorType);
        throw new RasQueryExecutionFailedException(1000, 0, 0, "");
    }

    public RnpMessage communicate(String server, int port, RnpMessage message) {
        Debug.enterVerbose("RnpBaseClientComm.communicate: start. server=" + server + ", port=" + port);
        Socket socket = null;
        RnpMessage receivedMessage = null;
        DataOutputStream dos = null;
        try {
            Debug.talkVerbose("RnpBaseClientComm.communicate: server=" + server + ", port=" + port);
            socket = new Socket(server, port);
        }
        catch (UnknownHostException e11) {
            Debug.leaveCritical("RnpBaseClientComm.communicate: error: socket target unknown: " + e11.getMessage());
            throw new RasConnectionFailedException(800, server);
        }
        catch (IOException e12) {
            Debug.leaveCritical("RnpBaseClientComm.communicate: error: socket io exception: " + e12.getMessage());
            throw new RasClientInternalException("RnpBaseClientComm", "communicate()", e12.getMessage());
        }
        try {
            dos = new DataOutputStream(socket.getOutputStream());
            message.write(dos);
        }
        catch (IOException e2) {
            Debug.leaveCritical("RnpBaseClientComm.communicate: error: cannot write to socket: " + e2.getMessage());
            throw new RasClientInternalException("RnpBaseClientComm", "communicate()", e2.getMessage());
        }
        try {
            DataInputStream dis = new DataInputStream(socket.getInputStream());
            receivedMessage = new RnpMessage();
            receivedMessage.read(dis);
            dos.close();
            dis.close();
        }
        catch (IOException e3) {
            Debug.leaveCritical("RnpBaseClientComm.communicate: error: rcv io exception: " + e3.getMessage());
            throw new RasClientInternalException("RnpBaseClientComm", "communicate()", e3.getMessage());
        }
        catch (RnpException e4) {
            Debug.leaveCritical("RnpBaseClientComm.communicate: error: RnpException: " + e4.getMessage());
            throw new RasClientInternalException("RnpBaseClientComm", "communicate()", e4.getMessage());
        }
        Debug.leaveVerbose("RnpBaseClientComm.communicate: done. result=" + receivedMessage);
        return receivedMessage;
    }
}

