/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import rasj.rnp.ParameterDouble64;
import rasj.rnp.ParameterFloat32;
import rasj.rnp.ParameterInt32;
import rasj.rnp.ParameterOpaque;
import rasj.rnp.ParameterString;
import rasj.rnp.RnpException;
import rasj.rnp.RnpFragment;
import rasj.rnp.RnpMessage;
import rasj.rnp.RnpParameter;

public class RnpDecoder {
    public RnpMessage message;
    private RnpFragment currentFragment;
    private RnpParameter currentParameter;
    private int fragmentIndex;

    RnpDecoder(RnpMessage rnpmessage) {
        this.message = rnpmessage;
        this.currentFragment = null;
        this.currentParameter = null;
        this.fragmentIndex = 0;
    }

    void verify() throws RnpException {
        if (this.message.header.protocolId != -1053982975) {
            throw new RnpException("Not a RNP message");
        }
        if (this.message.header.messageEndianness != 0) {
            throw new RnpException("Incorrect endianness");
        }
        if (this.message.header.majorVersion != 1 || this.message.header.minorVersion != 0 || this.message.header.dataStart != 64) {
            throw new RnpException("Incorrect message version");
        }
    }

    int getServerType() {
        return this.message.header.serverType;
    }

    byte getDesiredEndianness() {
        return this.message.header.desiredEndianness;
    }

    byte getMessageEndianness() {
        return this.message.header.messageEndianness;
    }

    int getMessageLength() {
        return this.message.header.totalMessageLength;
    }

    int countFragments() {
        return this.message.header.nrFragments;
    }

    byte getMajorVersion() {
        return this.message.header.majorVersion;
    }

    byte getMinorVersion() {
        return this.message.header.minorVersion;
    }

    RnpFragment getFirstFragment() {
        this.fragmentIndex = 0;
        this.currentFragment = (RnpFragment)this.message.fragments.get(0);
        return this.currentFragment;
    }

    RnpFragment getNextFragment(RnpFragment fragment) {
        ++this.fragmentIndex;
        this.currentFragment = (RnpFragment)this.message.fragments.get(this.fragmentIndex);
        return this.currentFragment;
    }

    int getFragmentType() {
        return this.currentFragment.getFragmentType();
    }

    int countParameters() {
        return this.currentFragment.countParameters();
    }

    RnpParameter getFirstParameter() {
        this.currentParameter = this.currentFragment.getFirstParameter();
        return this.currentParameter;
    }

    RnpParameter getNextParameter() {
        this.currentParameter = this.currentFragment.getNextParameter();
        return this.currentParameter;
    }

    int getParameterType() {
        return this.currentParameter.paramType;
    }

    int getDataLength() {
        return this.currentParameter.getDataLength();
    }

    int getDataType() {
        return this.currentParameter.dataType;
    }

    int getDataAsInteger() {
        return ((ParameterInt32)this.currentParameter).data;
    }

    float getDataAsFloat() {
        return ((ParameterFloat32)this.currentParameter).data;
    }

    double getDataAsDouble() {
        return ((ParameterDouble64)this.currentParameter).data;
    }

    String getDataAsString() {
        return new String(((ParameterString)this.currentParameter).data);
    }

    byte[] getDataOpaque() {
        return ((ParameterOpaque)this.currentParameter).data;
    }
}

