/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import rasj.rnp.ParameterDouble64;
import rasj.rnp.ParameterFloat32;
import rasj.rnp.ParameterInt32;
import rasj.rnp.ParameterOpaque;
import rasj.rnp.ParameterString;
import rasj.rnp.RnpException;
import rasj.rnp.RnpFragmentHeader;
import rasj.rnp.RnpParameter;

public class RnpFragment {
    RnpFragmentHeader header;
    Vector parameters;
    int parameterIndex = 0;

    RnpFragment(int fragmentType, int command) {
        this.header = new RnpFragmentHeader(fragmentType, command);
        this.parameters = new Vector();
    }

    RnpFragmentHeader getHeader() {
        return this.header;
    }

    void addParameterInt32(int parameterType, int data) {
        this.addParameter(new ParameterInt32(parameterType, data));
    }

    void addParameterFloat32(int parameterType, float data) {
        this.addParameter(new ParameterFloat32(parameterType, data));
    }

    void addParameterDouble64(int parameterType, double data) {
        this.addParameter(new ParameterDouble64(parameterType, data));
    }

    void addParameterString(int parameterType, String data) {
        this.addParameter(new ParameterString(parameterType, data));
    }

    void addParameterOpaque(int parameterType, byte[] data) {
        this.addParameter(new ParameterOpaque(parameterType, data));
    }

    private void addParameter(RnpParameter param) {
        this.parameters.add(param);
        this.header.addParameter(param.getTotalLength());
    }

    void write(DataOutputStream dataStream) throws IOException {
        this.header.write(dataStream);
        for (int i = 0; i < this.header.countParameters(); ++i) {
            RnpParameter param = (RnpParameter)this.parameters.get(i);
            param.write(dataStream);
        }
    }

    void read(DataInputStream dataStream) throws IOException, RnpException {
        this.header.read(dataStream);
        for (int i = 0; i < this.header.countParameters(); ++i) {
            RnpParameter param = RnpParameter.constructFromStream(dataStream);
            this.parameters.add(param);
        }
    }

    void print() {
        this.header.print();
        for (int i = 0; i < this.header.countParameters(); ++i) {
            System.out.print(" " + i + " ");
            RnpParameter param = (RnpParameter)this.parameters.get(i);
            param.print();
        }
    }

    int getFragmentType() {
        return this.header.fragmType;
    }

    int getCommand() {
        return this.header.command;
    }

    int countParameters() {
        return this.header.nrParams;
    }

    int getFragmentLength() {
        return this.header.totalLength;
    }

    RnpParameter getFirstParameter() {
        this.parameterIndex = 0;
        return (RnpParameter)this.parameters.get(0);
    }

    RnpParameter getNextParameter() {
        ++this.parameterIndex;
        return (RnpParameter)this.parameters.get(this.parameterIndex);
    }
}

