/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RnpFragmentHeader {
    int fragmType;
    int command;
    int nrParams;
    int totalLength;
    public static final int length = 16;

    RnpFragmentHeader(int fragmentType, int nCommand) {
        this.fragmType = fragmentType;
        this.command = nCommand;
        this.nrParams = 0;
        this.totalLength = 16;
    }

    int countParameters() {
        return this.nrParams;
    }

    void print() {
        System.out.print("  type=" + this.fragmType);
        System.out.print("  Command=" + this.command);
        System.out.print("  nrParams=" + this.nrParams);
        System.out.print("  totalLength=" + this.totalLength);
        System.out.println();
    }

    void write(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(this.fragmType);
        dataStream.writeInt(this.command);
        dataStream.writeInt(this.nrParams);
        dataStream.writeInt(this.totalLength);
    }

    void read(DataInputStream dataStream) throws IOException {
        this.fragmType = dataStream.readInt();
        this.command = dataStream.readInt();
        this.nrParams = dataStream.readInt();
        this.totalLength = dataStream.readInt();
    }

    void addParameter(int size) {
        ++this.nrParams;
        this.totalLength += size;
    }
}

