/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.rnp.RnpException;

public class RnpMessageHeader {
    int protocolId = -1053982975;
    byte messageEndianness = 0;
    byte desiredEndianness = 0;
    byte majorVersion = 1;
    byte minorVersion = 0;
    int totalMessageLength = 64;
    int nrFragments = 0;
    int serverType;
    int authInfoStart;
    int authInfoLength;
    int comprInfoStart;
    int comprInfoLength;
    int dataStart;
    int dataLength;
    public static final int length = 64;

    RnpMessageHeader(int nServerType) {
        this.serverType = nServerType;
        this.authInfoStart = 0;
        this.authInfoLength = 0;
        this.comprInfoStart = 0;
        this.comprInfoLength = 0;
        this.dataStart = 64;
        this.dataLength = 0;
    }

    int countFragments() {
        return this.nrFragments;
    }

    void print() {
        System.out.println("RNP Header");
        System.out.println(" totalLength=" + this.totalMessageLength);
        System.out.println(" nrFragments=" + this.nrFragments);
        System.out.println("  serverType=" + this.serverType);
        System.out.println("   dataStart=" + this.dataStart);
        System.out.println("  dataLength=" + this.dataLength);
        System.out.println("");
    }

    void write(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(this.protocolId);
        dataStream.writeByte(this.messageEndianness);
        dataStream.writeByte(this.desiredEndianness);
        dataStream.writeByte(this.majorVersion);
        dataStream.writeByte(this.minorVersion);
        dataStream.writeInt(this.totalMessageLength);
        dataStream.writeInt(this.nrFragments);
        dataStream.writeInt(this.serverType);
        dataStream.writeInt(this.authInfoStart);
        dataStream.writeInt(this.authInfoLength);
        dataStream.writeInt(this.comprInfoStart);
        dataStream.writeInt(this.comprInfoLength);
        dataStream.writeInt(this.dataStart);
        dataStream.writeInt(this.dataLength);
        dataStream.writeInt(0);
        dataStream.writeInt(0);
        dataStream.writeInt(0);
        dataStream.writeInt(0);
        dataStream.writeInt(0);
    }

    void read(DataInputStream dataStream) throws IOException, RnpException {
        this.protocolId = dataStream.readInt();
        this.messageEndianness = dataStream.readByte();
        this.desiredEndianness = dataStream.readByte();
        this.majorVersion = dataStream.readByte();
        this.minorVersion = dataStream.readByte();
        this.totalMessageLength = dataStream.readInt();
        this.nrFragments = dataStream.readInt();
        this.serverType = dataStream.readInt();
        this.authInfoStart = dataStream.readInt();
        this.authInfoLength = dataStream.readInt();
        this.comprInfoStart = dataStream.readInt();
        this.comprInfoLength = dataStream.readInt();
        this.dataStart = dataStream.readInt();
        this.dataLength = dataStream.readInt();
        dataStream.readInt();
        dataStream.readInt();
        dataStream.readInt();
        dataStream.readInt();
        dataStream.readInt();
    }
}

