/*
 * Decompiled with CFR 0.152.
 */
package rasj.rnp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import rasj.rnp.ParameterDouble64;
import rasj.rnp.ParameterFloat32;
import rasj.rnp.ParameterInt32;
import rasj.rnp.ParameterOpaque;
import rasj.rnp.ParameterString;
import rasj.rnp.RnpException;

public abstract class RnpParameter {
    int paramType;
    int dataType;
    int dataLength;
    int totalLength;
    public static final int headerSize = 16;

    protected RnpParameter(int pT, int dT, int dL, int tL) {
        this.paramType = pT;
        this.dataType = dT;
        this.dataLength = dL;
        this.totalLength = tL;
    }

    void print() {
        System.out.print("  Parameter type=" + this.paramType);
        System.out.print("  data type=" + this.dataType);
        System.out.print("  dataLength=" + this.dataLength);
        System.out.print("  totalLength=" + this.totalLength);
        this.printSpecific();
    }

    void write(DataOutputStream dataStream) throws IOException {
        dataStream.writeInt(this.paramType);
        dataStream.writeInt(this.dataType);
        dataStream.writeInt(this.dataLength);
        dataStream.writeInt(this.totalLength);
        this.writeSpecific(dataStream);
    }

    int getTotalLength() {
        return this.totalLength;
    }

    int getDataLength() {
        return this.dataLength;
    }

    int getPaddLength() {
        return this.totalLength - this.dataLength - 16;
    }

    void computeTotalAlignedLength() {
        this.totalLength = this.dataLength + 16 + 3 & 0xFFFFFFFC;
    }

    static RnpParameter constructFromStream(DataInputStream dataStream) throws IOException, RnpException {
        int paramType = dataStream.readInt();
        int dataType = dataStream.readInt();
        int dataLength = dataStream.readInt();
        int totalLength = dataStream.readInt();
        RnpParameter result = null;
        switch (dataType) {
            case 2: {
                result = new ParameterInt32(paramType, dataType, dataLength, totalLength);
                break;
            }
            case 3: {
                result = new ParameterFloat32(paramType, dataType, dataLength, totalLength);
                break;
            }
            case 4: {
                result = new ParameterDouble64(paramType, dataType, dataLength, totalLength);
                break;
            }
            case 1: {
                result = new ParameterString(paramType, dataType, dataLength, totalLength);
                break;
            }
            case 5: {
                result = new ParameterOpaque(paramType, dataType, dataLength, totalLength);
                break;
            }
            default: {
                throw new RnpException("Incorrect parameter data type: " + dataType);
            }
        }
        result.readSpecific(dataStream);
        return result;
    }

    int getParameterType() {
        return this.paramType;
    }

    int getDataType() {
        return this.dataType;
    }

    abstract void writeSpecific(DataOutputStream var1) throws IOException;

    abstract void readSpecific(DataInputStream var1) throws IOException;

    abstract void printSpecific();
}

