/*
 * Decompiled with CFR 0.152.
 */
package rasj.test;

import org.odmg.Database;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import rasj.RasGMArray;
import rasj.RasImplementation;
import rasj.RasMInterval;
import rasj.global.RasGlobalDefs;

public class MassLoadTest
implements RasGlobalDefs {
    public static void main(String[] args) {
        String hostname = null;
        String port = null;
        Database mydb = null;
        Transaction myta = null;
        RasGMArray myMDD = null;
        RasImplementation myApp = null;
        OQLQuery myQuery = null;
        String collectionName = "testCollection";
        int tileSize = 1000;
        int overallSize = 200000;
        int commitInterval = 50;
        if (args.length > 0 && args[0] == null) {
            System.out.println("Please provide the hostname as a parameter when calling this test-program.");
            System.exit(-1);
        } else {
            hostname = args[0];
        }
        port = args.length > 1 && args[1] != null ? args[1] : "8080";
        try {
            myApp = new RasImplementation("http://" + hostname + ":" + port);
            mydb = myApp.newDatabase();
            System.err.println("Open Database ...");
            mydb.open("RASBASE", 2);
            System.err.println("     ok.");
            myta = myApp.newTransaction();
            System.err.println("Begin transaction ...");
            myta.begin();
            System.err.println("     ok.");
            System.err.println("Create a test collection ...");
            myQuery = myApp.newOQLQuery();
            myQuery.create("create collection $1 GreySet");
            myQuery.bind(collectionName);
            myQuery.execute();
            System.err.println("     ok.");
            myta.commit();
            System.err.println("create test arrays ...");
            myMDD = new RasGMArray(new RasMInterval("[0:" + (tileSize - 1) + ",0:" + (tileSize - 1) + "]"), 1L);
            int cells = tileSize * tileSize;
            byte[] mydata = new byte[cells];
            for (int i = 0; i < cells; ++i) {
                mydata[i] = 0;
            }
            myMDD.setArray(mydata);
            myMDD.setObjectTypeName("GreyImage");
            boolean first = true;
            myta.begin();
            int dimX = 0;
            int dimY = 0;
            Object domain = null;
            int finished = 1;
            int counter = Math.abs(overallSize / tileSize);
            for (int x = 0; x < counter; ++x) {
                dimX += tileSize;
                dimY = 0;
                for (int y = 0; y < counter; ++y) {
                    RasGMArray myMDD2 = new RasGMArray(new RasMInterval("[" + String.valueOf(dimX - tileSize) + ":" + String.valueOf(dimX - 1) + "," + String.valueOf((dimY += tileSize) - tileSize) + ":" + String.valueOf(dimY - 1) + "]"), 1L);
                    cells = tileSize * tileSize;
                    byte[] mydata2 = new byte[cells];
                    for (int i = 0; i < cells; ++i) {
                        mydata2[i] = 0;
                    }
                    myMDD2.setArray(mydata2);
                    myMDD2.setObjectTypeName("GreyImage");
                    myQuery = myApp.newOQLQuery();
                    if (first) {
                        myQuery.create("insert into $1 values $2");
                        first = false;
                    } else {
                        myQuery.create("update $1 AS img SET img ASSIGN $2");
                    }
                    myQuery.bind(collectionName);
                    myQuery.bind(myMDD2);
                    System.err.println("Inserting tile " + myMDD2.spatialDomain());
                    myQuery.execute();
                    if (++finished != commitInterval) continue;
                    myta.commit();
                    System.err.println("... committed, begin new transaction ...");
                    myta = myApp.newTransaction();
                    myta.begin();
                    finished = 1;
                }
                if (dimY >= overallSize - 1) continue;
                RasGMArray myMDD3 = new RasGMArray(new RasMInterval("[" + String.valueOf(dimX - tileSize) + ":" + String.valueOf(dimX - 1) + "," + String.valueOf(dimY) + ":" + String.valueOf(overallSize - 1) + "]"), 1L);
                cells = tileSize * (overallSize - dimY);
                byte[] mydata3 = new byte[cells];
                for (int i = 0; i < cells; ++i) {
                    mydata3[i] = 0;
                }
                myMDD3.setArray(mydata3);
                myMDD3.setObjectTypeName("GreyImage");
                myQuery = myApp.newOQLQuery();
                if (first) {
                    myQuery.create("insert into $1 values $2");
                    first = false;
                } else {
                    myQuery.create("update $1 AS img SET img ASSIGN $2");
                }
                myQuery.bind(collectionName);
                myQuery.bind(myMDD3);
                System.err.println("Inserting tile " + myMDD3.spatialDomain());
                myQuery.execute();
                if (++finished != commitInterval) continue;
                myta.commit();
                System.err.println("... committed, begin new transaction ...");
                myta = myApp.newTransaction();
                myta.begin();
                finished = 1;
            }
            dimY = 0;
            if (dimX < overallSize - 1) {
                for (int y = 0; y < counter; ++y) {
                    RasGMArray myMDD4 = new RasGMArray(new RasMInterval("[" + String.valueOf(dimX) + ":" + String.valueOf(overallSize - 1) + "," + String.valueOf((dimY += tileSize) - tileSize) + ":" + String.valueOf(dimY - 1) + "]"), 1L);
                    cells = (overallSize - dimX) * tileSize;
                    byte[] mydata4 = new byte[cells];
                    for (int i = 0; i < cells; ++i) {
                        mydata4[i] = 0;
                    }
                    myMDD4.setArray(mydata4);
                    myMDD4.setObjectTypeName("GreyImage");
                    myQuery = myApp.newOQLQuery();
                    if (first) {
                        myQuery.create("insert into $1 values $2");
                        first = false;
                    } else {
                        myQuery.create("update $1 AS img SET img ASSIGN $2");
                    }
                    myQuery.bind(collectionName);
                    myQuery.bind(myMDD4);
                    System.err.println("Inserting tile " + myMDD4.spatialDomain());
                    myQuery.execute();
                    if (++finished != commitInterval) continue;
                    myta.commit();
                    System.err.println("... committed, begin new transaction ...");
                    myta = myApp.newTransaction();
                    myta.begin();
                    finished = 1;
                }
                if (dimY < overallSize - 1) {
                    RasGMArray myMDD5 = new RasGMArray(new RasMInterval("[" + String.valueOf(dimX) + ":" + String.valueOf(overallSize - 1) + "," + String.valueOf(dimY) + ":" + String.valueOf(overallSize - 1) + "]"), 1L);
                    cells = (overallSize - dimX) * (overallSize - dimY);
                    byte[] mydata5 = new byte[cells];
                    for (int i = 0; i < cells; ++i) {
                        mydata5[i] = 0;
                    }
                    myMDD5.setArray(mydata5);
                    myMDD5.setObjectTypeName("GreyImage");
                    myQuery = myApp.newOQLQuery();
                    if (first) {
                        myQuery.create("insert into $1 values $2");
                        first = false;
                    } else {
                        myQuery.create("update $1 AS img SET img ASSIGN $2");
                    }
                    myQuery.bind(collectionName);
                    myQuery.bind(myMDD5);
                    System.err.println("Inserting tile " + myMDD5.spatialDomain());
                    myQuery.execute();
                    ++finished;
                }
            }
            myta.commit();
            System.err.println("FINISHED!");
            myta = myApp.newTransaction();
            myta.begin();
            System.err.println("Drop test collection ...");
            myQuery = myApp.newOQLQuery();
            myQuery.create("drop collection $1");
            myQuery.bind(collectionName);
            myQuery.execute();
            System.err.println("     ok.");
            myta.commit();
            myta = myApp.newTransaction();
            myta.commit();
        }
        catch (Exception e) {
            System.out.println("ERROR: ");
            System.out.println(e.getMessage());
            if (myta.isOpen()) {
                System.err.println("Abort transaction ...");
                myta.abort();
            }
            System.err.println("Close database ...");
            try {
                mydb.close();
                System.err.println("     ok.");
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.err.println("Exiting...");
            System.exit(-1);
        }
    }
}

