/*
 * Decompiled with CFR 0.152.
 */
package rasj.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.odmg.Database;
import org.odmg.Implementation;
import org.odmg.ODMGException;
import rasj.RasClientInternalException;
import rasj.RasConnectionFailedException;
import rasj.RasDimensionMismatchException;
import rasj.RasGMArray;
import rasj.RasImplementation;
import rasj.RasIndexOutOfBoundsException;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasPrimitiveType;
import rasj.RasResultIsNoCellException;
import rasj.RasResultIsNoIntervalException;
import rasj.RasSInterval;
import rasj.RasStreamInputOverflowException;
import rasj.RasTypeInvalidException;
import rasj.RasTypeNotSupportedException;
import rasj.test.TestRasClientInternalException;
import rasj.test.TestRasResultIsNoCellException;
import rasj.test.TestRasResultIsNoIntervalException;
import rasj.test.testIntervals;
import rasj.test.testMArrays;

public class Systemtest_rasj {
    public static void main(String[] args) {
        String server = null;
        String port = "7001";
        boolean wrongUsage = false;
        if (args.length == 0) {
            wrongUsage = true;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("-server")) {
                server = args[i + 1];
                continue;
            }
            if (args[i].equals("-port")) {
                port = args[i + 1];
                continue;
            }
            wrongUsage = true;
        }
        if (wrongUsage) {
            System.err.println("Usage: Systemtest_rasj -s <servername> [ -p <port> ]");
            System.exit(-1);
        }
        RasImplementation myApp = new RasImplementation("http://" + server + ":" + port);
        Systemtest_rasj.testExceptions(myApp);
        testMArrays marrayTest = new testMArrays(server);
        testIntervals intervalTest = new testIntervals();
    }

    static void testExceptions(Implementation imp) {
        String logMsg;
        boolean resultIsOk = false;
        Database myDb = null;
        Object myTa = null;
        Object myQu = null;
        System.err.println("\n### Testing exceptions:");
        try {
            RasImplementation errorApp = new RasImplementation("wrongserver:8080");
            myDb = errorApp.newDatabase();
            logMsg = "Exception was not thrown";
            myDb.open("RASBASE", 2);
        }
        catch (RasConnectionFailedException e1) {
            resultIsOk = true;
            logMsg = e1.getMessage();
        }
        catch (ODMGException e2) {
            logMsg = e2.getMessage();
        }
        Systemtest_rasj.log("RasConnectionFailedException", resultIsOk, logMsg);
        resultIsOk = false;
        logMsg = "Exception was not thrown";
        try {
            RasMInterval test2 = new RasMInterval("[1:20,1:20]");
            RasMInterval test3 = new RasMInterval("[1:4,1:9,1:6]");
            RasMInterval test1 = test2.intersectionWith(test3);
        }
        catch (RasDimensionMismatchException e1) {
            resultIsOk = true;
            logMsg = e1.getMessage();
        }
        catch (Exception e2) {
            logMsg = e2.getClass().getName() + ", " + e2.getMessage();
        }
        Systemtest_rasj.log("RasDimensionMismatchException", resultIsOk, logMsg);
        resultIsOk = false;
        logMsg = "Exception was not thrown";
        try {
            RasGMArray myMDD = new RasGMArray(new RasMInterval("[1:5,1:5]"), 1L);
            byte[] retVal = myMDD.getCell(new RasPoint(4L, 7L));
        }
        catch (RasIndexOutOfBoundsException e1) {
            resultIsOk = true;
            logMsg = e1.getMessage();
        }
        catch (RasResultIsNoIntervalException e2) {
        }
        catch (RasDimensionMismatchException e3) {
            // empty catch block
        }
        Systemtest_rasj.log("RasIndexOutOfBoundsException", resultIsOk, logMsg);
        resultIsOk = false;
        logMsg = "Exception was not thrown";
        try {
            throw new TestRasClientInternalException("This is a test error");
        }
        catch (RasClientInternalException e1) {
            resultIsOk = true;
            logMsg = e1.getMessage();
            Systemtest_rasj.log("RasClientInternalException", resultIsOk, logMsg);
            resultIsOk = false;
            logMsg = "Exception was not thrown";
            try {
                throw new TestRasResultIsNoCellException();
            }
            catch (RasResultIsNoCellException e12) {
                resultIsOk = true;
                logMsg = e12.getMessage();
                Systemtest_rasj.log("RasResultIsNoCellException", resultIsOk, logMsg);
                resultIsOk = false;
                logMsg = "Exception was not thrown";
                try {
                    throw new TestRasResultIsNoIntervalException();
                }
                catch (RasResultIsNoIntervalException e13) {
                    resultIsOk = true;
                    logMsg = e13.getMessage();
                    Systemtest_rasj.log("RasResultIsNoIntervalException", resultIsOk, logMsg);
                    resultIsOk = false;
                    logMsg = "Exception was not thrown";
                    try {
                        RasMInterval int1 = new RasMInterval(2);
                        int1.stream(new RasSInterval("1:10"));
                        int1.stream(new RasSInterval("1:5"));
                        int1.stream(new RasSInterval("1:20"));
                    }
                    catch (RasResultIsNoIntervalException e14) {
                    }
                    catch (RasStreamInputOverflowException e3) {
                        resultIsOk = true;
                        logMsg = e3.getMessage();
                    }
                    Systemtest_rasj.log("RasStreamInputOverflowException", resultIsOk, logMsg);
                    resultIsOk = false;
                    logMsg = "Exception was not thrown";
                    try {
                        RasPrimitiveType myType = new RasPrimitiveType("myType", 16);
                        myType.getFloat(new Object());
                    }
                    catch (RasTypeInvalidException e3) {
                        resultIsOk = true;
                        logMsg = e3.getMessage();
                    }
                    Systemtest_rasj.log("RasTypeInvalidException", resultIsOk, logMsg);
                    resultIsOk = false;
                    logMsg = "Exception was not thrown";
                    try {
                        throw new RasTypeNotSupportedException("RAS_TEST");
                    }
                    catch (RasTypeNotSupportedException e3) {
                        resultIsOk = true;
                        logMsg = e3.getMessage();
                        Systemtest_rasj.log("RasTypeNotSupportedException", resultIsOk, logMsg);
                        return;
                    }
                }
            }
        }
    }

    static void log(String testObject, boolean resultOK, String message) {
        if (resultOK) {
            System.err.println(testObject + " ... OK\n     (" + message + ")");
        } else {
            System.err.println(testObject + " ... FAILED!\n     (" + message + ")");
            System.err.println("Continue? [y/n]");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                String answer = br.readLine();
                while (answer != "") {
                    if (answer.equals("n")) {
                        System.exit(1);
                        continue;
                    }
                    if (answer.equals("y")) continue;
                    System.err.println("Please answer y or n: ");
                    answer = br.readLine();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }
}

