/*
 * Decompiled with CFR 0.152.
 */
package rasj.test;

import rasj.RasBaseType;
import rasj.RasException;
import rasj.RasGMArray;
import rasj.RasMArrayType;
import rasj.RasMInterval;
import rasj.RasPoint;
import rasj.RasSInterval;
import rasj.RasStorageLayout;
import rasj.RasType;

public class testIntervals {
    public static void main(String[] argv) throws RasException {
        testIntervals intervalTest = new testIntervals();
    }

    public testIntervals() {
        try {
            System.out.println("\n############################ test points: ");
            RasPoint p1 = new RasPoint("[666, 888]");
            RasPoint p2 = new RasPoint(333L, 444L);
            p2 = p2.add(p2);
            boolean b1 = false;
            b1 = p2.comparedWith(p1) == 0 ? p1.equals(p2) : false;
            System.out.println("points are equal: " + b1);
            b1 = false;
            if (p1.dimension() == 2 && 2 == p2.dimension()) {
                b1 = true;
            }
            System.out.println("dimensions of points are correct: " + b1);
            b1 = false;
            p2.setItem(1, 48L);
            if (p2.item(1) == 48L) {
                b1 = true;
            }
            System.out.println("read and write access of points is OK: " + b1);
            b1 = false;
            p2.setTo(p2.mult(p1));
            if (p2.equals(new RasPoint(443556L, 42624L))) {
                b1 = true;
            }
            System.out.println("mult and setTo is OK: " + b1);
            b1 = false;
            p1.stream(3L);
            if (p1.item(0) == 3L) {
                b1 = true;
            }
            System.out.println("stream initializing of points is OK: " + b1);
            System.out.println("\n############################ test sintervals: ");
            RasSInterval s1 = new RasSInterval(100L, 200L);
            RasSInterval s2 = new RasSInterval("150:400");
            b1 = false;
            if (s2.high() == 400L) {
                b1 = true;
            }
            System.out.println("upper bound is correct: " + b1);
            b1 = false;
            b1 = s2.isLowFixed();
            System.out.println("lower bound is fix: " + b1);
            int j = s1.intersectsWith(s2);
            b1 = false;
            if (j != -1) {
                b1 = true;
            }
            System.out.println("s1 intersects with s2: " + b1);
            RasSInterval sint1 = new RasSInterval(100L, 200L);
            RasSInterval sint2 = new RasSInterval("150 :400 ");
            RasSInterval sint3 = new RasSInterval("50:180");
            b1 = false;
            sint1.setHigh('*');
            sint1.setLow(400L);
            if (sint1.low() == 400L) {
                b1 = true;
            }
            sint1.setLow('*');
            sint1.setHigh(500L);
            b1 = sint1.high() == 500L && b1;
            System.out.println("setLow and setHigh are OK: " + b1);
            sint1.setInterval('*', 500L);
            b1 = !sint1.isLowFixed();
            b1 = sint1.isHighFixed() && b1;
            System.out.println("low is open high is fixed: " + b1);
            b1 = false;
            if (sint1.intersectsWith(sint1) != -1) {
                b1 = true;
            }
            if (sint3.closureOf(sint2, sint1).equals(sint1) && sint3.closureWith(sint2).equals(sint1) && sint3.createClosure(sint2).equals(sint1)) {
                b1 = b1;
            }
            sint1.setInterval(90L, 105L);
            sint2.setInterval(100L, 110L);
            if (sint2.createDifference(sint1).equals(new RasSInterval(90L, 100L)) && sint3.createIntersection(sint2).equals(new RasSInterval(100L, 110L))) {
                boolean bl = b1 = b1;
            }
            if (sint3.createUnion(sint2).equals(sint1) && sint1.differenceOf(sint1, sint2).equals(new RasSInterval(90L, 100L)) && sint1.differenceWith(sint2).equals(new RasSInterval(100L, 110L))) {
                boolean bl = b1 = b1;
            }
            if (sint3.intersectionOf(sint2, sint1).equals(new RasSInterval(100L, 100L)) && sint3.intersectionWith(sint2).equals(new RasSInterval(100L, 100L))) {
                b1 = b1;
            }
            boolean bl = b1 = b1 && !sint3.equals(sint2);
            if (sint3.unionOf(sint1, sint2).equals(new RasSInterval(90L, 110L)) && sint3.unionWith(sint2).equals(new RasSInterval(90L, 110L))) {
                b1 = b1;
            }
            System.out.println("operations of sintervals are correct: " + b1);
            System.out.println("\n############################ test mintervals: ");
            RasMInterval mint1 = new RasMInterval("[567:3253,666:888]");
            RasMInterval mint2 = new RasMInterval("[678:4000,777:999]");
            RasMInterval mint3 = new RasMInterval("[777:900,888:1000]");
            RasMInterval mint4 = new RasMInterval(2);
            b1 = false;
            if (mint2.dimension() == 2 && mint1.dimension() == 2) {
                b1 = true;
            }
            System.out.println("dimensions of mintervals are correct: " + b1);
            b1 = false;
            mint1 = new RasMInterval("[500:3000,600:800]");
            mint2 = new RasMInterval("[600:1000,700:750]");
            b1 = mint1.intersectsWith(mint2);
            mint1 = new RasMInterval("[567:3253,666:888]");
            mint2 = new RasMInterval("[678:4000,777:999]");
            b1 = mint3.closureOf(mint2, mint1).toString().equals(new RasMInterval("[567:4000,666:999]").toString()) ? b1 : false;
            b1 = mint3.closureWith(mint2).toString().equals(new RasMInterval("[567:4000,666:999]").toString()) ? b1 : false;
            b1 = mint3.createClosure(mint2).toString().equals(new RasMInterval("[567:4000,666:999]").toString()) ? b1 : false;
            mint3 = new RasMInterval("[678:2000,777:888]");
            mint3 = mint3.createDifference(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[2000:4000,888:999]").toString()) ? b1 : false;
            mint3 = new RasMInterval("[678:2000,777:888]");
            mint3 = mint3.createDifference(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[2000:4000,888:999]").toString()) ? b1 : false;
            mint3 = new RasMInterval("[678:2000,777:888]");
            mint3 = mint3.createIntersection(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[678:2000,777:888]").toString()) ? b1 : false;
            mint3 = new RasMInterval("[678:2000,777:888]");
            mint2 = new RasMInterval("[1000:4000,750:999]");
            mint3 = mint3.createUnion(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[678:4000, 750:999]").toString()) ? b1 : false;
            mint2 = new RasMInterval("[1000:4000,800:999]");
            mint1 = mint1.differenceOf(mint3, mint2);
            b1 = mint1.toString().equals(new RasMInterval("[678:1000,750:800]").toString()) ? b1 : false;
            mint3 = mint3.intersectionOf(mint2, mint1);
            b1 = mint3.toString().equals(new RasMInterval("[1000:1000,800:800]").toString()) ? b1 : false;
            mint3 = mint3.intersectionWith(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[1000:1000,800:800]").toString()) ? b1 : false;
            b1 = b1 && !mint3.equals(mint2);
            mint3 = mint3.unionOf(mint1, mint2);
            b1 = mint3.toString().equals(new RasMInterval("[678:4000,750:999]").toString()) ? b1 : false;
            mint3 = mint3.unionWith(mint2);
            b1 = mint3.toString().equals(new RasMInterval("[678:4000,750:999]").toString()) ? b1 : false;
            mint2 = mint2.differenceWith(mint3);
            b1 = mint2.toString().equals(new RasMInterval("[678:1000,750:800]").toString()) ? b1 : false;
            System.out.println("operations of mintervals are correct: " + b1);
            System.out.println("\n############################ test types: ");
            String s = "marray <char, 1>";
            RasType rType = RasType.getAnyType(s);
            if (rType.getClass().getName().equals("rasj.RasMArrayType")) {
                RasMArrayType tmp = (RasMArrayType)rType;
                RasBaseType rb = tmp.getBaseType();
                System.out.println("OK");
            } else {
                System.out.println("element of MDD Collection is no MArray.");
            }
            boolean b3 = !rType.isStructType();
            System.out.println(b3);
            System.out.println("\n############################ test storage layout: ");
            RasGMArray myMDD = new RasGMArray(new RasMInterval("[1:400,1:400]"), 1L);
            byte[] mydata = new byte[160000];
            for (int y = 0; y < 400; ++y) {
                for (int x = 0; x < 400; ++x) {
                    mydata[y * 399 + x] = x > 99 && x < 151 || x > 299 && x < 351 ? 100 : 0;
                }
            }
            myMDD.setArray(mydata);
            myMDD.setObjectTypeName("GreyImage");
            RasStorageLayout myLayout = new RasStorageLayout();
            myLayout.setTileDomain("[1:100,1:70]");
            myLayout.setTileSize(32);
            myMDD.setStorageLayout(myLayout);
            if (myMDD.getStorageLayout().getTileSize() == 32) {
                System.out.println("OK");
            }
            RasGMArray array1 = new RasGMArray();
            RasGMArray array2 = new RasGMArray(mint1, 8L);
            myMDD.getCell(new RasPoint(1L, 1L));
            System.out.println("OK");
        }
        catch (RasException e) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!While testing!!!!!!!!!!!!!!!!!!");
            System.out.println("An RasException has occurred: " + e.getMessage());
        }
    }
}

