/*
 * Decompiled with CFR 0.152.
 */
package org.readutf.buildstore.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.readutf.buildstore.api.Build;
import org.readutf.buildstore.api.BuildMeta;
import org.readutf.buildstore.api.exception.BuildException;

public interface BuildStore {
    public boolean exists(String var1) throws BuildException;

    public Collection<BuildMeta> getBuilds() throws BuildException;

    public Build loadBuild(String var1, Integer var2) throws BuildException;

    public void saveBuild(Build var1) throws BuildException;

    default public Build loadBuild(BuildMeta buildMeta) throws BuildException {
        return this.loadBuild(buildMeta.name(), buildMeta.version());
    }

    default public @NonNull BuildMeta getLatestBuild(String name) throws BuildException {
        return this.getBuilds().stream().filter(meta -> meta.name().equalsIgnoreCase(name)).max(Comparator.comparingInt(BuildMeta::version)).orElseThrow(() -> new BuildException("No builds found for " + name));
    }

    default public @NonNull List<BuildMeta> getHistory(String name) throws BuildException {
        return this.getBuilds().stream().filter(meta -> meta.name().equalsIgnoreCase(name)).sorted(Comparator.comparingLong(BuildMeta::savedAt).reversed()).toList();
    }

    default public @NonNull List<BuildMeta> getBuildsWithTag(String name) throws BuildException {
        return this.getBuilds().stream().filter(meta -> meta.labels().contains(name)).toList();
    }
}

